/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.eval;

import de.iwes.util.timer.AbsolutePersistentTimer;
import de.iwes.util.timer.AbsoluteTimerListener;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.schedule.Schedule;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.tools.resourcemanipulator.timer.CountDownAbsoluteTimer;
import org.smartrplace.util.eval.SimpleAggregation;

public class EvalScheduleSumUpCreator
implements AbsoluteTimerListener,
Closeable {
    private final int mode;
    private final Schedule destination;
    private final AbsolutePersistentTimer timer;
    private final ApplicationManager appMan;
    protected final Map<Schedule, SchedUpdateInfo> sources = new HashMap<Schedule, SchedUpdateInfo>();
    long currentAlignedTime;
    ScheduleListener schedListener = new ScheduleListener();

    public EvalScheduleSumUpCreator(int mode, Schedule destination, List<Schedule> sources, int intervalType, TimeResource lastCallback, ApplicationManager appMan) {
        this.mode = mode;
        this.destination = destination;
        this.appMan = appMan;
        if (sources != null) {
            for (Schedule s : sources) {
                this.addSchedule(s);
            }
        }
        this.timer = new AbsolutePersistentTimer(lastCallback, intervalType, (AbsoluteTimerListener)this, appMan);
    }

    private boolean checkInputData() {
        for (SchedUpdateInfo sui2 : this.sources.values()) {
            if (sui2.lastTimestampFound >= this.currentAlignedTime - 500L) continue;
            return false;
        }
        float sumUp = new SimpleAggregation<Schedule>(){

            @Override
            protected float getValue(Schedule element) {
                SampledValue rawVal = element.getValue(EvalScheduleSumUpCreator.this.currentAlignedTime);
                if (rawVal != null) {
                    return element.getValue(EvalScheduleSumUpCreator.this.currentAlignedTime).getValue().getFloatValue();
                }
                return 0.0f;
            }
        }.getAggregatedValue(this.sources.keySet(), this.mode);
        this.destination.addValue(this.currentAlignedTime, (Value)new FloatValue(sumUp));
        return true;
    }

    public boolean addSchedule(Schedule schedule) {
        schedule.addValueListener((ResourceValueListener)this.schedListener, false);
        if (this.sources.containsKey(schedule)) {
            return false;
        }
        this.sources.put(schedule, new SchedUpdateInfo());
        return true;
    }

    public boolean removeSchedule(Schedule schedule) {
        schedule.removeValueListener((ResourceValueListener)this.schedListener);
        return this.sources.remove(schedule) != null;
    }

    public void timerElapsed(CountDownAbsoluteTimer myTimer, long absoluteTime, long timeStep) {
        this.currentAlignedTime = absoluteTime;
        final long maxEnd = System.currentTimeMillis() + 30000L;
        this.appMan.createTimer(1000L, new TimerListener(){

            public void timerElapsed(Timer timer) {
                if (EvalScheduleSumUpCreator.this.checkInputData() || System.currentTimeMillis() >= maxEnd) {
                    timer.destroy();
                }
            }
        });
    }

    @Override
    public void close() {
        this.timer.stop();
    }

    public FloatResource getDestinationParent() {
        return (FloatResource)this.destination.getParent();
    }

    public class ScheduleListener
    implements ResourceValueListener<Schedule> {
        public void resourceChanged(Schedule resource) {
            SchedUpdateInfo sui = EvalScheduleSumUpCreator.this.sources.get(resource);
            if (sui != null) {
                sui.lastTimestampFound = resource.getLastUpdateTime();
            }
            EvalScheduleSumUpCreator.this.checkInputData();
        }
    }

    public class SchedUpdateInfo {
        long lastTimestampFound = 0L;
    }
}

