/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.file;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.io.FileUtils;

public class ApacheFileAdditions {
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);

    public static String byteCountToDisplaySize(BigInteger size) {
        BigDecimal sizeBD = new BigDecimal(size);
        String displaySize = size.divide(FileUtils.ONE_YB).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(FileUtils.ONE_YB))) + " YB" : (size.divide(FileUtils.ONE_ZB).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(FileUtils.ONE_ZB))) + " ZB" : (size.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_EB_BI))) + " EB" : (size.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_PB_BI))) + " PB" : (size.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_TB_BI))) + " TB" : (size.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_GB_BI))) + " GB" : (size.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_MB_BI))) + " MB" : (size.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? ApacheFileAdditions.getThreeSigFigs(sizeBD.divide(new BigDecimal(ONE_KB_BI))) + " KB" : String.valueOf(size) + " bytes")))))));
        return displaySize;
    }

    private static String getThreeSigFigs(BigDecimal size) {
        String number = size.toString();
        StringBuffer trimmedNumber = new StringBuffer();
        int cnt = 0;
        boolean hasDecimal = false;
        for (char digit : number.toCharArray()) {
            if (cnt < 3 || !hasDecimal) {
                trimmedNumber.append(digit);
            }
            if (digit == '.') {
                hasDecimal = true;
                continue;
            }
            ++cnt;
        }
        String displaySize = trimmedNumber.toString();
        if (hasDecimal) {
            while (displaySize.endsWith("0")) {
                displaySize = displaySize.substring(0, displaySize.length() - 1);
            }
            if (displaySize.endsWith(".")) {
                displaySize = displaySize.substring(0, displaySize.length() - 1);
            }
        }
        return displaySize;
    }
}

