/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.format;

import de.iwes.util.resourcelist.SensorResourceListHelper;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.ResourceManagement;

public class ValueFormat {
    public static String floatVal(float value) {
        return ValueFormat.floatVal(value, null);
    }

    public static String floatVal(float value, String format) {
        if (Float.isNaN(value)) {
            return "n.a.";
        }
        String val = format != null ? String.format(format, Float.valueOf(value)) : String.format("%.1f", Float.valueOf(value));
        return val;
    }

    public static String celsius(float value) {
        return ValueFormat.celsius(value, 0);
    }

    public static String celsius(float value, int mode) {
        return ValueFormat.floatVal(value - 273.15f, mode == 0 ? "%.1f \u00b0C" : "%.1f");
    }

    public static String relativeTemperature(float tempVal) {
        return SensorResourceListHelper.printRelativeTempVal((float)tempVal);
    }

    public static String humidity(float humidityVal) {
        if (!Float.isNaN(humidityVal) || humidityVal < 0.0f) {
            return String.format("%.0f %%", Float.valueOf(humidityVal * 100.0f));
        }
        return "n/a";
    }

    public static String firstLowerCase(String in) {
        return in.substring(0, 1).toLowerCase() + in.substring(1);
    }

    public static String firstUpperCase(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    public static <T extends Resource> T getStdTopLevelResource(Class<T> type, ResourceManagement resMan) {
        return (T)resMan.createResource(ValueFormat.firstLowerCase(type.getSimpleName()), type);
    }

    public static String getLocaleString(OgemaHttpRequest req, Map<OgemaLocale, String> texts) {
        String text = texts.get(req.getLocale());
        if (text == null) {
            return texts.get(OgemaLocale.ENGLISH);
        }
        return text;
    }

    public static String getLocaleString(OgemaLocale locale, Map<OgemaLocale, String> texts) {
        String text = texts.get(locale);
        if (text == null) {
            return texts.get(OgemaLocale.ENGLISH);
        }
        return text;
    }
}

