/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.format;

import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.WidgetStyle;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.HtmlStyle;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.label.Header;

public class WidgetPageFormatter {
    private WidgetStyle<?> headerAlignment = WidgetData.TEXT_ALIGNMENT_LEFT;
    private boolean tableStriped = true;
    private HtmlStyle coloredRowStyle = new HtmlStyle("class", "success");
    private HtmlStyle headerRowStyle = new HtmlStyle("style", "background-color: #77933C");
    private WidgetStyle<Button> buttonStyle = ButtonData.BOOTSTRAP_GREEN;
    private String backgroundImg = null;

    public void formatPage(WidgetPage<?> page) {
        for (OgemaWidget widget : page.getAllWidgets().getWidgets()) {
            if (widget instanceof Header) {
                ((Header)widget).addDefaultStyle(this.headerAlignment);
            }
            if (!(widget instanceof Button)) continue;
            ((Button)widget).addDefaultStyle(this.buttonStyle);
        }
        if (this.backgroundImg != null) {
            page.setBackgroundImg(this.backgroundImg);
        }
    }

    public void formatStaticTable(StaticTable table) {
        HtmlItem item;
        if (this.tableStriped) {
            table.addStyle(StaticTable.TABLE_STRIPED);
        }
        this.setRowStyle(table, 0, this.headerRowStyle);
        int i = 2;
        while ((item = (HtmlItem)table.getSubItem(i)) != null) {
            item.addStyle(this.coloredRowStyle);
            i += 2;
        }
    }

    public void setHeaderAlignment(WidgetStyle<?> headerAlignment) {
        this.headerAlignment = headerAlignment;
    }

    public void areTablesStriped(boolean isStriped) {
        this.tableStriped = isStriped;
    }

    private void setRowStyle(StaticTable table, int row, HtmlStyle style) {
        HtmlItem rw = (HtmlItem)table.getSubItem(row);
        rw.addStyle(style);
    }

    public void setButtonStype(WidgetStyle<Button> style) {
        this.buttonStyle = style;
    }

    public void setBackgroundImage(String image) {
        this.backgroundImg = image;
    }
}

