/**
 * ﻿Copyright 2018 Smartrplace UG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.smartrplace.util.directobjectgui;

import java.util.LinkedHashMap;
import java.util.Map;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.smartrplace.util.directresourcegui.ResourceGUIHelper;

import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.object.widget.table.DefaultObjectRowTemplate;

public abstract class ObjectGUITableTemplate<T, R extends Resource> extends DefaultObjectRowTemplate<T> {
	protected abstract R getResource(T object, OgemaHttpRequest req);

	//private static final long IDLE_TIME_TO_CLEANUP = 60000;
	public ObjectResourceGUIHelper<T, R> mhInit = null;
	private boolean isInInit = false;
	private final ApplicationManager appMan;
	private final ApplicationManagerMinimal appManMinimal;
	protected long getFrameworkTime() {
		if(appMan != null) return appMan.getFrameworkTime();
		return appManMinimal.getFrameworkTime();
	}
	protected final WidgetPage<?> page;
	public interface ObjectTableProvider<P> {
		DynamicTable<P> getTable(OgemaHttpRequest req);
	}
	protected final ObjectTableProvider<T> tableProvider;
	
	protected final boolean hasDynamicHeader;
	protected final boolean registerDependentWidgets;
	
	//TODO: We sometimes get 2 or 3 onGET calls for the same object on the same request, which leads to a Widget with
	//   id already exists exception (IllegalArgumentException)
	/*@Deprecated
	Map<T, Set<String>> objectsInitialized = new HashMap<>();
	@Deprecated
	long lastAccessTime = -1;
	*/
	public ObjectGUITableTemplate(WidgetPage<?> page,
			T initDefaultObject, ApplicationManager appMan, ApplicationManagerMinimal appManMinimal, 
			final boolean registerDependentWidgets)  {
		this.appMan = appMan;
		this.appManMinimal = appManMinimal;
		this.page = page;
		this.tableProvider = null;
		this.hasDynamicHeader = false;
		this.registerDependentWidgets = registerDependentWidgets;
		
		init(initDefaultObject);
	}
	public ObjectGUITableTemplate(ObjectTableProvider<T> tableProvider,
			T initDefaultObject, ApplicationManager appMan, ApplicationManagerMinimal appManMinimal, 
			boolean hasDynamicHeader, final boolean registerDependentWidgets)  {
		this.appMan = appMan;
		this.appManMinimal = appManMinimal;
		this.page = null;
		this.tableProvider = tableProvider;
		this.hasDynamicHeader = hasDynamicHeader;
		this.registerDependentWidgets = registerDependentWidgets;
		
		init(initDefaultObject);
	}
	
	private void init(T initDefaultObject) {
		isInInit = true;
		addRow(initDefaultObject, null);
		isInInit = false;		
	}
	
	/**Replacement for {@link #addRow(Resource, OgemaHttpRequest)} that provides {@link ResourceGUIHelper}
	 * 
	 * @param object resource for the row
	 * @param vh
	 * @param id lineId
	 * @param req
	 * @return
	 */
	protected abstract Row addRow(T object, ObjectResourceGUIHelper<T, R> vh, String id, OgemaHttpRequest req);
	/**Overwrite to add entries into header map that are not generated by ValueReceiverHelper*/
	//protected void addToHeader(LinkedHashMap<String,Object> map) {}

	public class InitResult {
		public ObjectResourceGUIHelper<T, R> vh;
		public String id;
	}
	public InitResult initRow(T object, OgemaHttpRequest req) {
		InitResult result = new InitResult();
		
		if(isInInit) {
			if(tableProvider != null) {
				DynamicTable<T> table = tableProvider.getTable(req);
				mhInit = result.vh = new ObjectResourceGUIHelper<T, R>(table, req, (T)null, appMan, false) {

					@Override
					protected R getResource(T object, OgemaHttpRequest req) {
						return ObjectGUITableTemplate.this.getResource(object, req);
					}
					
				};
				result.vh.setDoRegisterDependentWidgets(registerDependentWidgets);
			} else {
				mhInit = result.vh = new ObjectResourceGUIHelper<T, R>(page, (T)null, appMan, false) {

					@Override
					protected R getResource(T object, OgemaHttpRequest req) {
						return ObjectGUITableTemplate.this.getResource(object, req);
					}
				};
				result.vh.setDoRegisterDependentWidgets(registerDependentWidgets);
			}
			result.id = "";
		}
		else {
			if(tableProvider != null) {
				DynamicTable<T> table = tableProvider.getTable(req);
				result.vh = new ObjectResourceGUIHelper<T, R>(table, req, object, appMan, false) {

					@Override
					protected R getResource(T object, OgemaHttpRequest req) {
						return ObjectGUITableTemplate.this.getResource(object, req);
					}
				};
				result.vh.setDoRegisterDependentWidgets(registerDependentWidgets);
			} else {
				result.vh = new ObjectResourceGUIHelper<T, R>(page, object, appMan, false) {

					@Override
					protected R getResource(T object, OgemaHttpRequest req) {
						return ObjectGUITableTemplate.this.getResource(object, req);
					}
				};
				result.vh.setDoRegisterDependentWidgets(registerDependentWidgets);
			}
			result.id = getLineId(object);
		}
		return result;
	}
	
	public Map<String,Object> getHeader() {
		if(hasDynamicHeader) return null;
		if(mhInit != null) {
			LinkedHashMap<String,Object> map2 = mhInit.getHeader();
			//addToHeader(map2);
			return map2;
		}
		throw new IllegalStateException("mhInit must be initialized before calling getHeader!");
	}
	
	@Override
	public Row addRow(T object, OgemaHttpRequest req) {
		/*if(req != null) {
			if((lastAccessTime > 0)&&(appMan.getFrameworkTime() - lastAccessTime > IDLE_TIME_TO_CLEANUP)) {
				objectsInitialized.clear();
			} else {
				if(objectsInitialized.get(object) != null && objectsInitialized.get(object).contains(req.getSessionId()))
					return null;
			}
			lastAccessTime = appMan.getFrameworkTime();
			Set<String> sessions = objectsInitialized.get(object);
			if(sessions == null) {
				sessions = new HashSet<>();
				objectsInitialized.put(object, sessions);
			}
			sessions.add(req.getSessionId());
		}*/
		InitResult initRow = initRow(object, req);
		return addRow(object, initRow.vh, initRow.id, req);
	}
}
