/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.externalviewer.extensions;

import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.reswidget.scheduleviewer.api.TimeSeriesFilterExtended;
import de.iwes.widgets.reswidget.scheduleviewer.utils.ScheduleViewerUtil;
import java.util.HashMap;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.tools.resource.util.ResourceUtils;

public class DefaultTimeSeriesFilterExtended
implements TimeSeriesFilterExtended {
    private final String id;
    private final String label;
    private final Map<ReadOnlyTimeSeries, String> shortName;
    private final Map<ReadOnlyTimeSeries, String> longName;
    private final Map<ReadOnlyTimeSeries, Class<?>> typeMap;
    private final Map<String, String> shortNameRD;
    private final Map<String, String> longNameRD;
    private final Map<String, Class<?>> typeMapRD;

    public DefaultTimeSeriesFilterExtended(String label, Map<ReadOnlyTimeSeries, String> shortName, Map<ReadOnlyTimeSeries, String> longName, Map<String, String> shortNameRD, Map<String, String> longNameRD) {
        this(ResourceUtils.getValidResourceName((String)label), label, shortName, longName, shortNameRD, longNameRD);
    }

    public DefaultTimeSeriesFilterExtended(String id, String label, Map<ReadOnlyTimeSeries, String> shortName, Map<ReadOnlyTimeSeries, String> longName, Map<String, String> shortNameRD, Map<String, String> longNameRD) {
        this(id, label, shortName, longName, shortNameRD, longNameRD, null, null);
    }

    public DefaultTimeSeriesFilterExtended(String label, Map<ReadOnlyTimeSeries, String> shortName, Map<ReadOnlyTimeSeries, String> longName, Map<String, String> shortNameRD, Map<String, String> longNameRD, Map<ReadOnlyTimeSeries, Class<?>> typeMap, Map<String, Class<?>> typeMapRD) {
        this(ResourceUtils.getValidResourceName((String)label), label, shortName, longName, shortNameRD, longNameRD, typeMap, typeMapRD);
    }

    public DefaultTimeSeriesFilterExtended(String id, String label, Map<ReadOnlyTimeSeries, String> shortName, Map<ReadOnlyTimeSeries, String> longName, Map<String, String> shortNameRD, Map<String, String> longNameRD, Map<ReadOnlyTimeSeries, Class<?>> typeMap, Map<String, Class<?>> typeMapRD) {
        this.id = id;
        this.label = label;
        this.shortName = shortName == null ? new HashMap<ReadOnlyTimeSeries, String>() : shortName;
        this.longName = longName == null ? new HashMap<ReadOnlyTimeSeries, String>() : longName;
        this.shortNameRD = shortNameRD == null ? new HashMap<String, String>() : shortNameRD;
        this.longNameRD = longNameRD == null ? new HashMap<String, String>() : longNameRD;
        this.typeMap = typeMap == null ? new HashMap() : typeMap;
        this.typeMapRD = typeMapRD == null ? new HashMap() : typeMapRD;
    }

    public String id() {
        return this.id;
    }

    public String label(OgemaLocale locale) {
        return this.label;
    }

    public boolean accept(ReadOnlyTimeSeries schedule) {
        return true;
    }

    public String shortName(ReadOnlyTimeSeries schedule) {
        String name;
        if (schedule instanceof RecordedData) {
            RecordedData rd = (RecordedData)schedule;
            name = this.shortNameRD.get(rd.getPath());
        } else {
            name = this.shortName.get(schedule);
        }
        if (name == null) {
            return ScheduleViewerUtil.getScheduleShortName((ReadOnlyTimeSeries)schedule, null);
        }
        return name;
    }

    public String longName(ReadOnlyTimeSeries schedule) {
        String name;
        if (schedule instanceof RecordedData) {
            RecordedData rd = (RecordedData)schedule;
            name = this.longNameRD.get(rd.getPath());
        } else {
            name = this.longName.get(schedule);
        }
        if (name == null) {
            return ScheduleViewerUtil.getScheduleLongName((ReadOnlyTimeSeries)schedule, (String)"nodev-info", null);
        }
        return name;
    }

    public Class<?> type(ReadOnlyTimeSeries schedule) {
        Class<?> type;
        if (schedule instanceof RecordedData) {
            RecordedData rd = (RecordedData)schedule;
            type = this.typeMapRD.get(rd.getPath());
        } else {
            type = this.typeMap.get(schedule);
        }
        if (type == null) {
            Resource parent;
            if (schedule instanceof Resource && (parent = ((Resource)schedule).getLocationResource().getParent()) instanceof SingleValueResource) {
                return parent.getResourceType();
            }
            return FloatResource.class;
        }
        return type;
    }
}

