/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.externalviewer.extensions;

import de.iwes.timeseries.eval.api.TimeSeriesData;
import de.iwes.timeseries.eval.api.TimeSeriesDataOffline;
import de.iwes.timeseries.eval.api.extended.util.TimeSeriesDataExtendedImpl;
import de.iwes.timeseries.eval.garo.api.base.GaRoDataTypeI;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.reswidget.scheduleviewer.api.ScheduleViewerConfiguration;
import de.iwes.widgets.reswidget.scheduleviewer.api.ScheduleViewerConfigurationBuilder;
import de.iwes.widgets.reswidget.scheduleviewer.api.ScheduleViewerConfigurationProvider;
import de.iwes.widgets.reswidget.scheduleviewer.api.TimeSeriesFilterExtended;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.externalviewer.extensions.DefaultDedicatedTSSessionConfiguration;
import org.ogema.externalviewer.extensions.DefaultScheduleViewerConfigurationProviderExtended;
import org.ogema.externalviewer.extensions.DefaultTimeSeriesFilterExtended;
import org.ogema.externalviewer.extensions.IntervalConfiguration;
import org.ogema.externalviewer.extensions.ScheduleViewerOpenButton;
import org.smartrplace.util.format.StringListFormatUtils;

public abstract class ScheduleViewerOpenButtonEval
extends ScheduleViewerOpenButton {
    private static final long serialVersionUID = 1L;

    protected abstract List<TimeSeriesData> getTimeseries(OgemaHttpRequest var1);

    protected abstract String getEvaluationProviderId(OgemaHttpRequest var1);

    protected abstract IntervalConfiguration getITVConfiguration(OgemaHttpRequest var1);

    public ScheduleViewerOpenButtonEval(WidgetPage<?> page, String widgetId, String text, String scheduleViewerProviderId, DefaultScheduleViewerConfigurationProviderExtended scheduleViewerProviderInstance) {
        super(page, widgetId, text, scheduleViewerProviderId, scheduleViewerProviderInstance);
    }

    public void onPrePOST(String data, OgemaHttpRequest req) {
        long endTime;
        long startTime;
        List<TimeSeriesData> input = this.getTimeseries(req);
        TimeSeriesWithFilters filteringResult = ScheduleViewerOpenButtonEval.getTimeSeriesWithFilters(input, "Filter for " + this.getEvaluationProviderId(req));
        List<TimeSeriesFilterExtended> programsInner = filteringResult.filters;
        ArrayList<List<TimeSeriesFilterExtended>> programs = new ArrayList<List<TimeSeriesFilterExtended>>();
        programs.add(programsInner);
        IntervalConfiguration itv = this.getITVConfiguration(req);
        if (itv.multiStart == null || itv.multiStart.length > 0) {
            startTime = itv.start;
            endTime = itv.end;
        } else {
            startTime = itv.multiStart[0];
            endTime = itv.multiEnd[itv.multiStart.length - 1];
        }
        ScheduleViewerConfiguration viewerConfiguration = ScheduleViewerConfigurationBuilder.newBuilder().setPrograms(programs).setStartTime(Long.valueOf(startTime)).setEndTime(Long.valueOf(endTime)).setShowManipulator(true).build();
        String ci = this.addConfig((ScheduleViewerConfigurationProvider.SessionConfiguration)new DefaultDedicatedTSSessionConfiguration(filteringResult.timeSeries, viewerConfiguration));
        this.setConfigId(ci, req);
    }

    public static String getDeviceShortId(String location) {
        String[] parts = location.split("/");
        if (parts.length < 3) {
            return "?S?";
        }
        if (!parts[0].toLowerCase().equals("homematic") && !parts[0].toLowerCase().equals("homematicip")) {
            return "?X?";
        }
        if (!parts[1].equals("devices")) {
            return "?Y?";
        }
        if (parts[2].length() < 5) {
            return parts[2];
        }
        return parts[2].substring(parts[2].length() - 4);
    }

    public static TimeSeriesWithFilters getTimeSeriesWithFilters(List<TimeSeriesData> input, String filterName) {
        TimeSeriesWithFilters result = new TimeSeriesWithFilters();
        HashMap<String, String> shortNamesRD = new HashMap<String, String>();
        HashMap<String, String> longNamesRD = new HashMap<String, String>();
        HashMap<ReadOnlyTimeSeries, String> shortNames = new HashMap<ReadOnlyTimeSeries, String>();
        HashMap<ReadOnlyTimeSeries, String> longNames = new HashMap<ReadOnlyTimeSeries, String>();
        HashMap types = new HashMap();
        HashMap typesRD = new HashMap();
        for (TimeSeriesData tsdBase : input) {
            String longName;
            String shortName;
            if (!(tsdBase instanceof TimeSeriesDataOffline)) {
                throw new IllegalStateException("getStartAndEndTime only works on TimeSeriesData input!");
            }
            TimeSeriesDataOffline tsd = (TimeSeriesDataOffline)tsdBase;
            ReadOnlyTimeSeries timeSeries = tsd.getTimeSeries();
            String tsId = timeSeries instanceof RecordedData ? ((RecordedData)timeSeries).getPath() : null;
            GaRoDataTypeI dataType = null;
            Class type = null;
            if (tsd instanceof TimeSeriesDataExtendedImpl) {
                TimeSeriesDataExtendedImpl tse = (TimeSeriesDataExtendedImpl)tsd;
                if (tse.type instanceof GaRoDataTypeI) {
                    if (tse.getIds().size() > 1) {
                        String gwId = (String)tse.getIds().get(0);
                        String prop = System.getProperty("org.ogema.evaluationofflinecontrol.scheduleviewer.expert.sensorsToFilterOut." + gwId);
                        if (prop != null) {
                            List<String> sensorsToFilterOut = Arrays.asList(prop.split(","));
                            String shortId = tse.getProperty("deviceName");
                            if (shortId != null && sensorsToFilterOut.contains(shortId)) continue;
                        }
                    }
                    String location = tsd.label(null);
                    if (tsId == null) {
                        tsId = location;
                    }
                    dataType = (GaRoDataTypeI)tse.type;
                    String inputLabel = dataType.label(null).replace("Measurement", "");
                    shortName = tse.getIds().size() > 1 && ((String)tse.getIds().get(1)).equals("##Building") ? StringListFormatUtils.getStringFromList(null, (String)tse.getIds().get(0), ScheduleViewerOpenButtonEval.getDeviceShortId(location), inputLabel) : StringListFormatUtils.getStringFromList(tse.getIds(), ScheduleViewerOpenButtonEval.getDeviceShortId(location), inputLabel);
                    longName = StringListFormatUtils.getStringFromList(tse.getIds(), tsd.label(null), inputLabel);
                } else {
                    if (tse.type instanceof Class) {
                        type = (Class)tse.type;
                    }
                    if (tse.getIds() == null) {
                        shortName = tsd.label(null);
                        longName = StringListFormatUtils.getStringFromList(null, "NoGw", tsd.label(null));
                    } else {
                        shortName = StringListFormatUtils.getStringFromList(tse.getIds(), new String[0]);
                        longName = StringListFormatUtils.getStringFromList(tse.getIds(), tsd.label(null));
                    }
                }
            } else {
                shortName = tsd.label(null);
                longName = tsd.description(null);
            }
            if (tsId == null) {
                shortNames.put(timeSeries, shortName);
                longNames.put(timeSeries, longName);
                if (dataType != null) {
                    types.put(timeSeries, dataType.representingResourceType());
                } else if (type != null) {
                    types.put(timeSeries, type);
                }
            } else {
                shortNamesRD.put(tsId, shortName);
                longNamesRD.put(tsId, longName);
                if (dataType != null) {
                    typesRD.put(tsId, dataType.representingResourceType());
                } else if (type != null) {
                    typesRD.put(tsId, type);
                }
            }
            if (timeSeries == null) continue;
            result.timeSeries.add(timeSeries);
        }
        ArrayList<TimeSeriesFilterExtended> programsInner = new ArrayList<TimeSeriesFilterExtended>();
        programsInner.add(new DefaultTimeSeriesFilterExtended(filterName, shortNames, longNames, shortNamesRD, longNamesRD, types, typesRD));
        result.filters = programsInner;
        return result;
    }

    public static class TimeSeriesWithFilters {
        public List<ReadOnlyTimeSeries> timeSeries = new ArrayList<ReadOnlyTimeSeries>();
        public List<TimeSeriesFilterExtended> filters;
    }
}

