/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.os.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import de.iwes.util.format.StringFormatHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.ogema.core.application.ApplicationManager;
import org.smartrplace.os.util.DirUtils;

public class SCPUtil {
    public static void createSourceInfo(Path dest, String source) {
        try {
            FileUtils.write((File)dest.resolve("sourceInfo.txt").toFile(), (CharSequence)source, (String)null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int fetchViaSCPCert(String sourcePath, Path destDir, String user, String password, String host, int port) {
        return SCPUtil.fetchViaSCP(sourcePath, destDir, user, password, host, port, true);
    }

    public static int fetchViaSCP(String sourcePath, Path destDir, String user, String password, String host, int port) {
        return SCPUtil.fetchViaSCP(sourcePath, destDir, user, password, host, port, false);
    }

    public static int fetchViaSCP(String sourcePath, Path destDir, String user, String password, String host, int port, boolean pwIsCertPath) {
        FileOutputStream fos = null;
        String rfile = sourcePath;
        String lfile = destDir.toString();
        DirUtils.makeSureDirExists(destDir);
        try {
            int c;
            Session session;
            String prefix = null;
            if (new File(lfile).isDirectory()) {
                prefix = lfile + File.separator;
            }
            JSch jsch = new JSch();
            if (pwIsCertPath) {
                jsch.addIdentity(password);
                session = jsch.getSession(user, host, 22);
            } else {
                session = jsch.getSession(user, host, 22);
                session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            String command = "scp -f " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SCPUtil.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? lfile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (SCPUtil.checkAck(in) != 0) {
                    throw new IllegalStateException("SCPUtil: fetch-Ex1");
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            session.disconnect();
            return 0;
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    public static int sendViaSCPCert(String sourcePath, String destDir, String user, String password, String host, int port, ApplicationManager appMan, boolean createDateDir) {
        return SCPUtil.sendViaSCP(sourcePath, destDir, user, password, host, port, appMan, true, createDateDir);
    }

    public static int sendViaSCP(String sourcePath, String destDir, String user, String password, String host, int port, ApplicationManager appMan, boolean createDateDir) {
        return SCPUtil.sendViaSCP(sourcePath, destDir, user, password, host, port, appMan, false, createDateDir);
    }

    public static int sendViaSCP(String sourcePath, String destDir, String user, String password, String host, int port, ApplicationManager appMan, boolean pwIsCertPath, boolean createDateDir) {
        String lfileG = sourcePath;
        String rfileG = destDir;
        System.out.println("++++++SCP START");
        FileInputStream fis = null;
        try {
            Session session;
            JSch jsch = new JSch();
            if (pwIsCertPath) {
                jsch.addIdentity(password);
                session = jsch.getSession(user, host, 22);
            } else {
                session = jsch.getSession(user, host, 22);
                session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            boolean ptimestamp = true;
            Path lpath = Paths.get(lfileG, new String[0]);
            final class CopyFile {
                public String lfile;
                public String rfile;

                public CopyFile(String lfile, String rfile) {
                    this.lfile = lfile;
                    this.rfile = rfile;
                }
            }
            ArrayList<CopyFile> cl = new ArrayList<CopyFile>();
            if (createDateDir && Files.isDirectory(lpath, new LinkOption[0])) {
                String dateDir = StringFormatHelper.getCurrentDateForPath((ApplicationManager)appMan);
                Channel channelSF = session.openChannel("exec");
                ((ChannelExec)channelSF).setCommand("cd " + rfileG + " && mkdir " + dateDir);
                channelSF.connect();
                channelSF.run();
                rfileG = DirUtils.appendDirForLinux(rfileG, dateDir);
                channelSF.disconnect();
                Collection fileList = FileUtils.listFiles((File)lpath.toFile(), null, (boolean)false);
                for (File f : fileList) {
                    String destFile = DirUtils.appendDirForLinux(rfileG, f.getName());
                    cl.add(new CopyFile(f.getAbsolutePath(), destFile));
                }
            } else {
                cl.add(new CopyFile(lfileG, rfileG));
            }
            for (CopyFile cf : cl) {
                int len;
                String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + cf.rfile;
                Channel channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                if (SCPUtil.checkAck(in) != 0) {
                    throw new IllegalStateException("Ex1");
                }
                File _lfile = new File(cf.lfile);
                if (ptimestamp) {
                    command = "T" + _lfile.lastModified() / 1000L + " 0";
                    command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                    out.write(command.getBytes());
                    out.flush();
                    if (SCPUtil.checkAck(in) != 0) {
                        throw new IllegalStateException("Ex2");
                    }
                }
                long filesize = _lfile.length();
                command = "C0644 " + filesize + " ";
                command = cf.lfile.lastIndexOf(File.pathSeparator) > 0 ? command + cf.lfile.substring(cf.lfile.lastIndexOf(File.pathSeparator) + 1) : command + cf.lfile;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                if (SCPUtil.checkAck(in) != 0) {
                    throw new IllegalStateException("Ex3");
                }
                fis = new FileInputStream(cf.lfile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                }
                fis.close();
                fis = null;
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (SCPUtil.checkAck(in) != 0) {
                    throw new IllegalStateException("Ex4");
                }
                out.close();
                channel.disconnect();
            }
            session.disconnect();
            System.out.println("++++++SCP END");
            return 0;
        }
        catch (Exception e) {
            System.out.println(e);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }
}

