/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.os.util;

import java.nio.file.Path;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.tools.resourcemanipulator.timer.CountDownDelayedExecutionTimer;
import org.smartrplace.os.util.FileUploadUtil;
import org.smartrplace.os.util.SendFileUntilSuccessListener;

public class SendFileUntilSuccess {
    final Path sourceToUse;
    final String dest;
    final String user;
    final String pw;
    final ApplicationManager appMan;
    final String serverPortAddress;
    SendFileUntilSuccessListener listener = null;
    int status = -10;
    int maxRetryNum = 10;
    long retryInterval = 3600000L;
    long initialDelay = 0L;
    final TimeResource serverUnavailableUntil;
    int attemptCount = 0;
    Timer t;

    public static String getServerPortAdress(String host, int port) {
        return "https://" + host + ":" + port + "/org/smartrplace/tools/upload/servlet";
    }

    public SendFileUntilSuccess(Path sourceToUse, String dest, String host, int port, String user, String pw, ApplicationManager appMan, int maxRetryNum, long retryInterval) {
        this(sourceToUse, dest, SendFileUntilSuccess.getServerPortAdress(host, port), user, pw, appMan, maxRetryNum, retryInterval);
    }

    public SendFileUntilSuccess(Path sourceToUse, String dest, String serverPortAddress, String user, String pw, ApplicationManager appMan, int maxRetryNum, long retryInterval) {
        this.maxRetryNum = maxRetryNum;
        this.sourceToUse = sourceToUse;
        this.dest = dest;
        this.user = user;
        this.pw = pw;
        this.serverPortAddress = serverPortAddress;
        this.appMan = appMan;
        this.retryInterval = retryInterval;
        this.serverUnavailableUntil = null;
        this.init();
    }

    public SendFileUntilSuccess(Path sourceToUse, String dest, String host, int port, String user, String pw, ApplicationManager appMan) {
        this(sourceToUse, dest, "https://" + host + ":" + port + "/org/smartrplace/tools/upload/servlet", user, pw, appMan, null);
    }

    public SendFileUntilSuccess(Path sourceToUse, String dest, String serverPortAddress, String user, String pw, ApplicationManager appMan, SendFileUntilSuccessListener listener) {
        this.listener = listener;
        this.sourceToUse = sourceToUse;
        this.dest = dest;
        this.appMan = appMan;
        this.serverPortAddress = serverPortAddress;
        this.user = user;
        this.pw = pw;
        this.serverUnavailableUntil = null;
        this.init();
    }

    public int getMaxRetryNum() {
        return this.maxRetryNum;
    }

    public int getStatus() {
        return this.status;
    }

    public int getNumberOfConnectAttempts() {
        return this.attemptCount;
    }

    private void init() {
        if (this.initialDelay > 0L) {
            new CountDownDelayedExecutionTimer(this.appMan, this.initialDelay){

                public void delayedExecution() {
                    SendFileUntilSuccess.this.runInit();
                }
            };
        } else {
            this.runInit();
        }
    }

    private void runInit() {
        this.status = -11;
        int code = this.performAttempt();
        if (code == -2 || code == -3) {
            this.t = this.appMan.createTimer(this.retryInterval, new TimerListener(){

                public void timerElapsed(Timer timer) {
                    SendFileUntilSuccess.this.peformReAttempt();
                }
            });
        } else if (this.listener != null) {
            this.listener.finished(this);
        }
    }

    private int performAttempt() {
        int code;
        if (this.serverUnavailableUntil != null && this.serverUnavailableUntil.getValue() > this.appMan.getFrameworkTime()) {
            code = -2;
        } else {
            code = FileUploadUtil.sendFile(this.sourceToUse, this.dest, this.user, this.pw, this.serverPortAddress, this.appMan);
            if ((code == -2 || code == -3) && this.serverUnavailableUntil != null) {
                this.serverUnavailableUntil.setValue(this.appMan.getFrameworkTime() + this.retryInterval / 2L);
            }
        }
        ++this.attemptCount;
        this.setStatus(code);
        return code;
    }

    private void peformReAttempt() {
        int code = this.performAttempt();
        this.appMan.getLogger().info("Attempt#:" + this.attemptCount + "/" + this.maxRetryNum + " Code:+code Status:" + this.status);
        if (code != -2 && code != -3 || this.attemptCount >= this.maxRetryNum) {
            this.t.destroy();
            if (this.listener != null) {
                this.listener.finished(this);
            }
            return;
        }
    }

    private void setStatus(int sendCode) {
        switch (sendCode) {
            case -1: {
                this.status = -1;
                break;
            }
            case -3: 
            case -2: {
                this.status = -1000 - this.attemptCount;
                break;
            }
            default: {
                this.status = sendCode;
            }
        }
    }
}

