/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.os.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    static final int BUFFER = 2048;

    public static Collection<File> compressEntireDirectory(Path destination, Path source) {
        Collection files2zip = FileUtils.listFiles((File)source.toFile(), null, (boolean)true);
        ZipUtil.compress(destination, files2zip, source);
        return files2zip;
    }

    public static Collection<File> compressDirectory(Path destination, Path source, long maxSize) {
        File folder = source.toFile();
        Object[] files = folder.listFiles();
        Arrays.sort(files);
        ArrayList<File> files2zip = new ArrayList<File>();
        long totalSize = 0L;
        for (int i = files.length - 1; i >= 0 && (totalSize += ((File)files[i]).length()) <= maxSize; --i) {
            files2zip.add((File)files[i]);
        }
        ZipUtil.compress(destination, files2zip, source);
        return files2zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(Path destination, Collection<File> inputFiles, Path topPath) {
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        try {
            String destDir = FilenameUtils.getPathNoEndSeparator((String)destination.toString());
            Path f = Paths.get(destDir, new String[0]);
            if (Files.notExists(f, new LinkOption[0])) {
                Files.createDirectories(f, new FileAttribute[0]);
            }
            FileOutputStream dest = new FileOutputStream(destination.toString());
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[2048];
            Logger logger = LoggerFactory.getLogger(ZipUtil.class);
            for (File input : inputFiles) {
                logger.debug("Adding: {}", (Object)input.getPath());
                try {
                    int count;
                    FileInputStream fi = new FileInputStream(input.getPath());
                    origin = new BufferedInputStream(fi, 2048);
                    ZipEntry entry = topPath == null ? new ZipEntry(input.getPath()) : new ZipEntry(topPath.relativize(input.toPath()).toString());
                    out.putNextEntry(entry);
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, count);
                    }
                    ZipUtil.closeSmoothly(origin);
                }
                catch (FileNotFoundException e) {
                    logger.warn("Could not find input file: {}, skipping it", (Object)input);
                }
                finally {
                    ZipUtil.closeSmoothly(origin);
                }
            }
            ZipUtil.closeSmoothly(out);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ZipUtil.class).error("", (Throwable)e);
        }
        finally {
            ZipUtil.closeSmoothly(out);
        }
    }

    public static boolean getFileInsideZip(String endingPath, File zipFilePath, ProcessFileInZip processor) {
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(endingPath)) continue;
                InputStream stream = zipFile.getInputStream(entry);
                processor.processFileInzip(stream);
                stream.close();
                zipFile.close();
                return true;
            }
            zipFile.close();
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void closeSmoothly(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ProcessFileInZip {
        public void processFileInzip(InputStream var1) throws IOException;
    }
}

