/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tissue.util.resource;

import org.apache.commons.lang3.ArrayUtils;
import org.ogema.core.model.array.ArrayResource;
import org.ogema.core.model.array.BooleanArrayResource;
import org.ogema.core.model.array.ByteArrayResource;
import org.ogema.core.model.array.FloatArrayResource;
import org.ogema.core.model.array.IntegerArrayResource;
import org.ogema.core.model.array.StringArrayResource;
import org.ogema.core.model.array.TimeArrayResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.recordeddata.RecordedData;

public class ValueResourceHelperSP {
    public static RecordedData getRecordedData(SingleValueResource valueResource) {
        if (valueResource instanceof FloatResource) {
            return ((FloatResource)valueResource).getHistoricalData();
        }
        if (valueResource instanceof IntegerResource) {
            return ((IntegerResource)valueResource).getHistoricalData();
        }
        if (valueResource instanceof TimeResource) {
            return ((TimeResource)valueResource).getHistoricalData();
        }
        if (valueResource instanceof BooleanResource) {
            return ((BooleanResource)valueResource).getHistoricalData();
        }
        return null;
    }

    public static String getValue(ArrayResource res) {
        Object[] array;
        if (res instanceof StringArrayResource) {
            array = ((StringArrayResource)res).getValues();
        } else if (res instanceof FloatArrayResource) {
            array = ArrayUtils.toObject((float[])((FloatArrayResource)res).getValues());
        } else if (res instanceof IntegerArrayResource) {
            array = ArrayUtils.toObject((int[])((IntegerArrayResource)res).getValues());
        } else if (res instanceof BooleanArrayResource) {
            array = ArrayUtils.toObject((boolean[])((BooleanArrayResource)res).getValues());
        } else if (res instanceof TimeArrayResource) {
            array = ArrayUtils.toObject((long[])((TimeArrayResource)res).getValues());
        } else if (res instanceof ByteArrayResource) {
            array = ArrayUtils.toObject((byte[])((ByteArrayResource)res).getValues());
        } else {
            throw new UnsupportedOperationException("ArrayResource of type " + res.getResourceType() + " not supported!");
        }
        return ValueResourceHelperSP.getAsString(array);
    }

    public static String getAsString(Object[] array) {
        return ValueResourceHelperSP.getAsString(array, false);
    }

    public static String getAsString(Object[] array, boolean addIndices) {
        String result = null;
        int idx = 0;
        for (Object obj : array) {
            String strEl = addIndices ? "[" + idx + "]:" + obj.toString() : obj.toString();
            result = result == null ? strEl : result + ", " + strEl;
            ++idx;
        }
        return result;
    }
}

