/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directobjectgui;

import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.extended.resource.DefaultResourceTemplate;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.TemplateRedirectButton;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.object.widget.popup.WidgetEntryData;
import de.iwes.widgets.resource.widget.calendar.DatepickerTimeResource;
import de.iwes.widgets.resource.widget.dropdown.ResourceDropdown;
import de.iwes.widgets.resource.widget.dropdown.ValueResourceDropdown;
import de.iwes.widgets.resource.widget.init.ResourceRedirectButton;
import de.iwes.widgets.resource.widget.textfield.BooleanResourceCheckbox;
import de.iwes.widgets.template.DisplayTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.tools.resource.util.ResourceUtils;
import org.ogema.tools.resource.util.ValueResourceUtils;

public class ObjectGUIHelperBase<T> {
    protected final WidgetPage<?> page;
    protected final OgemaWidget parent;
    protected final OgemaHttpRequest req;
    public PageSnippet pageSnippet = null;
    public List<WidgetEntryData> popTableData = null;
    protected static int counter = -1;
    protected final boolean acceptMissingResources;
    protected final Set<String> widgetsInOverview = new HashSet<String>();
    protected boolean detailWidgetsChosenManually = false;
    protected boolean isInDetailWidgetsSection = false;
    protected WidgetsToAdd evaluatingForDetails = WidgetsToAdd.OVERVIEW;
    protected final T fixedGatewayInfo;
    protected LinkedHashMap<String, Object> fullHeaderMap = new LinkedHashMap();
    protected LinkedHashMap<String, Object> headerMap = new LinkedHashMap();

    public ObjectGUIHelperBase(WidgetPage<?> page, boolean acceptMissingResources) {
        this.page = page;
        this.parent = null;
        this.req = null;
        this.fixedGatewayInfo = null;
        this.acceptMissingResources = acceptMissingResources;
    }

    public ObjectGUIHelperBase(WidgetPage<?> page, T fixedGatewayInfo, boolean acceptMissingResources) {
        this.page = page;
        this.parent = null;
        this.req = null;
        this.fixedGatewayInfo = fixedGatewayInfo;
        this.acceptMissingResources = acceptMissingResources;
    }

    public ObjectGUIHelperBase(OgemaWidget parent, OgemaHttpRequest req, T fixedGatewayInfo, boolean acceptMissingResources) {
        this.page = null;
        this.parent = parent;
        this.req = req;
        this.fixedGatewayInfo = fixedGatewayInfo;
        this.acceptMissingResources = acceptMissingResources;
    }

    protected void finishRowSnippet(RowTemplate.Row row, String widgetId, OgemaWidget result) {
        if (row != null) {
            row.addCell(widgetId, (Object)result);
        } else if (this.pageSnippet != null) {
            this.pageSnippet.append(result, this.getReq());
        } else {
            this.popTableData.add(new WidgetEntryData(widgetId, result));
        }
    }

    public boolean checkLineId(String widgetId) {
        String canonicalWidgetId = ResourceUtils.getValidResourceName((String)widgetId);
        this.fullHeaderMap.put(canonicalWidgetId, widgetId);
        if (this.detailWidgetsChosenManually) {
            boolean val = this.widgetsInOverview.contains(canonicalWidgetId);
            switch (this.evaluatingForDetails) {
                case OVERVIEW: {
                    if (val) break;
                    return true;
                }
                case DETAILS_ONLY: {
                    if (!val) break;
                    return true;
                }
            }
        } else if (this.isInDetailWidgetsSection) {
            this.widgetsInOverview.remove(canonicalWidgetId);
            if (this.evaluatingForDetails == WidgetsToAdd.OVERVIEW) {
                return true;
            }
        } else {
            this.widgetsInOverview.add(canonicalWidgetId);
            if (this.evaluatingForDetails == WidgetsToAdd.DETAILS_ONLY) {
                return true;
            }
        }
        this.headerMap.put(canonicalWidgetId, widgetId);
        return this.fixedGatewayInfo == null;
    }

    public LinkedHashMap<String, Object> getHeader() {
        return this.headerMap;
    }

    public LinkedHashMap<String, Object> getFullHeaderList() {
        return this.fullHeaderMap;
    }

    public Set<String> getOverviewColumns() {
        return this.widgetsInOverview;
    }

    public void registerHeaderEntry(String widgetId) {
        this.checkLineId(widgetId);
    }

    public void inDetailSection(boolean detailStatus) {
        this.isInDetailWidgetsSection = detailStatus;
    }

    public void evaluteForDetailsPopup(WidgetsToAdd status) {
        this.evaluatingForDetails = status;
    }

    public void widgetsChosenManually(boolean status) {
        this.detailWidgetsChosenManually = status;
    }

    public OgemaHttpRequest getReq() {
        return this.req;
    }

    public OgemaWidget getParent() {
        return this.parent;
    }

    public static class DatepickerFlex {
        public DatepickerTimeResource myDrop;

        public void onGET(OgemaHttpRequest req) {
        }

        public void onPrePOST(String data, OgemaHttpRequest req) {
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
        }

        public DatepickerFlex(String widgetId, ObjectGUIHelperBase<?> vrh, String format, String defaultDate, String viewMode) {
            if (vrh.page != null) {
                this.myDrop = new DatepickerTimeResource(vrh.page, widgetId, null, format, defaultDate, viewMode, null){
                    private static final long serialVersionUID = 1L;

                    public void onGET(OgemaHttpRequest req) {
                        this.onGET(req);
                    }

                    public void onPrePOST(String s, OgemaHttpRequest req) {
                        this.onPrePOST(s, req);
                    }

                    public void onPOSTComplete(String s, OgemaHttpRequest req) {
                        this.onPOSTComplete(s, req);
                    }
                };
            } else {
                this.myDrop = new DatepickerTimeResource(vrh.parent, widgetId, vrh.getReq()){
                    private static final long serialVersionUID = 1L;

                    public void onGET(OgemaHttpRequest req) {
                        this.onGET(req);
                    }

                    public void onPrePOST(String s, OgemaHttpRequest req) {
                        this.onPrePOST(s, req);
                    }

                    public void onPOSTComplete(String s, OgemaHttpRequest req) {
                        this.onPOSTComplete(s, req);
                    }
                };
                if (format != null) {
                    this.myDrop.setFormat(format, vrh.getReq());
                }
                if (defaultDate != null) {
                    this.myDrop.setDefaultDate(defaultDate);
                }
                if (viewMode != null) {
                    this.myDrop.setViewMode(viewMode, vrh.getReq());
                }
            }
        }
    }

    public static class ResourceDropdownFlex<S extends Resource> {
        public ResourceDropdown<S> myDrop;

        public void onGET(OgemaHttpRequest req) {
        }

        public void onPrePOST(String data, OgemaHttpRequest req) {
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
        }

        public String getLabel(S object, OgemaLocale locale) {
            return ResourceUtils.getHumanReadableName(object);
        }

        public ResourceDropdownFlex(String widgetId, ObjectGUIHelperBase<?> vrh) {
            this.myDrop = vrh.page != null ? new ResourceDropdown<S>(vrh.page, widgetId){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }

                public void onPOSTComplete(String s, OgemaHttpRequest req) {
                    this.onPOSTComplete(s, req);
                }
            } : new ResourceDropdown<S>(vrh.parent, widgetId, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }

                public void onPOSTComplete(String s, OgemaHttpRequest req) {
                    this.onPOSTComplete(s, req);
                }
            };
            DefaultResourceTemplate displayTemplate = new DefaultResourceTemplate<S>(){

                public String getLabel(S object, OgemaLocale locale) {
                    return this.getLabel(object, locale);
                }
            };
            this.myDrop.setTemplate((DisplayTemplate)displayTemplate);
        }
    }

    public static class ValueResourceDropdownFlex<S extends SingleValueResource> {
        public ValueResourceDropdown<S> myDrop;
        Map<String, String> valuesToSet;

        public void onGET(OgemaHttpRequest req) {
        }

        public void onPrePOST(String data, OgemaHttpRequest req) {
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
        }

        public ValueResourceDropdownFlex(String widgetId, ObjectGUIHelperBase<?> vrh, final Map<String, String> valuesToSet) {
            this.myDrop = vrh.page != null ? new ValueResourceDropdown<S>(vrh.page, widgetId){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }

                public void onPOSTComplete(String s, OgemaHttpRequest req) {
                    this.onPOSTComplete(s, req);
                }

                public String getSelection(S resource, Locale locale, List<String> displayedValues) {
                    if (valuesToSet == null) {
                        return super.getSelection(resource, locale, displayedValues);
                    }
                    String value = ValueResourceUtils.getValue(resource);
                    String display = (String)valuesToSet.get(value);
                    if (display == null) {
                        return displayedValues.get(0);
                    }
                    return display;
                }

                protected void setResourceValue(S resource, String value, List<String> displayedValues) {
                    if (valuesToSet == null) {
                        super.setResourceValue(resource, value, displayedValues);
                    }
                    for (Map.Entry e : valuesToSet.entrySet()) {
                        if (!((String)e.getValue()).equals(value)) continue;
                        ValueResourceUtils.setValue(resource, (String)((String)e.getKey()));
                        return;
                    }
                }
            } : new ValueResourceDropdown<S>(vrh.parent, widgetId, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }

                public void onPOSTComplete(String s, OgemaHttpRequest req) {
                    this.onPOSTComplete(s, req);
                }

                public String getSelection(S resource, Locale locale, List<String> displayedValues) {
                    if (valuesToSet == null) {
                        return super.getSelection(resource, locale, displayedValues);
                    }
                    String value = ValueResourceUtils.getValue(resource);
                    String display = (String)valuesToSet.get(value);
                    if (display == null) {
                        return displayedValues.get(0);
                    }
                    return display;
                }

                protected void setResourceValue(S resource, String value, List<String> displayedValues) {
                    if (valuesToSet == null) {
                        super.setResourceValue(resource, value, displayedValues);
                    }
                    for (Map.Entry e : valuesToSet.entrySet()) {
                        if (!((String)e.getValue()).equals(value)) continue;
                        ValueResourceUtils.setValue(resource, (String)((String)e.getKey()));
                        return;
                    }
                }
            };
            this.myDrop.setDefaultDisplayedValues(new ArrayList<String>(valuesToSet.values()));
        }
    }

    public static class TemplateRedirectButtonFlex<S> {
        TemplateRedirectButton<S> myButton;

        public void onPrePOST(String s, OgemaHttpRequest req) {
        }

        public TemplateRedirectButtonFlex(String widgetId, ObjectGUIHelperBase<?> vrh, String buttonText, String url) {
            this.myButton = vrh.page != null ? new TemplateRedirectButton<S>(vrh.page, widgetId, buttonText, url){
                private static final long serialVersionUID = 1L;

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }
            } : new TemplateRedirectButton<S>(vrh.parent, widgetId, buttonText, url, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }
            };
        }
    }

    public static class ResourceRedirectButtonFlex<S extends Resource> {
        public ResourceRedirectButton<S> myButton;

        public void onPrePOST(String s, OgemaHttpRequest req) {
        }

        public ResourceRedirectButtonFlex(String widgetId, ObjectGUIHelperBase<?> vrh, String buttonText, String url) {
            this.myButton = vrh.page != null ? new ResourceRedirectButton<S>(vrh.page, widgetId, buttonText, url){
                private static final long serialVersionUID = 1L;

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }
            } : new ResourceRedirectButton<S>(vrh.parent, widgetId, buttonText, url, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onPrePOST(String s, OgemaHttpRequest req) {
                    this.onPrePOST(s, req);
                }
            };
        }
    }

    public static class BooleanResourceCheckboxFlex {
        public BooleanResourceCheckbox myCheckbox;

        public void onGET(OgemaHttpRequest req) {
        }

        public void onPrePOST(String data, OgemaHttpRequest req) {
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
        }

        public BooleanResourceCheckboxFlex(String widgetId, ObjectGUIHelperBase<?> vrh) {
            this.myCheckbox = vrh.page != null ? new BooleanResourceCheckbox(vrh.page, widgetId, ""){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String data, OgemaHttpRequest req) {
                    this.onPrePOST(data, req);
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    this.onPOSTComplete(data, req);
                }
            } : new BooleanResourceCheckbox(vrh.parent, widgetId, "", vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String data, OgemaHttpRequest req) {
                    this.onPrePOST(data, req);
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    this.onPOSTComplete(data, req);
                }
            };
        }
    }

    public static class TextFieldFlex {
        public TextField myField;

        public void onGET(OgemaHttpRequest req) {
        }

        public void onPrePOST(String data, OgemaHttpRequest req) {
        }

        public void onPOSTComplete(String data, OgemaHttpRequest req) {
        }

        public TextFieldFlex(String widgetId, ObjectGUIHelperBase<?> vrh) {
            this.myField = vrh.page != null ? new TextField(vrh.page, widgetId){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String data, OgemaHttpRequest req) {
                    this.onPrePOST(data, req);
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    this.onPOSTComplete(data, req);
                }
            } : new TextField(vrh.parent, widgetId, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }

                public void onPrePOST(String data, OgemaHttpRequest req) {
                    this.onPrePOST(data, req);
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    this.onPOSTComplete(data, req);
                }
            };
        }
    }

    public static class LabelFlex {
        public Label myLabel;

        public void onGET(OgemaHttpRequest req) {
        }

        public LabelFlex(String widgetId, ObjectGUIHelperBase<?> vrh) {
            this.myLabel = vrh.page != null ? new Label(vrh.page, widgetId){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }
            } : new Label(vrh.parent, widgetId, vrh.getReq()){
                private static final long serialVersionUID = 1L;

                public void onGET(OgemaHttpRequest req) {
                    this.onGET(req);
                }
            };
        }
    }

    public static enum WidgetsToAdd {
        OVERVIEW,
        DETAILS_ONLY,
        ALL;

    }
}

