/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directresourcegui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.resource.widget.table.ResourceTable;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.smartrplace.util.directresourcegui.ResourceGUIHelper;

public class DeleteButton<T extends Resource>
extends ButtonConfirm {
    private static final long serialVersionUID = 1L;
    private final ResourceList<T> objectList;
    private final T object;
    private final Alert alert;

    public DeleteButton(ResourceList<T> objectList, T object, ResourceTable<T> mainTable, String id, Alert alert, RowTemplate.Row row, ResourceGUIHelper<T> vh, OgemaHttpRequest req) {
        super(mainTable, "deleteButton_" + id, req);
        this.objectList = objectList;
        this.object = object;
        this.alert = alert;
        this.setText("delete", req);
        this.setConfirmBtnMsg("Delete", req);
        this.setCancelBtnMsg("Cancel", req);
        this.setConfirmPopupTitle("Delete element", req);
        this.setConfirmMsg("Really delete item " + object.getLocation() + " ?", req);
        this.registerDependentWidget((OgemaWidget)mainTable);
        if (alert != null) {
            this.registerDependentWidget((OgemaWidget)alert);
        }
    }

    public void onPOSTComplete(String data, OgemaHttpRequest req) {
        if (this.objectList == null || this.objectList.size() > 1) {
            this.object.delete();
        } else if (this.alert != null) {
            this.alert.showAlert("Last element cannot be deleted", false, req);
        }
    }
}

