/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directresourcegui;

import de.iwes.util.resource.ResourceHelper;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.resource.widget.table.DefaultResourceRowTemplate;
import de.iwes.widgets.resource.widget.table.ResourceTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.smartrplace.util.directobjectgui.ApplicationManagerMinimal;
import org.smartrplace.util.directresourcegui.ResourceGUIHelper;

public abstract class ResourceGUITableTemplate<T extends Resource>
extends DefaultResourceRowTemplate<T> {
    private static final long IDLE_TIME_TO_CLEANUP = 60000L;
    public ResourceGUIHelper<T> mhInit = null;
    private boolean isInInit = false;
    private final ApplicationManager appMan;
    private final ApplicationManagerMinimal appManMinimal;
    protected final WidgetPage<?> page;
    protected final TableProvider<T> tableProvider;
    protected final boolean registerDependentWidgets;
    @Deprecated
    Map<T, Set<String>> objectsInitialized = new HashMap<T, Set<String>>();
    @Deprecated
    long lastAccessTime = -1L;

    private long getFrameworkTime() {
        if (this.appMan != null) {
            return this.appMan.getFrameworkTime();
        }
        return this.appManMinimal.getFrameworkTime();
    }

    public ResourceGUITableTemplate(WidgetPage<?> page, Class<T> resourceType, ApplicationManager appMan, boolean registerDependentWidgets) {
        this(page, resourceType, appMan, null, registerDependentWidgets);
    }

    public ResourceGUITableTemplate(WidgetPage<?> page, Class<T> resourceType, ApplicationManager appMan, ApplicationManagerMinimal appManMin, boolean registerDependentWidgets) {
        this.appMan = appMan;
        this.appManMinimal = appManMin;
        this.page = page;
        this.tableProvider = null;
        this.registerDependentWidgets = registerDependentWidgets;
        this.init(resourceType);
    }

    public ResourceGUITableTemplate(TableProvider<T> tableProvider, Class<T> resourceType, ApplicationManager appMan, boolean registerDependentWidgets) {
        this(tableProvider, resourceType, appMan, null, registerDependentWidgets);
    }

    public ResourceGUITableTemplate(TableProvider<T> tableProvider, Class<T> resourceType, ApplicationManager appMan, ApplicationManagerMinimal appManMin, boolean registerDependentWidgets) {
        this.appMan = appMan;
        this.appManMinimal = appManMin;
        this.page = null;
        this.tableProvider = tableProvider;
        this.registerDependentWidgets = registerDependentWidgets;
        this.init(resourceType);
    }

    private void init(Class<T> resourceType) {
        Resource sampleResource = ResourceHelper.getSampleResource(resourceType);
        this.isInInit = true;
        this.addRow((T)sampleResource, (OgemaHttpRequest)null);
        this.isInInit = false;
    }

    protected abstract RowTemplate.Row addRow(T var1, ResourceGUIHelper<T> var2, String var3, OgemaHttpRequest var4);

    public InitResult initRow(T object, OgemaHttpRequest req) {
        InitResult result = new InitResult();
        if (this.isInInit) {
            if (this.tableProvider != null) {
                ResourceTable<T> table = this.tableProvider.getTable(req);
                result.vh = new ResourceGUIHelper<Resource>((OgemaWidget)table, req, null, this.appMan, false);
                this.mhInit = result.vh;
            } else {
                result.vh = new ResourceGUIHelper<Resource>(this.page, (Resource)null, this.appMan, false);
                this.mhInit = result.vh;
            }
            result.vh.setDoRegisterDependentWidgets(this.registerDependentWidgets);
            result.id = "";
        } else {
            if (this.tableProvider != null) {
                ResourceTable<T> table = this.tableProvider.getTable(req);
                result.vh = new ResourceGUIHelper<T>((OgemaWidget)table, req, object, this.appMan, false);
            } else {
                result.vh = new ResourceGUIHelper<T>(this.page, object, this.appMan, false);
            }
            result.vh.setDoRegisterDependentWidgets(this.registerDependentWidgets);
            result.id = this.getLineId((Resource)object);
        }
        return result;
    }

    public Map<String, Object> getHeader() {
        if (this.mhInit != null) {
            LinkedHashMap<String, Object> map2 = this.mhInit.getHeader();
            return map2;
        }
        throw new IllegalStateException("mhInit must be initialized before calling getHeader!");
    }

    public RowTemplate.Row addRow(T object, OgemaHttpRequest req) {
        if (req != null) {
            if (this.lastAccessTime > 0L && this.getFrameworkTime() - this.lastAccessTime > 60000L) {
                this.objectsInitialized.clear();
            } else if (this.objectsInitialized.get(object) != null && this.objectsInitialized.get(object).contains(req.getSessionId())) {
                return null;
            }
            this.lastAccessTime = this.getFrameworkTime();
            Set<String> sessions = this.objectsInitialized.get(object);
            if (sessions == null) {
                sessions = new HashSet<String>();
                this.objectsInitialized.put(object, sessions);
            }
            sessions.add(req.getSessionId());
        }
        InitResult initRow = this.initRow(object, req);
        return this.addRow(object, initRow.vh, initRow.id, req);
    }

    public class InitResult {
        public ResourceGUIHelper<T> vh;
        public String id;
    }

    public static interface TableProvider<P extends Resource> {
        public ResourceTable<P> getTable(OgemaHttpRequest var1);
    }
}

