/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.format;

import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import java.util.HashMap;
import java.util.Map;
import org.smartrplace.util.format.ValueFormat;

public class ValueConverter {
    public static final Map<OgemaLocale, String> FORMATFAILED = new HashMap<OgemaLocale, String>();
    public static final Map<OgemaLocale, String> NEWVALUE = new HashMap<OgemaLocale, String>();
    private final Alert alert;
    private final float minimumAllowed;
    private final float maximumAllowed;
    private final String fieldName;

    public ValueConverter(String fieldName, Alert alert, Float minimumAllowed, Float maximumAllowed) {
        this.fieldName = fieldName;
        this.alert = alert;
        this.minimumAllowed = minimumAllowed == null ? 0.0f : minimumAllowed.floatValue();
        this.maximumAllowed = maximumAllowed == null ? 999999.0f : maximumAllowed.floatValue();
    }

    public Integer checkNewValueInt(String val, OgemaHttpRequest req) {
        int value;
        try {
            value = Integer.parseInt(val);
        }
        catch (NullPointerException | NumberFormatException e) {
            if (this.alert != null) {
                this.alert.showAlert(ValueFormat.getLocaleString(req, FORMATFAILED) + "(" + this.getFieldName(req) + ")", false, req);
            }
            return null;
        }
        if ((float)value < this.minimumAllowed) {
            if (this.alert != null) {
                this.alert.showAlert(this.getValueFailedMessage(true, req), false, req);
            }
            return null;
        }
        if ((float)value > this.maximumAllowed) {
            if (this.alert != null) {
                this.alert.showAlert(this.getValueFailedMessage(false, req), false, req);
            }
            return null;
        }
        if (this.alert != null) {
            this.alert.showAlert(ValueFormat.getLocaleString(req, NEWVALUE) + value + "(" + this.getFieldName(req) + ")", true, req);
        }
        return value;
    }

    public Alert getAlert() {
        return this.alert;
    }

    protected String getValueFailedMessage(boolean tooSmall, OgemaHttpRequest req) {
        OgemaLocale locale = req.getLocale();
        if (locale == OgemaLocale.GERMAN) {
            return "Zul\u00e4ssige Werte f\u00fcr " + this.getFieldName(req) + ":" + this.minimumAllowed + " bis " + this.maximumAllowed;
        }
        return this.getFieldName(req) + " limits:" + this.minimumAllowed + " to " + this.maximumAllowed;
    }

    protected String getFieldName(OgemaHttpRequest req) {
        return this.fieldName;
    }

    static {
        FORMATFAILED.put(OgemaLocale.ENGLISH, "Could not read");
        FORMATFAILED.put(OgemaLocale.GERMAN, "Falsches Format");
        NEWVALUE.put(OgemaLocale.ENGLISH, "New value:");
        NEWVALUE.put(OgemaLocale.GERMAN, "Neuer Wert:");
    }
}

