/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.client.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.json.JSONObject;
import org.smartrplace.drivers.upnp.tools.Message;
import org.smartrplace.drivers.upnp.tools.MessageNotify;
import org.smartrplace.drivers.upnp.tools.MessageResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RemoteDevice {
    public final URL location;
    public final long maxAgeSeconds;
    public final long lastUpdate;
    public final String uuid;
    public final String device;
    private volatile Document detailInformation;

    RemoteDevice(Message message) {
        Objects.requireNonNull(message);
        this.lastUpdate = System.currentTimeMillis();
        if (message instanceof MessageNotify) {
            MessageNotify msg = (MessageNotify)message;
            this.location = msg.location;
            this.uuid = msg.uuid;
            this.maxAgeSeconds = msg.seconds;
            this.device = msg.server;
        } else if (message instanceof MessageResponse) {
            MessageResponse msg = (MessageResponse)message;
            this.location = msg.location;
            this.uuid = msg.uuid;
            this.maxAgeSeconds = msg.seconds;
            this.device = msg.server;
        } else {
            throw new IllegalArgumentException("Illegal message type: " + message);
        }
    }

    private static final boolean isOgemaGateway(String device) {
        return device.toLowerCase().contains("ogema");
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.lastUpdate + this.maxAgeSeconds * 1000L;
    }

    public String toString() {
        return "Device at " + this.location.toString() + "\n   UUID: " + this.uuid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteDevice)) {
            return false;
        }
        RemoteDevice other = (RemoteDevice)obj;
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public JSONObject getJSON() {
        String friendlyName;
        JSONObject json = new JSONObject();
        json.put("location", (Object)this.location.toString());
        json.put("uuid", (Object)this.uuid);
        json.put("lifetime", (this.lastUpdate + this.maxAgeSeconds * 1000L - System.currentTimeMillis()) / 1000L);
        json.put("device", (Object)this.device);
        String url = this.getDevicePresentationAddress();
        if (url != null) {
            url = RemoteDevice.createPath(this.location, url);
            json.put("gatewayLink", (Object)url);
        }
        if ((friendlyName = this.getFriendlyName()) == null) {
            friendlyName = this.uuid;
        }
        json.put("friendlyName", (Object)friendlyName);
        String iconPath = this.getIconPath();
        if (iconPath != null) {
            iconPath = RemoteDevice.createPath(this.location, iconPath);
            json.put("icon", (Object)iconPath);
        }
        return json;
    }

    private static String createPath(URL location, String url) {
        try {
            url = new URL(url).toString();
        }
        catch (MalformedURLException e) {
            if (url.startsWith("/")) {
                url = location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + url;
            }
            String path = location.getPath();
            if (path != null && !path.isEmpty()) {
                int idx = path.lastIndexOf(47);
                path = idx > 0 ? path.substring(0, idx + 1) : "/";
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            url = location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + path + url;
        }
        return url;
    }

    void setDetails(Document doc) {
        this.detailInformation = doc;
    }

    public String getDevicePresentationAddress() {
        return RemoteDevice.getTag("presentationURL", this.detailInformation);
    }

    public String getFriendlyName() {
        return RemoteDevice.getTag("friendlyName", this.detailInformation);
    }

    public String getIconPath() {
        Document detailInformation = this.detailInformation;
        if (detailInformation == null) {
            return null;
        }
        NodeList nl = detailInformation.getElementsByTagName("icon");
        int sz = nl.getLength();
        if (sz == 0) {
            return null;
        }
        int smallestSize = Integer.MAX_VALUE;
        String bestUrl = null;
        for (int i = 0; i < sz; ++i) {
            Node n = nl.item(i);
            NodeList subs = n.getChildNodes();
            int currentSize = Integer.MAX_VALUE;
            String url = null;
            block11: for (int j = 0; j < subs.getLength(); ++j) {
                Node s = subs.item(j);
                String name = s.getNodeName();
                if (name == null) continue;
                switch (name.toLowerCase()) {
                    case "height": {
                        try {
                            currentSize = Integer.parseInt(s.getTextContent());
                        }
                        catch (Exception e) {}
                        continue block11;
                    }
                    case "url": {
                        url = s.getTextContent();
                        continue block11;
                    }
                }
            }
            if (currentSize >= smallestSize || url == null) continue;
            smallestSize = currentSize;
            bestUrl = url;
        }
        return bestUrl;
    }

    private static String getTag(String tagName, Document doc) {
        if (doc == null) {
            return null;
        }
        NodeList nl = doc.getElementsByTagName(tagName);
        if (nl.getLength() == 0) {
            return null;
        }
        Node n = nl.item(0);
        return n.getTextContent();
    }
}

