/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartrplace.drivers.upnp.client.impl.Browser;
import org.smartrplace.drivers.upnp.client.impl.RemoteDevice;
import org.smartrplace.drivers.upnp.tools.Message;
import org.smartrplace.drivers.upnp.tools.MessageNotify;
import org.smartrplace.drivers.upnp.tools.MessageSearch;
import org.smartrplace.drivers.upnp.tools.MessageType;
import org.smartrplace.drivers.upnp.tools.NetworkUtils;
import org.smartrplace.drivers.upnp.tools.NotifyType;
import org.smartrplace.drivers.upnp.tools.exec.ScalingThreadPoolExecutor;
import org.w3c.dom.Document;

@Component(immediate=true)
public class UpnpClient
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(UpnpClient.class);
    static final String URL_BASE = "/org/smartrplace/drivers/upnp/overview";
    private static final int SCAN_TIMEOUT = 10000;
    static final InetAddress MULTICAST_ADDRESS;
    static final int MULTICAST_PORT = 1900;
    volatile String lastUpdateMessage;
    volatile boolean lastUpdateSuccess;
    private volatile MulticastSocket multiSocket;
    final ConcurrentMap<String, RemoteDevice> devices = new ConcurrentHashMap<String, RemoteDevice>();
    private Thread discoveryMulti;
    private Thread discovery;
    private Thread initThread;
    ExecutorService es;
    DocumentBuilderFactory factory;
    @Reference
    private HttpService httpService;
    private volatile boolean discoveryRunning = false;
    private volatile long lastUpdate = -1L;
    private static final HostnameVerifier NOOP_VERIFIER;
    private static final TrustManager[] TRUST_ALL;

    @Activate
    public void start(final BundleContext ctx) {
        this.es = ScalingThreadPoolExecutor.newScalingThreadPool(1, 5, 600000L, new ThreadFactory(){
            private final AtomicInteger cnt = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("Upnp_client_thread/pool_" + this.cnt.getAndIncrement());
                return thread;
            }
        });
        this.factory = DocumentBuilderFactory.newInstance();
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                UpnpClient.this.devices.clear();
                int failCounter = 0;
                try {
                    InetAddress hanAddress = NetworkUtils.getHANAddress(logger);
                    if (hanAddress == null) {
                        throw new RuntimeException("Local network interface could not be identified");
                    }
                    InetSocketAddress isa = new InetSocketAddress(hanAddress, 1900);
                    UpnpClient.this.multiSocket = new MulticastSocket(isa);
                    UpnpClient.this.multiSocket.setReuseAddress(true);
                }
                catch (Exception e1) {
                    if (++failCounter > 15) {
                        failCounter = 15;
                    }
                    logger.info("Network initialization failed", (Throwable)e1);
                    try {
                        Thread.sleep(failCounter ^ 0xFA0);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                UpnpClient.this.listenMulti();
                failCounter = 0;
                while (failCounter >= 0) {
                    try {
                        UpnpClient.this.sendDiscoveryRequest();
                        failCounter = -1;
                    }
                    catch (Exception e) {
                        ++failCounter;
                        logger.warn("Sending discovery request failed", (Throwable)e);
                        try {
                            Thread.sleep(failCounter ^ 0xFA0);
                        }
                        catch (InterruptedException e1) {
                            return;
                        }
                    }
                }
                try {
                    UpnpClient.this.httpService.registerServlet("/org/smartrplace/drivers/upnp/overviewservlet", (Servlet)UpnpClient.this, null, null);
                    UpnpClient.this.httpService.registerResources(UpnpClient.URL_BASE, "/org/smartrplace/upnp", null);
                }
                catch (ServletException | NamespaceException e) {
                    throw new RuntimeException("Could not register servlet", e);
                }
                logger.info("{} started", this.getClass());
                int ownPort = 8443;
                String portProp = ctx.getProperty("org.osgi.service.http.port.secure");
                if (portProp != null) {
                    try {
                        ownPort = Integer.parseInt(portProp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Browser.openPage("https://" + InetAddress.getLocalHost().getHostAddress() + ":" + ownPort + UpnpClient.URL_BASE + "/index.html");
                }
                catch (UnknownHostException e) {
                    logger.info("Opening Browser failed", (Throwable)e);
                }
            }
        });
        this.initThread.setName("SSDP_client_init_thread");
        this.initThread.start();
    }

    @Deactivate
    public void stop() {
        if (this.initThread != null && this.initThread.isAlive()) {
            this.initThread.interrupt();
        }
        this.initThread = null;
        try {
            this.httpService.unregister("/org/smartrplace/drivers/upnp/overviewservlet");
            this.httpService.unregister(URL_BASE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.discoveryMulti != null) {
            this.discoveryMulti.interrupt();
        }
        this.discoveryMulti = null;
        if (this.discovery != null) {
            this.discovery.interrupt();
        }
        this.discovery = null;
        if (this.multiSocket != null) {
            this.multiSocket.disconnect();
            this.multiSocket.close();
        }
        this.multiSocket = null;
        if (this.es != null) {
            this.es.shutdownNow();
        }
        this.es = null;
        this.factory = null;
        this.devices.clear();
        logger.info("{}: bye bye", ((Object)((Object)this)).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDiscoveryRequest() {
        ExecutorService executorService = this.es;
        synchronized (executorService) {
            if (this.discoveryRunning) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastUpdate < 10000L) {
                return;
            }
            this.discoveryRunning = true;
        }
        Runnable discover = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] receiveData = new byte[1024];
                byte[] bytes = MessageSearch.getDefaultSearchMessage().get().getBytes();
                DatagramPacket search = new DatagramPacket(bytes, bytes.length, MULTICAST_ADDRESS, 1900);
                logger.debug("Sending device discovery request");
                try (DatagramSocket clientSocket2 = new DatagramSocket();){
                    clientSocket2.setSoTimeout(10000);
                    clientSocket2.send(search);
                    while (!Thread.interrupted()) {
                        DatagramPacket response = new DatagramPacket(receiveData, receiveData.length);
                        clientSocket2.receive(response);
                        if (Thread.interrupted()) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        DeviceCreation deviceCreation = new DeviceCreation(response, UpnpClient.this);
                        UpnpClient.this.es.submit(deviceCreation);
                    }
                }
                catch (SocketTimeoutException clientSocket2) {
                }
                catch (IOException e) {
                    logger.warn("Error in device discovery thread", (Throwable)e);
                    return;
                }
                finally {
                    UpnpClient.this.discoveryRunning = false;
                    UpnpClient.this.lastUpdate = System.currentTimeMillis();
                }
                logger.debug("Discovery period finished");
            }
        };
        this.es.submit(discover);
    }

    void listenMulti() {
        ListenerTask task = new ListenerTask(this.multiSocket, this){

            @Override
            public void init() {
                int failCounter = 0;
                try {
                    UpnpClient.this.multiSocket.joinGroup(MULTICAST_ADDRESS);
                }
                catch (Exception e) {
                    logger.warn("Failed to connect to SSDP multicast thread", (Throwable)e);
                    if (++failCounter > 15) {
                        failCounter = 15;
                    }
                    try {
                        Thread.sleep(failCounter ^ 0xFA0);
                    }
                    catch (InterruptedException e1) {
                        logger.info("Thread interrupted, stop trying to connect to SSDP multicast thread");
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                logger.debug("UPNP client registered");
            }
        };
        this.discoveryMulti = new Thread(task);
        this.discoveryMulti.setName("SSDP multicast device discovery");
        this.discoveryMulti.start();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendDiscoveryRequest();
        JSONObject json = new JSONObject();
        for (Map.Entry entry : this.devices.entrySet()) {
            RemoteDevice d = (RemoteDevice)entry.getValue();
            if (!d.isValid()) continue;
            json.put((String)entry.getKey(), (Object)d.getJSON());
        }
        resp.getWriter().write(json.toString());
        resp.setContentType("application/json");
        resp.setStatus(200);
    }

    static {
        try {
            MULTICAST_ADDRESS = InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("???", e);
        }
        NOOP_VERIFIER = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        TRUST_ALL = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static class DeviceCreation
    implements Runnable {
        private final DatagramPacket response;
        private final UpnpClient client;

        public DeviceCreation(DatagramPacket response, UpnpClient client) {
            this.response = response;
            this.client = client;
        }

        @Override
        public void run() {
            RemoteDevice rd;
            try {
                String msg = new String(this.response.getData());
                if (msg.startsWith(MessageType.SEARCH.getIdentifier())) {
                    logger.trace("Search request from {}:{}", (Object)this.response.getAddress().getHostAddress(), (Object)this.response.getPort());
                    return;
                }
                Message message = Message.parse(msg);
                if (logger.isDebugEnabled()) {
                    logger.debug("New message of type {} from {}:{}", new Object[]{message.getClass().getSimpleName(), this.response.getAddress().getHostAddress(), this.response.getPort()});
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Message: " + msg);
                }
                if (!message.rootDevice()) {
                    logger.trace("Message not from root device, discarding...");
                    return;
                }
                if (message instanceof MessageNotify && ((MessageNotify)message).notifyType == NotifyType.BYE_BYE) {
                    logger.debug("Device being removed: {}", (Object)((MessageNotify)message).uuid);
                    this.client.devices.remove(((MessageNotify)message).uuid);
                    return;
                }
                rd = new RemoteDevice(message);
            }
            catch (Exception e) {
                logger.warn("Could not create device from UDP response", (Throwable)e);
                return;
            }
            RemoteDevice oldDevice = this.client.devices.put(rd.uuid, rd);
            if (logger.isDebugEnabled()) {
                if (oldDevice == null) {
                    logger.debug("New device {}", (Object)rd.uuid);
                } else {
                    logger.trace("New information about device {}", (Object)rd.uuid);
                }
            }
            URL url = rd.location;
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection sslConn = (HttpsURLConnection)connection;
                    sslConn.setHostnameVerifier(NOOP_VERIFIER);
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, TRUST_ALL, new SecureRandom());
                    sslConn.setSSLSocketFactory(ctx.getSocketFactory());
                }
                connection.setConnectTimeout(10000);
                InputStream is = connection.getInputStream();
                DocumentBuilder builder = this.client.factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                rd.setDetails(doc);
            }
            catch (Exception e) {
                logger.error("Reading detailed information failed: " + rd.location, (Throwable)e);
            }
        }
    }

    private static class ListenerTask
    implements Runnable {
        private final DatagramSocket socket;
        private final UpnpClient client;

        public ListenerTask(DatagramSocket socket, UpnpClient client) {
            this.socket = socket;
            this.client = client;
        }

        public void init() {
        }

        @Override
        public void run() {
            this.init();
            int failCounter = 0;
            do {
                try {
                    byte[] rxbuf = new byte[8192];
                    DatagramPacket response = new DatagramPacket(rxbuf, rxbuf.length);
                    this.socket.receive(response);
                    if (Thread.interrupted()) break;
                    DeviceCreation deviceCreation = new DeviceCreation(response, this.client);
                    this.client.es.submit(deviceCreation);
                    failCounter = 0;
                }
                catch (SocketException e) {
                    break;
                }
                catch (Exception e) {
                    if (++failCounter > 15) {
                        failCounter = 15;
                    }
                    logger.debug("SSDP discovery thread failed; trying again", (Throwable)e);
                    try {
                        Thread.sleep(failCounter ^ 0xFA0);
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
            } while (!Thread.interrupted());
            logger.info("Aborting SSDP device scan");
        }
    }
}

