/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.tools;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.UUID;
import org.smartrplace.drivers.upnp.tools.MessageNotify;
import org.smartrplace.drivers.upnp.tools.MessageResponse;
import org.smartrplace.drivers.upnp.tools.MessageSearch;
import org.smartrplace.drivers.upnp.tools.MessageType;
import org.smartrplace.drivers.upnp.tools.NotifyType;

public abstract class Message {
    public static final InetAddress MULTICAST_ADDRESS;
    public static final int MULTICAST_PORT = 1900;
    public static final String ROOT_DEVICE_IDENTIFIER = "upnp:rootdevice";
    public final MessageType type;
    public static final long BOOT_ID;

    protected Message(MessageType type) {
        this.type = type;
    }

    protected abstract StringBuilder printFields();

    public String get() {
        return this.type.getIdentifier() + "\r\n" + this.printFields().toString() + "\r\n";
    }

    public static Message parse(byte[] message) {
        return Message.parse(new String(message));
    }

    public abstract boolean rootDevice();

    public static Message parse(String message) throws IllegalArgumentException {
        if (message == null || message.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty or null");
        }
        String[] lines = message.split("\r\n");
        MessageType type = MessageType.getType(lines[0]);
        if (type == null) {
            throw new IllegalArgumentException("Invalid reuqest: " + lines[0]);
        }
        boolean hostOk = false;
        boolean manOk = false;
        int mx = -1;
        long maxAge = -1L;
        String st = null;
        String userAgent = null;
        URL location = null;
        String nt = null;
        Object nts = null;
        UUID uuid = null;
        long bootid = -1L;
        long configId = -1L;
        int searchport = -1;
        long nextBootId = -1L;
        NotifyType nott = null;
        block53: for (String line : lines) {
            String[] entries;
            if (line.isEmpty() || (entries = line.split(":", 2)).length != 2) continue;
            String key = entries[0].trim().toUpperCase();
            String value = entries[1].trim();
            switch (key) {
                case "HOST": {
                    if (!value.equals(MULTICAST_ADDRESS.getHostAddress() + ":" + 1900)) {
                        throw new IllegalArgumentException("Invalid host " + value);
                    }
                    hostOk = true;
                    continue block53;
                }
                case "MAN": {
                    if (!value.equals("\"ssdp:discover\"")) {
                        throw new IllegalArgumentException("Invalid MAN header " + value);
                    }
                    manOk = true;
                    continue block53;
                }
                case "MX": {
                    try {
                        mx = Integer.parseInt(value);
                        if (mx > 0) continue block53;
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid MX header " + value);
                    }
                }
                case "ST": {
                    st = value;
                    continue block53;
                }
                case "USER-AGENT": {
                    userAgent = value;
                    continue block53;
                }
                case "CACHE-CONTROL": {
                    String[] v = value.split("=");
                    if (v.length != 2 || !v[0].trim().equals("max-age")) {
                        throw new IllegalArgumentException("illegal CACHE-CONTROL " + value);
                    }
                    try {
                        maxAge = Long.parseLong(v[1].trim());
                        if (maxAge > 0L) continue block53;
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid CACHE-CONTROL header " + value);
                    }
                }
                case "LOCATION": {
                    try {
                        location = new URL(value);
                        continue block53;
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException("Illegal LOCATION header, must be a valid URL: " + value);
                    }
                }
                case "NT": {
                    nt = value;
                    continue block53;
                }
                case "NTS": {
                    String[] v = value.split(":");
                    if (v.length != 2 || !v[0].trim().equals("ssdp")) {
                        throw new IllegalArgumentException("Illegal NTS header " + value);
                    }
                    nott = NotifyType.getType(v[1].trim());
                    if (nott != null) continue block53;
                    throw new IllegalArgumentException("Illegal NTS header " + value);
                }
                case "SERVER": {
                    userAgent = value;
                    continue block53;
                }
                case "USN": {
                    String[] arr = value.split(":");
                    if (arr.length < 2) {
                        throw new IllegalArgumentException("Illegal USN header field: " + value);
                    }
                    uuid = UUID.fromString(arr[1]);
                    continue block53;
                }
                case "BOOTID.UPNP.ORG": {
                    try {
                        bootid = Long.parseLong(value);
                        continue block53;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal BOOTID header " + value);
                    }
                }
                case "CONFIGID.UPNP.ORG": {
                    try {
                        configId = Long.parseLong(value);
                        continue block53;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal CONFIGID header " + value);
                    }
                }
                case "SEARCHPORT.UPNP.ORG": {
                    try {
                        searchport = Integer.parseInt(value);
                        continue block53;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal SEARCHPORT header " + value);
                    }
                }
                case "NEXTBOOTID.UPNP.ORG": {
                    try {
                        nextBootId = Long.parseLong(value);
                        continue block53;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal NEXTBOOTID header " + value);
                    }
                }
                default: {
                    continue block53;
                }
            }
        }
        switch (type) {
            case SEARCH: {
                if (!hostOk) {
                    throw new IllegalArgumentException("HOST missing");
                }
                return new MessageSearch(mx, st);
            }
            case HTTP: {
                return new MessageResponse(uuid.toString(), location, maxAge, configId, st, userAgent);
            }
            case NOTIFY: {
                if (!hostOk) {
                    throw new IllegalArgumentException("HOST missing");
                }
                if (nott == null) {
                    throw new IllegalArgumentException("NT header missing");
                }
                return new MessageNotify(uuid.toString(), nott, location, maxAge, configId, nt, userAgent);
            }
        }
        throw new IllegalArgumentException("Type not found");
    }

    static {
        BOOT_ID = System.currentTimeMillis();
        try {
            MULTICAST_ADDRESS = InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("???");
        }
    }
}

