/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.tools;

import java.net.URL;
import java.util.Objects;
import org.smartrplace.drivers.upnp.tools.Message;
import org.smartrplace.drivers.upnp.tools.MessageType;

public class MessageResponse
extends Message {
    public final URL location;
    public final long seconds;
    public final long configId;
    public final String uuid;
    public final String st;
    public final String server;

    public MessageResponse(String uuid, URL location, long seconds, long configId) {
        this(uuid, location, seconds, configId, "upnp:rootdevice", "unix/8 UPnP/1.1 OGEMA/2.1");
    }

    public MessageResponse(String uuid, URL location, long seconds, long configId, String st, String server) {
        super(MessageType.HTTP);
        Objects.requireNonNull(location);
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(st);
        this.configId = configId;
        this.seconds = seconds;
        this.uuid = uuid;
        this.location = location;
        this.st = st;
        this.server = server;
    }

    @Override
    public boolean rootDevice() {
        return this.st.equals("upnp:rootdevice");
    }

    @Override
    protected StringBuilder printFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("CACHE-CONTROL:max-age=" + this.seconds + "\r\n");
        sb.append("EXT:\r\n");
        sb.append("LOCATION: " + this.location.toString() + "\r\nST: " + this.st + "\r\nSERVER: " + this.server + "\r\nUSN: uuid:" + this.uuid + "::upnp:rootdevice\r\nBOOTID.UPNP.ORG: " + BOOT_ID + "\r\nCONFIGID.UPNP.ORG: " + this.configId + "\r\n");
        return sb;
    }
}

