/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.tools.exec;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ScalingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger activeCount = new AtomicInteger();

    public ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime) {
        ScalingQueue<Runnable> queue = new ScalingQueue<Runnable>();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime, ThreadFactory factory) {
        ScalingQueue<Runnable> queue = new ScalingQueue<Runnable>();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue, factory);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    @Override
    public int getActiveCount() {
        return this.activeCount.get();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.activeCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.activeCount.decrementAndGet();
    }

    private static final class ScalingQueue<E>
    extends LinkedBlockingQueue<E> {
        private static final long serialVersionUID = 1L;
        private ThreadPoolExecutor executor;

        public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public boolean offer(E o) {
            int allWorkingThreads = this.executor.getActiveCount() + super.size();
            return allWorkingThreads < this.executor.getPoolSize() && super.offer(o);
        }
    }

    private static final class ForceQueuePolicy
    implements RejectedExecutionHandler {
        private ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }
}

