/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.tools;

import java.net.URL;
import java.util.Objects;
import org.smartrplace.drivers.upnp.tools.Message;
import org.smartrplace.drivers.upnp.tools.MessageType;
import org.smartrplace.drivers.upnp.tools.NotifyType;

public class MessageNotify
extends Message {
    public final NotifyType notifyType;
    public final long seconds;
    public final URL location;
    public final long configId;
    public final String uuid;
    public final String nt;
    public final String server;

    public MessageNotify(String uuid, NotifyType notifyType, URL location, long seconds, long configId) {
        this(uuid, notifyType, location, seconds, configId, "upnp:rootdevice", "unix/8 UPnP/1.1 OGEMA/2.1");
    }

    public MessageNotify(String uuid, NotifyType notifyType, URL location, long seconds, long configId, String nt, String server) {
        super(MessageType.NOTIFY);
        if (seconds <= 0L && notifyType != NotifyType.BYE_BYE) {
            throw new IllegalArgumentException("seconds must be > 0");
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(nt);
        this.notifyType = notifyType;
        this.seconds = seconds;
        this.configId = configId;
        this.uuid = uuid;
        this.location = location;
        this.nt = nt;
        this.server = server;
    }

    @Override
    public boolean rootDevice() {
        return this.nt.equals("upnp:rootdevice");
    }

    @Override
    protected StringBuilder printFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("HOST: " + MULTICAST_ADDRESS.getHostAddress() + ":" + 1900 + "\r\n");
        if (this.notifyType == NotifyType.AVAILABLE) {
            sb.append("CACHE-CONTROL:max-age=" + this.seconds + "\r\n");
        }
        sb.append("LOCATION: " + this.location.toString() + "\r\nNT: " + this.nt + "\r\nNTS: ssdp:" + this.notifyType.getType() + "\r\nSERVER: " + this.server + "\r\nUSN: uuid:" + this.uuid + "::upnp:rootdevice\r\nBOOTID.UPNP.ORG: " + BOOT_ID + "\r\nCONFIGID.UPNP.ORG: " + this.configId + "\r\n");
        if (this.notifyType == NotifyType.UPDATE) {
            sb.append("NEXTBOOTID.UPNP.ORG: 1\r\n");
        }
        return sb;
    }
}

