/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.drivers.upnp.tools;

import java.lang.ref.SoftReference;
import java.util.Objects;
import org.smartrplace.drivers.upnp.tools.Message;
import org.smartrplace.drivers.upnp.tools.MessageType;

public class MessageSearch
extends Message {
    public final int maxDelay;
    public final String st;
    private static volatile SoftReference<MessageSearch> defaultMessage = null;

    public MessageSearch() {
        this(3, "upnp:rootdevice");
    }

    public MessageSearch(int maxDelay, String st) {
        super(MessageType.SEARCH);
        if (maxDelay <= 0 || maxDelay > 5) {
            throw new IllegalArgumentException("max delay must be between 0 and 5");
        }
        Objects.requireNonNull(st);
        this.maxDelay = maxDelay;
        this.st = st;
    }

    @Override
    protected StringBuilder printFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("HOST: " + MULTICAST_ADDRESS.getHostAddress() + ":" + 1900 + "\r\n");
        sb.append("ST: " + this.st + "\r\n");
        sb.append("MAN: \"ssdp:discover\"\r\n");
        sb.append("MX: " + this.maxDelay + "\r\n");
        return sb;
    }

    @Override
    public boolean rootDevice() {
        return this.st.equals("upnp:rootdevice");
    }

    public static final MessageSearch getDefaultSearchMessage() {
        MessageSearch search = null;
        if (defaultMessage != null) {
            search = defaultMessage.get();
        }
        if (search == null) {
            search = new MessageSearch();
            defaultMessage = new SoftReference<MessageSearch>(search);
        }
        return search;
    }
}

