/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.external.actionadmin;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.tools.resourcemanipulator.timer.CountDownDelayedExecutionTimer;
import org.smartrplace.external.actionadmin.ActionAdminController;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class ActionAdminApp
implements Application {
    public static final String urlPath = "/org/smartrplace/external/actionadmin";
    private OgemaLogger log;
    private ApplicationManager appMan;
    private ActionAdminController controller;
    private WidgetApp widgetApp;
    @Reference
    private OgemaGuiService guiService;

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.log = appManager.getLogger();
        this.widgetApp = this.guiService.createWidgetApp(urlPath, appManager);
        final WidgetPage page = this.widgetApp.createStartPage();
        new CountDownDelayedExecutionTimer(appManager, 5000L){

            public void delayedExecution() {
                ActionAdminApp.this.controller = new ActionAdminController(ActionAdminApp.this.appMan, page);
            }
        };
    }

    public void stop(Application.AppStopReason reason) {
        if (this.widgetApp != null) {
            this.widgetApp.close();
        }
        if (this.controller != null) {
            this.controller.close();
        }
        this.log.info("{} stopped", (Object)this.getClass().getName());
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }
}

