/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.sim.resource.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;

class CyclicIterator
implements Iterator<SampledValue> {
    private final ReadOnlyTimeSeries base;
    private Iterator<SampledValue> it;
    private SampledValue last;
    private long lastT;
    private long lastDiff;
    private float lastValue;

    CyclicIterator(ReadOnlyTimeSeries timeSeries, long startTime) {
        this.base = timeSeries;
        this.it = timeSeries.iterator();
        this.lastT = startTime;
        if (this.it.hasNext()) {
            this.last = this.it.next();
            this.lastDiff = 1000L;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.base.isEmpty();
    }

    @Override
    public SampledValue next() {
        if (!this.it.hasNext()) {
            this.it = this.base.iterator();
            if (!this.it.hasNext()) {
                throw new NoSuchElementException("No further element");
            }
            SampledValue first = this.it.next();
            this.lastT += this.lastDiff;
            this.last = first;
            SampledValue next = new SampledValue(first.getValue(), this.lastT, first.getQuality());
            return next;
        }
        SampledValue next = this.it.next();
        this.lastDiff = next.getTimestamp() - this.last.getTimestamp();
        this.lastT += this.lastDiff;
        this.last = next;
        SampledValue computed = new SampledValue(next.getValue(), this.lastT, next.getQuality());
        return computed;
    }
}

