/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.sim.resource.impl;

import java.util.ArrayList;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.schedule.AbsoluteSchedule;
import org.ogema.core.model.schedule.Schedule;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.tools.resource.util.LoggingUtils;
import org.ogema.tools.resource.util.ValueResourceUtils;
import org.smartrplace.sim.resource.impl.ConfigPattern;
import org.smartrplace.sim.resource.impl.CyclicIterator;

class ResourceSimulation
implements TimerListener {
    private final SingleValueResource resource;
    private final ReadOnlyTimeSeries input;
    private final boolean additive;
    private final Schedule forecast;
    private final CyclicIterator iterator;
    private final ConfigPattern config;
    private final Timer timer;
    private long time = -1L;
    private long offsetTime = Long.MIN_VALUE;
    private float offset = 0.0f;

    ResourceSimulation(ConfigPattern config, ReadOnlyTimeSeries input, ApplicationManager appMan) {
        this.config = config;
        this.resource = (SingleValueResource)config.target.getLocationResource();
        this.input = input;
        boolean bl = this.additive = config.additive.isActive() && config.additive.getValue();
        if (!config.forecast.isActive()) {
            this.forecast = null;
            this.iterator = null;
        } else {
            String scheduleName = config.forecast.getValue();
            Schedule sched0 = (Schedule)this.resource.getSubResource(scheduleName);
            if (sched0 == null) {
                sched0 = (Schedule)((AbsoluteSchedule)this.resource.getSubResource(scheduleName, AbsoluteSchedule.class)).create();
            }
            this.forecast = sched0;
            sched0.activate(false);
            this.iterator = new CyclicIterator(input, appMan.getFrameworkTime());
        }
        this.timer = appMan.createTimer(10000000L, (TimerListener)this);
        this.timerElapsed(this.timer);
        this.resource.activate(false);
        LoggingUtils.activateLogging((SingleValueResource)this.resource, (long)-2L);
        appMan.getLogger().debug("Simulation started for resource {}", (Object)this.resource);
    }

    public void timerElapsed(Timer timer) {
        long diff;
        SampledValue next = this.input.getNextValue(this.time + 1L);
        if (next == null) {
            this.time = -1L;
            this.offset = ValueResourceUtils.getFloatValue((SingleValueResource)this.resource);
            this.offsetTime = Long.MIN_VALUE;
            this.timerElapsed(timer);
            return;
        }
        timer.stop();
        this.time = next.getTimestamp();
        Object value = this.additive ? new FloatValue(this.offset + next.getValue().getFloatValue()) : next.getValue();
        ResourceSimulation.setValue(this.resource, value);
        SampledValue coming = this.input.getNextValue(this.time + 1L);
        long now = timer.getExecutionTime();
        if (this.forecast != null) {
            long horizon = ResourceSimulation.getForecastHorizon(this.config);
            SampledValue last = this.forecast.getPreviousValue(Long.MAX_VALUE);
            long startTime = last == null ? now : (last.getTimestamp() >= now + horizon ? Long.MAX_VALUE : Math.max(now, last.getTimestamp() + 1L));
            if (startTime < now + horizon) {
                ArrayList<SampledValue> forecastValues = new ArrayList<SampledValue>();
                while (true) {
                    SampledValue next0;
                    if ((next0 = this.iterator.next()).getTimestamp() < startTime) {
                        continue;
                    }
                    forecastValues.add(next0);
                    if (next0.getTimestamp() >= now + horizon) break;
                }
                if (!forecastValues.isEmpty()) {
                    this.forecast.addValues(forecastValues);
                }
            }
        }
        if (this.offsetTime == Long.MIN_VALUE) {
            this.offsetTime = now - this.time;
        }
        long l = diff = coming == null ? 5000L : coming.getTimestamp() + this.offsetTime - now;
        if (diff <= 0L) {
            this.timerElapsed(timer);
            return;
        }
        timer.setTimingInterval(diff);
        timer.resume();
    }

    void close() {
        this.timer.destroy();
    }

    private static void setValue(SingleValueResource resource, Value value) {
        if (resource instanceof BooleanResource) {
            if (!(value instanceof BooleanValue)) {
                ((BooleanResource)resource).setValue((double)Math.abs(value.getFloatValue()) > 1.0E-4);
            } else {
                ((BooleanResource)resource).setValue(value.getBooleanValue());
            }
        } else {
            ValueResourceUtils.setValue((SingleValueResource)resource, (Value)value);
        }
    }

    private static long getForecastHorizon(ConfigPattern config) {
        long try0;
        if (config.forecastHorizon.isActive() && (try0 = config.forecastHorizon.getValue()) > 0L) {
            return try0;
        }
        return 86400000L;
    }
}

