/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.sim.resource.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.units.ElectricCurrentResource;
import org.ogema.core.model.units.PowerResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.model.units.VoltageResource;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.CompoundResourceEvent;
import org.ogema.core.resourcemanager.pattern.PatternChangeListener;
import org.ogema.core.resourcemanager.pattern.PatternListener;
import org.ogema.core.resourcemanager.pattern.ResourcePattern;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.model.connections.ElectricityConnection;
import org.ogema.model.locations.Room;
import org.ogema.tools.resource.util.ResourceUtils;
import org.ogema.tools.timeseries.implementations.FloatTreeTimeSeries;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.smartrplace.sim.resource.config.ScheduledSimulationConfig;
import org.smartrplace.sim.resource.impl.ConfigPattern;
import org.smartrplace.sim.resource.impl.ResourceSimulation;
import org.smartrplace.sim.resource.impl.Type;

@Component(service={Application.class})
public class ResourceSimulationOrchestration
implements Application,
PatternListener<ConfigPattern>,
PatternChangeListener<ConfigPattern> {
    public static final String DEFAULT_BASE_FOLDER = "simTemplates";
    public static final String BASE_FOLDER_PROPERTY = "org.smartrplace.sim.template.folder";
    private ApplicationManager appMan;
    private final Map<String, ResourceSimulation> simulations = new HashMap<String, ResourceSimulation>(8);
    private final Map<Type, ReadOnlyTimeSeries> simulationTemplates = new HashMap<Type, ReadOnlyTimeSeries>(8);
    private volatile Bundle bundle;
    private volatile String baseFolder;
    private static final CSVFormat format = CSVFormat.DEFAULT.withDelimiter(';');

    @Activate
    protected void activate(BundleContext ctx, Map<String, ?> properties) {
        String baseFolder = null;
        baseFolder = properties.containsKey("basefolder") ? (String)properties.get("basefolder") : ctx.getProperty(BASE_FOLDER_PROPERTY);
        if (baseFolder == null) {
            baseFolder = DEFAULT_BASE_FOLDER;
        }
        if ((baseFolder = baseFolder.replace('\\', '/')).endsWith("/")) {
            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
        }
        this.baseFolder = baseFolder;
        this.bundle = ctx.getBundle();
    }

    @Deactivate
    protected void deactivate() {
        this.bundle = null;
        this.baseFolder = null;
    }

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        appManager.getResourcePatternAccess().addPatternDemand(ConfigPattern.class, (PatternListener)this, AccessPriority.PRIO_LOWEST);
    }

    public void stop(Application.AppStopReason reason) {
        ApplicationManager appMan = this.appMan;
        if (appMan != null) {
            try {
                appMan.getResourcePatternAccess().removePatternDemand(ConfigPattern.class, (PatternListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (ResourceSimulation sim : this.simulations.values()) {
            sim.close();
        }
        this.simulations.clear();
        this.simulationTemplates.clear();
        this.appMan = null;
        this.bundle = null;
    }

    public void patternChanged(ConfigPattern pattern, List<CompoundResourceEvent<?>> changes) {
        this.configGone(pattern);
        this.newConfig(pattern);
    }

    public void patternAvailable(ConfigPattern pattern) {
        this.newConfig(pattern);
        this.appMan.getResourcePatternAccess().addPatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this, ConfigPattern.class);
    }

    public void patternUnavailable(ConfigPattern pattern) {
        this.configGone(pattern);
        this.appMan.getResourcePatternAccess().removePatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this);
    }

    private void configGone(ConfigPattern pattern) {
        ResourceSimulation sim = this.simulations.remove(((ScheduledSimulationConfig)pattern.model).getPath());
        if (sim != null) {
            sim.close();
        }
    }

    private ResourceSimulation newConfig(ConfigPattern pattern) {
        ReadOnlyTimeSeries timeSeries;
        Type type = ResourceSimulationOrchestration.getType(pattern);
        if (type == null) {
            this.appMan.getLogger().warn("Could not determine simulation type for target {}, configuration {}", (Object)pattern.target.getLocation(), (Object)pattern.model);
            return null;
        }
        try {
            timeSeries = this.getSimulationTemplate(type);
            if (timeSeries == null) {
                this.appMan.getLogger().warn("Simulation template for type {} not found. Cannot simulate resource {}, config {}", new Object[]{type, pattern.target.getLocation(), pattern.model});
                return null;
            }
        }
        catch (UncheckedIOException e) {
            this.appMan.getLogger().error("Failed to load simulation template", (Throwable)e.getCause());
            return null;
        }
        try {
            ResourceSimulation sim = new ResourceSimulation(pattern, timeSeries, this.appMan);
            ResourceSimulation old = this.simulations.put(((ScheduledSimulationConfig)pattern.model).getPath(), sim);
            if (old != null) {
                old.close();
            }
            return sim;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private ReadOnlyTimeSeries getSimulationTemplate(Type type) {
        return this.simulationTemplates.computeIfAbsent(type, key -> ResourceSimulationOrchestration.getTemplateTimeseries(key, this.baseFolder, this.bundle));
    }

    public static ReadOnlyTimeSeries getTemplateTimeseries(Type type, String baseFolder, Bundle bundle) {
        String secondary;
        String primary = type.primaryType;
        String string = secondary = type.secondaryType != null ? type.secondaryType : "default.csv";
        if (!secondary.toLowerCase().endsWith(".csv")) {
            secondary = secondary + ".csv";
        }
        String path = baseFolder + "/" + primary + "/" + secondary;
        Path file = Paths.get(path, new String[0]);
        try {
            InputStream in;
            if (Files.isRegularFile(file, new LinkOption[0])) {
                in = Files.newInputStream(file, new OpenOption[0]);
            } else {
                Enumeration urls = bundle.findEntries("simTemplates/" + primary, secondary, false);
                if (urls != null && urls.hasMoreElements()) {
                    in = ((URL)urls.nextElement()).openStream();
                } else {
                    return null;
                }
            }
            return ResourceSimulationOrchestration.parse(in);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReadOnlyTimeSeries parse(InputStream stream) throws IOException {
        try {
            ArrayList<SampledValue> values = new ArrayList<SampledValue>(1000);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                 CSVParser parser = new CSVParser((Reader)reader, format);){
                long initialTimestamp = Long.MIN_VALUE;
                for (CSVRecord record : parser) {
                    long timestamp;
                    try {
                        timestamp = Long.parseLong(record.get(0));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (initialTimestamp == Long.MIN_VALUE) {
                        initialTimestamp = timestamp;
                    }
                    float value = Float.parseFloat(record.get(1));
                    values.add(new SampledValue((Value)new FloatValue(value), timestamp - initialTimestamp, Quality.GOOD));
                }
            }
            FloatTreeTimeSeries timeSeries = new FloatTreeTimeSeries();
            timeSeries.addValues(values);
            var3_3 = timeSeries;
            return var3_3;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Type getType(ConfigPattern pattern) {
        String primary;
        if (pattern.typePrimary.isActive() && (primary = pattern.typePrimary.getValue()) != null && !primary.isEmpty()) {
            String typeSeconday = pattern.typeSecondary.isActive() ? pattern.typeSecondary.getValue() : null;
            return new Type(primary, typeSeconday);
        }
        if (pattern.target instanceof PowerResource) {
            int phase = ResourceSimulationOrchestration.isSubPhase((Resource)pattern.target);
            return new Type("power", phase == 0 ? null : "subphase" + phase);
        }
        if (pattern.target instanceof TemperatureResource) {
            Room location = null;
            try {
                location = ResourceUtils.getDeviceLocationRoom((Resource)pattern.target);
            }
            catch (SecurityException typeSeconday) {
                // empty catch block
            }
            boolean outside = location != null && location.type().isActive() && location.type().getValue() == 0;
            return new Type("temperature", outside ? "outside" : "inside");
        }
        if (pattern.target instanceof VoltageResource) {
            int phase = ResourceSimulationOrchestration.isSubPhase((Resource)pattern.target);
            return new Type("voltage", phase == 0 ? null : "subphase" + phase);
        }
        if (pattern.target instanceof ElectricCurrentResource) {
            int phase = ResourceSimulationOrchestration.isSubPhase((Resource)pattern.target);
            return new Type("current", phase == 0 ? null : "subphase" + phase);
        }
        return null;
    }

    private static int isSubPhase(Resource r) {
        try {
            Resource child = r.getLocationResource();
            for (Resource parent = child.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof ResourceList && ((ResourceList)parent).getElementType() == ElectricityConnection.class && parent.getName().equals("subPhaseConnections")) {
                    if (child.getName().startsWith("subPhaseConnections_")) {
                        try {
                            return Integer.parseInt(child.getName().substring("subPhaseConnections_".length())) + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return 99;
                }
                child = parent;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return 0;
    }
}

