/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.sim.resource.impl.gui;

import de.iwes.widgets.api.extended.OgemaWidgetBase;
import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.extended.resource.DefaultResourceTemplate;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirm;
import de.iwes.widgets.html.buttonconfirm.ButtonConfirmData;
import de.iwes.widgets.html.complextable.DynamicTableData;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.button.ButtonData;
import de.iwes.widgets.html.form.checkbox.Checkbox2;
import de.iwes.widgets.html.form.checkbox.CheckboxEntry;
import de.iwes.widgets.html.form.checkbox.DefaultCheckboxEntry;
import de.iwes.widgets.html.form.dropdown.Dropdown;
import de.iwes.widgets.html.form.dropdown.TemplateDropdown;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.html.form.textfield.ValueInputField;
import de.iwes.widgets.html.multiselect.Multiselect;
import de.iwes.widgets.html.multiselect.TemplateMultiselect;
import de.iwes.widgets.html.popup.Popup;
import de.iwes.widgets.pattern.widget.table.PatternTable;
import de.iwes.widgets.reswidget.scheduleplot.flot.SchedulePlotFlot;
import de.iwes.widgets.reswidget.scheduleviewer.DefaultSchedulePresentationData;
import de.iwes.widgets.template.DisplayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.model.units.ElectricCurrentResource;
import org.ogema.core.model.units.EnergyResource;
import org.ogema.core.model.units.PowerResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.model.units.VoltageResource;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.timeseries.InterpolationMode;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.tools.resource.util.LoggingUtils;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.sim.resource.config.ScheduledSimulationConfig;
import org.smartrplace.sim.resource.impl.ConfigPattern;
import org.smartrplace.sim.resource.impl.ResourceSimulationOrchestration;
import org.smartrplace.sim.resource.impl.Type;
import org.smartrplace.sim.resource.impl.gui.TypeCache;

class PageBuilder {
    private static final String BASE_RESOURCE = "resourceSimulations";
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final Header simulationsHeader;
    private final PatternTable<ConfigPattern> table;
    private final Popup newConfigPopup;
    private final TemplateDropdown<Class<? extends SingleValueResource>> typeSelector;
    private final Checkbox2 resSelectorCheckbox;
    private final TextField newPathField;
    private final TextField schedulePathField;
    private final ValueInputField<Long> scheduleHorizonMinutes;
    private final TemplateDropdown<SingleValueResource> targetSelector;
    private final Dropdown primaryTypeSelector;
    private final TemplateDropdown<Type> secondaryTypeSelector;
    private final Button newConfigSubmit;
    private final Button newConfigPopupTrigger;
    private final Popup plotPopup;
    private final SchedulePlotFlot schedulePlot;
    private final Header templatesHeader;
    private final Multiselect templatePrimarySelector;
    private final TemplateMultiselect<Type> templateSecondarySelector;
    private final SchedulePlotFlot templatePlot;
    private final Button templatePlotSubmit;

    PageBuilder(final ApplicationManager appMan, final WidgetPage<?> page, final TypeCache typeCache) {
        this.page = page;
        this.header = new Header(page, "header", "Resource simulations");
        this.header.setDefaultColor("blue");
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        this.simulationsHeader = new Header(page, "simulationsHeadeR", "Simulations");
        this.simulationsHeader.setDefaultHeaderType(2);
        this.simulationsHeader.setDefaultColor("blue");
        RowTemplate<ConfigPattern> tableTemplate = new RowTemplate<ConfigPattern>(){
            final Map<String, Object> header;
            {
                LinkedHashMap<String, String> header = new LinkedHashMap<String, String>(5);
                header.put("target", "Target");
                header.put("type", "Simulation type");
                header.put("path", "Config path");
                header.put("plot", "Plot");
                header.put("delete", "Delete");
                this.header = Collections.unmodifiableMap(header);
            }

            public RowTemplate.Row addRow(final ConfigPattern object, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                String id = ResourceUtils.getValidResourceName((String)this.getLineId(object));
                Label target = new Label((OgemaWidget)PageBuilder.this.table, id + "_targetLabel", req){

                    public void onGET(OgemaHttpRequest req) {
                        this.setText(object.target.getLocation(), req);
                    }
                };
                row.addCell("target", (Object)target);
                Label simType = new Label((OgemaWidget)PageBuilder.this.table, id + "_simType", req){

                    public void onGET(OgemaHttpRequest req) {
                        String primary = object.typePrimary.getValue();
                        String secondary = object.typeSecondary.isActive() ? object.typeSecondary.getValue() : "default";
                        this.setText(primary + ": " + secondary, req);
                    }
                };
                row.addCell("type", (Object)simType);
                row.addCell("path", (Object)((ScheduledSimulationConfig)object.model).getPath());
                Button showPlot = new Button((OgemaWidget)PageBuilder.this.table, id + "_plot", req){

                    public void onPrePOST(String data, OgemaHttpRequest req) {
                        RecordedData timeSeries = LoggingUtils.getHistoricalData((SingleValueResource)((SingleValueResource)object.target.getLocationResource()));
                        Map<String, DefaultSchedulePresentationData> schedules = Collections.singletonMap(object.target.getLocation(), new DefaultSchedulePresentationData((ReadOnlyTimeSeries)timeSeries, Float.class, object.target.getLocation(), InterpolationMode.LINEAR));
                        PageBuilder.this.schedulePlot.getScheduleData(req).setSchedules(schedules);
                    }
                };
                showPlot.setDefaultText("Show");
                showPlot.addDefaultStyle(ButtonData.BOOTSTRAP_LIGHT_BLUE);
                showPlot.triggerAction((OgemaWidget)PageBuilder.this.plotPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET, req);
                showPlot.triggerAction((OgemaWidget)PageBuilder.this.schedulePlot, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                row.addCell("plot", (Object)showPlot);
                ButtonConfirm deleteButton = new ButtonConfirm((OgemaWidget)PageBuilder.this.table, id + "_deleteBtn", req){

                    public void onPOSTComplete(String data, OgemaHttpRequest req) {
                        ((ScheduledSimulationConfig)object.model).delete();
                    }
                };
                deleteButton.setDefaultText("Delete");
                deleteButton.setDefaultCancelBtnMsg("Cancel");
                deleteButton.setDefaultConfirmBtnMsg("Delete");
                deleteButton.setDefaultConfirmMsg("Do you really want to delete the simulation?");
                deleteButton.setDefaultConfirmPopupTitle("Delete simulation");
                deleteButton.addDefaultStyle(ButtonConfirmData.CANCEL_LIGHT_BLUE);
                deleteButton.addDefaultStyle(ButtonConfirmData.CONFIRM_ORANGE);
                deleteButton.addDefaultStyle(ButtonData.BOOTSTRAP_RED);
                deleteButton.triggerAction((OgemaWidget)PageBuilder.this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
                row.addCell("delete", (Object)deleteButton);
                return row;
            }

            public String getLineId(ConfigPattern object) {
                return ((ScheduledSimulationConfig)object.model).getPath();
            }

            public Map<String, Object> getHeader() {
                return this.header;
            }
        };
        this.table = new PatternTable(page, "table", false, ConfigPattern.class, (RowTemplate)tableTemplate, appMan.getResourcePatternAccess());
        this.table.addDefaultStyle(DynamicTableData.TABLE_STRIPED);
        this.newConfigPopup = new Popup(page, "popup", true);
        this.typeSelector = new TemplateDropdown(page, "typeSelector");
        this.typeSelector.setDefaultItems(Arrays.asList(FloatResource.class, IntegerResource.class, BooleanResource.class, PowerResource.class, TemperatureResource.class, EnergyResource.class, ElectricCurrentResource.class, VoltageResource.class));
        this.typeSelector.setTemplate((DisplayTemplate)new DisplayTemplate<Class<? extends SingleValueResource>>(){

            public String getLabel(Class<? extends SingleValueResource> object, OgemaLocale locale) {
                return object.getSimpleName();
            }

            public String getId(Class<? extends SingleValueResource> object) {
                return object.getName();
            }
        });
        this.typeSelector.selectDefaultItem(FloatResource.class);
        this.resSelectorCheckbox = new Checkbox2(page, "resSelectorCheckbox");
        this.resSelectorCheckbox.setDefaultCheckboxList(Arrays.asList(new DefaultCheckboxEntry("existing", "Simulate existing resource", true), new DefaultCheckboxEntry("forecast", "Create a forecast schedule", false), new DefaultCheckboxEntry("additive", "Additive/create offset at overflow", false)));
        this.newPathField = new TextField(page, "newPathField"){

            public void onGET(OgemaHttpRequest req) {
                boolean existing = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(0)).isChecked();
                if (existing) {
                    this.disable(req);
                    return;
                }
                this.enable(req);
            }
        };
        this.targetSelector = new TemplateDropdown<SingleValueResource>(page, "targetSelector"){

            public void onGET(OgemaHttpRequest req) {
                boolean existing = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(0)).isChecked();
                if (!existing) {
                    this.update(Collections.emptyList(), req);
                    this.disable(req);
                    return;
                }
                this.enable(req);
                Class type = (Class)PageBuilder.this.typeSelector.getSelectedItem(req);
                List configs = appMan.getResourcePatternAccess().getPatterns(ConfigPattern.class, AccessPriority.PRIO_LOWEST);
                List resources = appMan.getResourceAccess().getResources(type).stream().filter(resource -> !configs.stream().filter(cfg -> cfg.target.equalsLocation((Resource)resource)).findAny().isPresent()).collect(Collectors.toList());
                this.update(resources, req);
            }
        };
        this.targetSelector.setTemplate((DisplayTemplate)new DefaultResourceTemplate());
        this.primaryTypeSelector = new PrimaryTypeSelectorSingle(page, "primaryTypeSelector", typeCache);
        this.secondaryTypeSelector = new SecondaryTypeSelectorSingle(page, "secondaryTypeSelector", (PrimaryTypeSelectorSingle)this.primaryTypeSelector, typeCache);
        this.schedulePathField = new TextField(page, "schedulePathField", "forecast"){

            public void onGET(OgemaHttpRequest req) {
                boolean createForecast = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(1)).isChecked();
                if (!createForecast) {
                    this.disable(req);
                } else {
                    this.enable(req);
                }
            }
        };
        this.scheduleHorizonMinutes = new ValueInputField<Long>(page, "scheduleHorizonMinutes", Long.class){

            public void onGET(OgemaHttpRequest req) {
                boolean createForecast = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(1)).isChecked();
                if (!createForecast) {
                    this.disable(req);
                } else {
                    this.enable(req);
                }
            }
        };
        this.scheduleHorizonMinutes.setDefaultNumericalValue((Number)1440L);
        this.scheduleHorizonMinutes.setDefaultLowerBound(1.0);
        this.newConfigSubmit = new Button(page, "newConfigSubmit", "Create new configuration"){

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                boolean additive;
                SingleValueResource resource;
                Type type = (Type)PageBuilder.this.secondaryTypeSelector.getSelectedItem(req);
                if (type == null) {
                    return;
                }
                boolean existing = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(0)).isChecked();
                if (existing) {
                    resource = (SingleValueResource)PageBuilder.this.targetSelector.getSelectedItem(req);
                } else {
                    String path = PageBuilder.this.newPathField.getValue(req).trim();
                    if (path.isEmpty()) {
                        PageBuilder.this.alert.showAlert("Resource path must not be empty", false, req);
                        return;
                    }
                    Resource old = appMan.getResourceAccess().getResource(path);
                    if (old != null && old.exists()) {
                        PageBuilder.this.alert.showAlert("Resource " + path + " already exists", false, req);
                        return;
                    }
                    int idx = path.lastIndexOf(47);
                    if (idx < 0) {
                        resource = (SingleValueResource)appMan.getResourceManagement().createResource(path, (Class)PageBuilder.this.typeSelector.getSelectedItem(req));
                    } else {
                        String parentPath = path.substring(0, idx);
                        Resource parent = appMan.getResourceAccess().getResource(parentPath);
                        if (parent == null) {
                            PageBuilder.this.alert.showAlert("Parent resource " + parentPath + " does not exist", false, req);
                            return;
                        }
                        if (!parent.exists()) {
                            PageBuilder.this.alert.showAlert("Parent resource " + parentPath + " is virtual", false, req);
                            return;
                        }
                        resource = (SingleValueResource)parent.addDecorator(path.substring(idx + 1), (Class)PageBuilder.this.typeSelector.getSelectedItem(req));
                        if (resource instanceof TemperatureResource) {
                            ((TemperatureResource)resource).setCelsius(15.0f);
                        }
                    }
                }
                if (resource == null) {
                    return;
                }
                boolean createForecast = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(1)).isChecked();
                String forecast = createForecast ? PageBuilder.this.schedulePathField.getValue(req) : null;
                Long horizon = (Long)PageBuilder.this.scheduleHorizonMinutes.getNumericalValue(req);
                if (forecast != null && !ResourceUtils.isValidResourcePath((String)forecast)) {
                    PageBuilder.this.alert.showAlert("Invalid schedule name: " + forecast, false, req);
                    return;
                }
                if (forecast != null && horizon == null) {
                    PageBuilder.this.alert.showAlert("Please enter a valid forecast horizon.", false, req);
                    return;
                }
                ResourceList configs = (ResourceList)appMan.getResourceManagement().createResource(PageBuilder.BASE_RESOURCE, ResourceList.class);
                configs.setElementType(ScheduledSimulationConfig.class);
                if (!configs.isActive()) {
                    configs.activate(false);
                }
                resource.activate(false);
                ScheduledSimulationConfig config = (ScheduledSimulationConfig)configs.add();
                config.target().setAsReference((Resource)resource);
                ((StringResource)config.typePrimary().create()).setValue(type.primaryType);
                if (type.secondaryType != null) {
                    ((StringResource)config.typeSecondary().create()).setValue(type.secondaryType);
                }
                if (forecast != null) {
                    ((StringResource)config.forecastSchedule().create()).setValue(forecast);
                    ((TimeResource)config.forecastHorizon().create()).setValue(horizon.longValue());
                }
                if (additive = ((CheckboxEntry)PageBuilder.this.resSelectorCheckbox.getCheckboxList(req).get(2)).isChecked()) {
                    ((BooleanResource)config.additive().create()).setValue(true);
                }
                config.activate(true);
                PageBuilder.this.alert.showAlert("New simulation configuration created for resource " + resource, true, req);
            }
        };
        this.newConfigPopupTrigger = new Button(page, "newConfigPopupTrigger", "Create new simulation");
        this.newConfigPopupTrigger.addDefaultStyle(ButtonData.BOOTSTRAP_LIGHT_BLUE);
        this.plotPopup = new Popup(page, "plotPopup", true);
        this.schedulePlot = new SchedulePlotFlot(page, "schedulePlot", false);
        this.plotPopup.setDefaultTitle("Log data plot");
        this.plotPopup.setDefaultWidth("80%");
        this.plotPopup.setBody((OgemaWidgetBase)this.schedulePlot, null);
        Button dummy = new Button(page, "plotUpdate", "Update");
        this.plotPopup.setFooter((OgemaWidgetBase)dummy, null);
        dummy.triggerAction((OgemaWidget)this.schedulePlot, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.templatesHeader = new Header(page, "templatesHeader", "Templates");
        this.templatesHeader.setDefaultHeaderType(2);
        this.templatesHeader.setDefaultColor("blue");
        this.templatePrimarySelector = new PrimaryTypeSelector(page, "templatePrimarySelecotr", typeCache);
        this.templateSecondarySelector = new SecondaryTypeSelector(page, "templateSecondarySelector", (PrimaryTypeSelector)this.templatePrimarySelector, typeCache);
        this.templatePlot = new SchedulePlotFlot(page, "templatePlot", false){

            public void onGET(OgemaHttpRequest req) {
                OgemaWidget trigger = page.getTriggeringWidget(req);
                if (trigger == null) {
                    return;
                }
                List types = PageBuilder.this.templateSecondarySelector.getSelectedItems(req);
                if (types == null) {
                    this.getScheduleData(req).setSchedules(Collections.emptyMap());
                    return;
                }
                HashMap<String, DefaultSchedulePresentationData> map = new HashMap<String, DefaultSchedulePresentationData>(types.size() + 2);
                for (Type type : types) {
                    ReadOnlyTimeSeries timeSeries = ResourceSimulationOrchestration.getTemplateTimeseries(type, typeCache.baseFolder, typeCache.ctx.getBundle());
                    if (timeSeries == null) continue;
                    String id = type.primaryType + ": " + type.secondaryType;
                    map.put(type.toString(), new DefaultSchedulePresentationData(timeSeries, Float.class, type.toString(), InterpolationMode.STEPS));
                }
                this.getScheduleData(req).setSchedules(map);
            }
        };
        this.templatePlotSubmit = new Button(page, "templatePlotSubmit", "Show templates");
        page.showOverlay(true);
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.alert).append((OgemaWidget)this.simulationsHeader).append(this.table).linebreak().append((OgemaWidget)this.newConfigPopupTrigger).linebreak();
        int row = 0;
        this.page.append((OgemaWidget)this.templatesHeader).append((HtmlItem)new StaticTable(3, 3, new int[]{3, 3, 6}).setContent(row, 0, "Select primary type").setContent(row++, 1, (OgemaWidget)this.templatePrimarySelector).setContent(row, 0, "Select secondary type").setContent(row++, 1, this.templateSecondarySelector).setContent(row++, 1, (OgemaWidget)this.templatePlotSubmit)).linebreak().append((OgemaWidget)this.templatePlot);
        PageSnippet body = new PageSnippet(this.page, "popupBody", true);
        row = 0;
        body.append((HtmlItem)new StaticTable(8, 2).setContent(row, 0, "Select resource type").setContent(row++, 1, this.typeSelector).setContent(row++, 1, (OgemaWidget)this.resSelectorCheckbox).setContent(row, 0, "Select target path").setContent(row++, 1, (OgemaWidget)this.newPathField).setContent(row, 0, "Select target resource").setContent(row++, 1, this.targetSelector).setContent(row, 0, "Select simulation type (primary)").setContent(row++, 1, (OgemaWidget)this.primaryTypeSelector).setContent(row, 0, "Select simulation type (secondary)").setContent(row++, 1, this.secondaryTypeSelector).setContent(row, 0, "Select forecast schedule").setContent(row++, 1, (OgemaWidget)this.schedulePathField).setContent(row, 0, "Set forecast horizon (minutes)").setContent(row++, 1, this.scheduleHorizonMinutes), null);
        this.newConfigPopup.setBody((OgemaWidgetBase)body, null);
        this.newConfigPopup.setFooter((OgemaWidgetBase)this.newConfigSubmit, null);
        this.newConfigPopup.setTitle("Create new simulation", null);
        this.page.linebreak().append((OgemaWidget)this.newConfigPopup).linebreak().append((OgemaWidget)this.plotPopup);
    }

    private final void setDependencies() {
        this.typeSelector.triggerAction(this.targetSelector, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newConfigSubmit.triggerAction(this.table, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.newConfigSubmit.triggerAction((OgemaWidget)this.newConfigPopup, TriggeringAction.POST_REQUEST, TriggeredAction.HIDE_WIDGET);
        this.newConfigPopupTrigger.triggerAction((OgemaWidget)this.newConfigPopup, TriggeringAction.POST_REQUEST, TriggeredAction.SHOW_WIDGET);
        this.newConfigPopupTrigger.triggerAction(this.targetSelector, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.resSelectorCheckbox.triggerAction((OgemaWidget)this.newPathField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.resSelectorCheckbox.triggerAction(this.targetSelector, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.resSelectorCheckbox.triggerAction((OgemaWidget)this.schedulePathField, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.resSelectorCheckbox.triggerAction(this.scheduleHorizonMinutes, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        this.templatePlotSubmit.triggerAction((OgemaWidget)this.templatePlot, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
    }

    private static class SecondaryTypeSelectorSingle
    extends TemplateDropdown<Type> {
        private final PrimaryTypeSelectorSingle primarySelector;
        private final TypeCache typeCache;

        SecondaryTypeSelectorSingle(WidgetPage<?> page, String id, PrimaryTypeSelectorSingle primarySelector, TypeCache typeCache) {
            super(page, id);
            this.primarySelector = primarySelector;
            this.typeCache = typeCache;
            primarySelector.triggerAction((OgemaWidget)this, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
            this.setTemplate((DisplayTemplate)new DisplayTemplate<Type>(){

                public String getId(Type object) {
                    return object.toString();
                }

                public String getLabel(Type object, OgemaLocale locale) {
                    return this.getId(object);
                }
            });
        }

        public void onGET(OgemaHttpRequest req) {
            String primary = this.primarySelector.getSelectedValue(req);
            if (primary == null || !this.typeCache.getSupportedTypes().containsKey(primary)) {
                this.update(Collections.emptyList(), req);
                return;
            }
            this.update(this.typeCache.getSupportedTypes().get(primary), req);
        }
    }

    private static class SecondaryTypeSelector
    extends TemplateMultiselect<Type> {
        private final PrimaryTypeSelector primarySelector;
        private final TypeCache typeCache;

        SecondaryTypeSelector(WidgetPage<?> page, String id, PrimaryTypeSelector primarySelector, TypeCache typeCache) {
            super(page, id);
            this.primarySelector = primarySelector;
            this.typeCache = typeCache;
            primarySelector.triggerAction((OgemaWidget)this, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
            this.setTemplate((DisplayTemplate)new DisplayTemplate<Type>(){

                public String getId(Type object) {
                    return object.toString();
                }

                public String getLabel(Type object, OgemaLocale locale) {
                    return this.getId(object);
                }
            });
        }

        public void onGET(OgemaHttpRequest req) {
            Set<String> keys = this.typeCache.getSupportedTypes().keySet();
            this.update(this.primarySelector.getSelectedValues(req).stream().filter(keys::contains).map(this.typeCache.getSupportedTypes()::get).flatMap(Collection::stream).collect(Collectors.toList()), req);
        }
    }

    private static class PrimaryTypeSelectorSingle
    extends Dropdown {
        private final TypeCache typeCache;

        PrimaryTypeSelectorSingle(WidgetPage<?> page, String id, TypeCache typeCache) {
            super(page, id);
            this.typeCache = typeCache;
        }

        public void onGET(OgemaHttpRequest req) {
            Map map = this.typeCache.getSupportedTypes().keySet().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
            this.update(map, req);
        }
    }

    private static class PrimaryTypeSelector
    extends Multiselect {
        private final TypeCache typeCache;

        PrimaryTypeSelector(WidgetPage<?> page, String id, TypeCache typeCache) {
            super(page, id);
            this.typeCache = typeCache;
        }

        public void onGET(OgemaHttpRequest req) {
            Map map = this.typeCache.getSupportedTypes().keySet().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
            this.update(map, req);
        }
    }
}

