/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.sim.resource.impl.gui;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;
import org.smartrplace.sim.resource.impl.Type;
import org.smartrplace.sim.resource.impl.gui.ResourceSimulationPage;

class TypeCache {
    final BundleContext ctx;
    final String baseFolder;
    private volatile SoftReference<Map<String, List<Type>>> supportedTypes = new SoftReference<Object>(null);

    TypeCache(BundleContext ctx, String baseFolder) {
        this.ctx = ctx;
        this.baseFolder = baseFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<Type>> getSupportedTypes() {
        Map<String, List<Type>> types = this.supportedTypes.get();
        if (types != null) {
            return types;
        }
        TypeCache typeCache = this;
        synchronized (typeCache) {
            types = this.supportedTypes.get();
            if (types != null) {
                return types;
            }
            types = this.getTypesInternal();
            this.supportedTypes = new SoftReference<Map<String, List<Type>>>(types);
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, List<Type>> getTypesInternal() {
        HashMap<String, List<Type>> types;
        block27: {
            types = new HashMap<String, List<Type>>();
            try {
                Path path = Paths.get(this.baseFolder, new String[0]);
                if (!Files.isDirectory(path, new LinkOption[0])) break block27;
                ArrayList streams = new ArrayList();
                try {
                    block28: {
                        Throwable throwable;
                        Stream<Path> stream;
                        block29: {
                            stream = Files.list(path);
                            throwable = null;
                            stream.filter(folder -> Files.isDirectory(folder, new LinkOption[0])).flatMap(folder -> {
                                try {
                                    Stream<Path> substream = Files.list(folder);
                                    streams.add(substream);
                                    return substream;
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            }).filter(file -> Files.isRegularFile(file, new LinkOption[0])).filter(file -> file.getFileName().toString().toLowerCase().endsWith(".csv")).map(file -> TypeCache.getType(file)).filter(type -> type != null).forEach(type -> {
                                if (!types.containsKey(type.primaryType)) {
                                    types.put(type.primaryType, new ArrayList(4));
                                }
                                ((List)types.get(type.primaryType)).add(type);
                            });
                            if (stream == null) break block28;
                            if (throwable == null) break block29;
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        stream.close();
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (stream != null) {
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                    }
                }
                finally {
                    for (Stream substream : streams) {
                        try {
                            substream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (IOException | UncheckedIOException | SecurityException e) {
                LoggerFactory.getLogger(ResourceSimulationPage.class).error("Failed to load simulation templates from rundir folder", (Throwable)e);
            }
        }
        try {
            Enumeration urls = this.ctx.getBundle().findEntries("simTemplates", "*", false);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    String path = url.getPath();
                    if (!path.endsWith("/")) continue;
                    String[] arr = path.substring(0, path.length() - 1).split("/");
                    String primaryType = arr[arr.length - 1];
                    Enumeration suburls = this.ctx.getBundle().findEntries(path, "*.csv", false);
                    if (suburls == null) continue;
                    while (suburls.hasMoreElements()) {
                        String[] subpath = ((URL)suburls.nextElement()).getPath().split("/");
                        String secondaryType = subpath[subpath.length - 1];
                        if (!secondaryType.toLowerCase().endsWith(".csv")) continue;
                        Type type2 = TypeCache.getType(primaryType, secondaryType);
                        if (!types.containsKey(type2.primaryType)) {
                            types.put(type2.primaryType, new ArrayList(4));
                        }
                        ((List)types.get(type2.primaryType)).add(type2);
                    }
                }
            }
        }
        catch (IllegalStateException | SecurityException e) {
            LoggerFactory.getLogger(ResourceSimulationPage.class).error("Failed to load simulation templates from bundle", (Throwable)e);
        }
        return types;
    }

    private static Type getType(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return null;
        }
        return TypeCache.getType(parent.getFileName().toString(), path.getFileName().toString());
    }

    private static Type getType(String primary, String secondary) {
        String secondaryType = secondary.toLowerCase().equals("default.csv") ? null : secondary.substring(0, secondary.length() - ".csv".length());
        return new Type(primary, secondaryType);
    }
}

