/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.heaterprofile;

import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.timeseries.InterpolationMode;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.tools.timeseries.implementations.FloatTreeTimeSeries;
import org.ogema.tools.timeseries.iterator.api.MultiTimeSeriesIterator;
import org.ogema.tools.timeseries.iterator.api.MultiTimeSeriesIteratorBuilder;
import org.ogema.tools.timeseries.iterator.api.SampledValueDataPoint;
import org.osgi.service.component.annotations.Component;
import org.smartrplace.tools.heaterprofile.Temperatures;
import org.smartrplace.tools.profiles.DataPoint;
import org.smartrplace.tools.profiles.ProfileTemplate;
import org.smartrplace.tools.profiles.State;
import org.smartrplace.tools.profiles.utils.StandardDataPoints;
import org.smartrplace.tools.profiles.utils.StateImpl;

@Component(service={ProfileTemplate.class}, property={"template_id=electricHeating", "label=Electric heating"})
public class HeaterProfileTemplate
implements ProfileTemplate {
    private static final float b = 18.678f;
    private static final float c = 257.14f;

    public String id() {
        return "electricHeating";
    }

    public String label(OgemaLocale locale) {
        if (locale == OgemaLocale.GERMAN) {
            return "Elektrische Heizung";
        }
        return "Electric heater profile";
    }

    public List<State> states() {
        return Arrays.asList(StateImpl.OFF, StateImpl.ON, StateImpl.OFF);
    }

    public List<DataPoint> primaryData() {
        return Arrays.asList(Temperatures.temperatureHeated, Temperatures.humidityHeated);
    }

    public List<DataPoint> contextData() {
        return Arrays.asList(StandardDataPoints.profileStartTime((boolean)false), StandardDataPoints.outsideTemperature((boolean)false), StandardDataPoints.outsideHumidity((boolean)false), StandardDataPoints.roomTemperature((boolean)false), StandardDataPoints.roomHumidity((boolean)false), StandardDataPoints.powerConsumption((boolean)false), StandardDataPoints.roomInfo((boolean)true));
    }

    public List<DataPoint> derivedData() {
        return Arrays.asList(Temperatures.dewPoint);
    }

    public Map<DataPoint, Object> derivedData(Map<DataPoint, Object> primaryData, Map<DataPoint, Object> contextData) {
        ReadOnlyTimeSeries tempInside = (ReadOnlyTimeSeries)primaryData.get(Temperatures.temperatureHeated);
        ReadOnlyTimeSeries humInside = (ReadOnlyTimeSeries)primaryData.get(Temperatures.humidityHeated);
        MultiTimeSeriesIterator it = MultiTimeSeriesIteratorBuilder.newBuilder(Arrays.asList(tempInside.iterator(), humInside.iterator())).setGlobalInterpolationMode(InterpolationMode.LINEAR).build();
        FloatTreeTimeSeries result = new FloatTreeTimeSeries();
        while (it.hasNext()) {
            SampledValueDataPoint point = it.next();
            float tIn = point.getElement(0).getValue().getFloatValue() - 273.15f;
            float hIn = point.getElement(1).getValue().getFloatValue();
            float gamma = (float)(Math.log(hIn) + (double)(18.678f * tIn / (257.14f + tIn)));
            float dewPoint = 257.14f * gamma / (18.678f - gamma);
            result.addValue(point.getTimestamp(), (Value)new FloatValue(dewPoint + 273.15f));
        }
        return Collections.singletonMap(Temperatures.dewPoint, result);
    }
}

