/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.exec.impl;

import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartrplace.tools.exec.impl.HousekeepingServiceConfig;
import org.smartrplace.tools.exec.impl.TaskWrapper;

@Component(service={HousekeepingExecService.class}, immediate=true, configurationPid={"org.smartrplace.tools.exec.Housekeeping"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"osgi.command.scope=housekeeping", "osgi.command.function=getExecTime", "osgi.command.function=getExecTimeFraction", "osgi.command.function=getIdleTime", "osgi.command.function=getTasks", "osgi.command.function=isTaskAlive", "osgi.command.function=restartTask", "osgi.command.function=stopTask"})
@Designate(ocd=HousekeepingServiceConfig.class)
public class HousekeepingExecService {
    private final Logger logger = LoggerFactory.getLogger(HousekeepingExecService.class);
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(task -> new Thread(task, "housekeeping-thread"));
    private final CompletableFuture<HousekeepingServiceConfig> config = new CompletableFuture();
    private final ConcurrentMap<Runnable, CompletableFuture<?>> submissionFutures = new ConcurrentHashMap();
    private final ConcurrentMap<TaskWrapper, ScheduledFuture<?>> futures = new ConcurrentHashMap();
    private volatile long startTimeMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(target="(&(org.smartrplace.tools.housekeeping.Delay=*)(org.smartrplace.tools.housekeeping.Period=*))", service=Runnable.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="addTask", unbind="removeTask")
    protected void addTask(ComponentServiceObjects<Runnable> taskService) {
        ChronoUnit unit;
        ServiceReference ref = taskService.getServiceReference();
        Object delay = ref.getProperty("org.smartrplace.tools.housekeeping.Delay");
        Object period = ref.getProperty("org.smartrplace.tools.housekeeping.Period");
        if (!(delay instanceof Long) || !(period instanceof Long)) {
            this.logger.error("Task service with invalid properties {}: delay: {}, period: {}", new Object[]{taskService, delay, period});
            return;
        }
        Object unitObj = ref.getProperty("org.smartrplace.tools.housekeeping.Unit");
        if (unitObj == null) {
            unit = ChronoUnit.MILLIS;
        } else {
            try {
                unit = ChronoUnit.valueOf(((String)unitObj).toUpperCase());
            }
            catch (ClassCastException | IllegalArgumentException e) {
                this.logger.error("Task with invalid unit property {}: {}", taskService, unitObj);
                return;
            }
        }
        long delay0 = (Long)delay;
        long period0 = (Long)period;
        long delay1 = unit.getDuration().multipliedBy(delay0).toMillis();
        long period1 = unit.getDuration().multipliedBy(period0).toMillis();
        Runnable task = (Runnable)taskService.getService();
        HousekeepingExecService housekeepingExecService = this;
        synchronized (housekeepingExecService) {
            this.submissionFutures.put(task, (CompletableFuture<?>)this.config.thenAcceptAsync(cfg -> {
                HousekeepingExecService housekeepingExecService = this;
                synchronized (housekeepingExecService) {
                    if (this.submissionFutures.remove(task) == null) {
                        return;
                    }
                    if (period1 <= 0L || period1 <= cfg.minPeriodMs()) {
                        this.logger.warn("Task service period too small: {}. Minimum period set: {}", (Object)period1, (Object)cfg.minPeriodMs());
                        taskService.ungetService((Object)task);
                        return;
                    }
                    TaskWrapper wrapper = new TaskWrapper(task);
                    this.submit(wrapper, delay1, period1);
                }
                this.logger.info("New housekeeping task {} with period {}, initial delay {}", new Object[]{task, period1, delay1});
            }));
        }
    }

    private final void submit(TaskWrapper task, long delay, long period) {
        this.futures.put(task, this.exec.scheduleWithFixedDelay(task, delay, period, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTask(ComponentServiceObjects<Runnable> taskService) {
        ScheduledFuture future;
        Runnable task = (Runnable)taskService.getService();
        HousekeepingExecService housekeepingExecService = this;
        synchronized (housekeepingExecService) {
            CompletableFuture submissionFuture = (CompletableFuture)this.submissionFutures.remove(task);
            if (submissionFuture != null) {
                submissionFuture.cancel(true);
            }
            future = (ScheduledFuture)this.futures.remove(new TaskWrapper(task));
        }
        if (future != null) {
            future.cancel(true);
            this.logger.info("Removing housekeeping task {}", (Object)task);
        }
        taskService.ungetService((Object)task);
        taskService.ungetService((Object)task);
    }

    @Activate
    protected void activate(HousekeepingServiceConfig config) {
        this.startTimeMillis = System.currentTimeMillis();
        this.config.complete(config);
        this.logger.debug("Housekeeping executor started with configuration: min period: {} ms, wait time: {} ms", (Object)config.minPeriodMs(), (Object)config.waitTimeOnShutdownMs());
    }

    @Deactivate
    protected void deactivate() {
        long waitTime;
        this.exec.shutdown();
        HousekeepingServiceConfig config = null;
        try {
            config = this.config.getNow(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = waitTime = config == null ? 0L : config.waitTimeOnShutdownMs();
        if (!this.exec.isTerminated() && waitTime > 0L) {
            try {
                this.exec.awaitTermination(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (!this.exec.isTerminated()) {
            int nr = this.exec.shutdownNow().size();
            this.logger.warn("Housekeeping exec service completed with unfinished tasks: {}", (Object)nr);
        }
    }

    @Descriptor(value="Get all active tasks. Returns a map task -> hash code.")
    public Map<Runnable, Integer> getTasks() {
        return this.futures.keySet().stream().map(TaskWrapper::getTask).collect(Collectors.toMap(Function.identity(), System::identityHashCode));
    }

    @Descriptor(value="Stop all tasks with the provided identity hash code. Returns the cancelled tasks.")
    public Collection<Runnable> stopTask(@Descriptor(value="The hash code of the task to be canceled") int identityHashCode) {
        return this.futures.entrySet().stream().filter(entry -> System.identityHashCode(((TaskWrapper)entry.getKey()).getTask()) == identityHashCode).filter(entry -> ((ScheduledFuture)entry.getValue()).cancel(true)).map(Map.Entry::getKey).map(TaskWrapper::getTask).collect(Collectors.toList());
    }

    @Descriptor(value="Check if a task with the provided identity hash code is still running.")
    public Map<Runnable, Boolean> isTaskAlive(@Descriptor(value="The hash code of the task to be checked. If absent, all tasks will be checked.") @Parameter(names={"-h", "--hashcode"}, absentValue="-1") int identityHashCode) {
        Stream<Object> stream = this.futures.entrySet().stream();
        if (identityHashCode != -1) {
            stream = stream.filter(entry -> System.identityHashCode(entry.getKey()) == identityHashCode);
        }
        return stream.collect(Collectors.toMap(entry -> ((TaskWrapper)entry.getKey()).getTask(), entry -> !((ScheduledFuture)entry.getValue()).isCancelled()));
    }

    @Descriptor(value="Restart all tasks (with the provided identity hash code, if any) which have been cancelled. Returns the tasks that have been restarted.")
    public Collection<Runnable> restartTask(@Descriptor(value="The time unit for delay and period, such as MILLISECONDS, MINUTES or HOURS. Default is MINUTES.") @Parameter(names={"-u", "--unit"}, absentValue="MINUTES") String timeUnit, @Descriptor(value="The hash code of the task to be checked. If absent or equal to -1, all tasks will be checked.") @Parameter(names={"-h", "--hashcode"}, absentValue="-1") int identityHashCode, @Descriptor(value="The initial delay before the first task execution") long delay, @Descriptor(value="The period between two task executions") long period) throws InterruptedException, ExecutionException, TimeoutException {
        TimeUnit unit;
        if (period <= 0L) {
            System.out.println("Period must be positive, got " + period);
            return Collections.emptyList();
        }
        try {
            unit = TimeUnit.valueOf(timeUnit.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.out.println("No such time unit: " + timeUnit);
            return Collections.emptyList();
        }
        long period1 = TimeUnit.MILLISECONDS.convert(period, unit);
        return (Collection)((CompletableFuture)this.config.thenApplyAsync(cfg -> {
            if (period1 < cfg.minPeriodMs()) {
                System.out.println("Period is below the configured threshold of " + cfg.minPeriodMs() + " ms.");
                return Collections.emptyList();
            }
            Stream<Object> stream = this.futures.entrySet().stream();
            if (identityHashCode != -1) {
                stream = stream.filter(entry -> System.identityHashCode(((TaskWrapper)entry.getKey()).getTask()) == identityHashCode);
            }
            Collection tasks = stream.filter(entry -> ((ScheduledFuture)entry.getValue()).isCancelled()).map(Map.Entry::getKey).collect(Collectors.toList());
            tasks.forEach(task -> this.submit((TaskWrapper)task, delay, period1));
            return tasks.stream().map(TaskWrapper::getTask).collect(Collectors.toList());
        })).get(30L, TimeUnit.SECONDS);
    }

    @Descriptor(value="Get total run time for all tasks or a specific task")
    public long getExecTime(@Descriptor(value="The time unit. Default is \"SECONDS\".") @Parameter(names={"-u", "--unit"}, absentValue="SECONDS") String timeUnit, @Descriptor(value="The hash code of the task to be measured. If absent or equal to -1, all tasks will be included.") @Parameter(names={"-h", "--hashcode"}, absentValue="-1") int identityHashCode) {
        TimeUnit unit = TimeUnit.valueOf(timeUnit.trim().toUpperCase());
        Stream<Object> stream = this.futures.keySet().stream();
        if (identityHashCode != -1) {
            stream = stream.filter(task -> System.identityHashCode(task.getTask()) == identityHashCode);
        }
        return stream.mapToLong(TaskWrapper::getExecutionTimeMillis).map(millis -> unit.convert(millis, TimeUnit.MILLISECONDS)).sum();
    }

    @Descriptor(value="Get the run time fraction for all tasks or a specific task")
    public float getExecTimeFraction(@Descriptor(value="The hash code of the task to be measured. If absent or equal to -1, all tasks will be included.") @Parameter(names={"-h", "--hashcode"}, absentValue="-1") int identityHashCode) {
        long activeTime = this.getExecTime(TimeUnit.MILLISECONDS.toString(), identityHashCode);
        long totalTime = System.currentTimeMillis() - this.startTimeMillis;
        return (float)activeTime / (float)totalTime;
    }

    @Descriptor(value="Get the idle time of the service")
    public long getIdleTime(@Descriptor(value="The time unit. Default is \"SECONDS\".") @Parameter(names={"-u", "--unit"}, absentValue="SECONDS") String timeUnit) {
        TimeUnit unit = TimeUnit.valueOf(timeUnit.trim().toUpperCase());
        long activeTime = this.getExecTime(TimeUnit.MILLISECONDS.toString(), -1);
        long totalTime = System.currentTimeMillis() - this.startTimeMillis;
        return unit.convert(totalTime - activeTime, TimeUnit.MILLISECONDS);
    }
}

