/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.exec.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

class TaskWrapper
implements Runnable {
    private final Runnable task;
    private final AtomicLong executionMillis = new AtomicLong(0L);

    TaskWrapper(Runnable task) {
        this.task = task;
    }

    @Override
    public void run() {
        long nanos = System.nanoTime();
        try {
            this.task.run();
        }
        finally {
            this.executionMillis.getAndAdd((System.nanoTime() - nanos) / 1000000L);
        }
    }

    public Runnable getTask() {
        return this.task;
    }

    public long getExecutionTimeMillis() {
        return this.executionMillis.get();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskWrapper)) {
            return false;
        }
        return Objects.equals(this.task, ((TaskWrapper)obj).task);
    }

    public int hashCode() {
        return Objects.hashCode(this.task);
    }
}

