/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.profiles.impl;

import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ogema.core.administration.FrameworkClock;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.IntegerValue;
import org.ogema.core.channelmanager.measurements.LongValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ValueResource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.model.prototypes.PhysicalElement;
import org.ogema.model.sensors.Sensor;
import org.ogema.tools.resource.util.ResourceUtils;
import org.ogema.tools.resource.util.ValueResourceUtils;
import org.ogema.tools.timeseries.api.MemoryTimeSeries;
import org.ogema.tools.timeseries.implementations.TreeTimeSeries;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartrplace.tools.profiles.DataPoint;
import org.smartrplace.tools.profiles.Profile;
import org.smartrplace.tools.profiles.ProfileGeneration;
import org.smartrplace.tools.profiles.ProfileTemplate;
import org.smartrplace.tools.profiles.State;
import org.smartrplace.tools.profiles.impl.ProfileGeneratorConfiguration;
import org.smartrplace.tools.profiles.impl.SerializationUtils;
import org.smartrplace.tools.profiles.utils.ProfileImpl;
import org.smartrplace.tools.profiles.utils.StandardDataPoints;

@Component(service={ProfileGeneration.class}, configurationPid={"org.smartrplace.tools.profiles.Generator"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@Designate(ocd=ProfileGeneratorConfiguration.class)
public class ProfileGenerationImpl
implements ProfileGeneration {
    private static final String SEPARATOR = "_X_";
    private final ConcurrentMap<String, ComponentServiceObjects<ProfileTemplate>> templates = new ConcurrentHashMap<String, ComponentServiceObjects<ProfileTemplate>>(8);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Path profilesFolder;
    @Reference(service=FrameworkClock.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ComponentServiceObjects<FrameworkClock> clock;

    @Activate
    protected void activate(BundleContext ctx, ProfileGeneratorConfiguration config) throws IOException {
        Path p;
        String configPath = config == null ? "" : config.storagePath();
        try {
            p = !configPath.isEmpty() ? Paths.get(configPath, new String[0]) : ctx.getDataFile("profiles").toPath();
        }
        catch (InvalidPathException e) {
            throw new ComponentException("Invalid storage path configured: " + configPath);
        }
        Files.createDirectories(p, new FileAttribute[0]);
        this.profilesFolder = p;
        LoggerFactory.getLogger(this.getClass()).info("ProfileGenerationImpl starting; storing files in directory {}", (Object)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=ProfileTemplate.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="addTemplate", unbind="removeTemplate")
    protected void addTemplate(ComponentServiceObjects<ProfileTemplate> templateRef) {
        String id = ProfileGenerationImpl.getId(templateRef);
        if (id == null) {
            throw new ComponentException("Profile template without id: " + templateRef);
        }
        ComponentServiceObjects<ProfileTemplate> old = this.templates.put(id, templateRef);
        if (old != null) {
            ProfileTemplate oldTemplate = (ProfileTemplate)old.getService();
            ProfileTemplate newTemplate = (ProfileTemplate)templateRef.getService();
            try {
                LoggerFactory.getLogger(this.getClass()).warn("Duplicate profile template id {}: {}, {}", new Object[]{id, oldTemplate, newTemplate});
            }
            finally {
                templateRef.ungetService((Object)newTemplate);
                old.ungetService((Object)oldTemplate);
            }
        }
    }

    protected void removeTemplate(ComponentServiceObjects<ProfileTemplate> templateRef) {
        String id = ProfileGenerationImpl.getId(templateRef);
        if (id == null) {
            return;
        }
        this.templates.remove(id, templateRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getId(ComponentServiceObjects<ProfileTemplate> service) {
        String id;
        Object id0 = service.getServiceReference().getProperty("template_id");
        String string = id = id0 != null ? id0.toString() : null;
        if (id == null) {
            ProfileTemplate template = (ProfileTemplate)service.getService();
            try {
                id = template.id();
            }
            finally {
                service.ungetService((Object)template);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Profile run(ProfileTemplate template, Consumer<State> switchFunction, NavigableMap<Long, State> stateDurations, Map<DataPoint, Object> data0, State endState) throws InterruptedException {
        Map<DataPoint, Object> data;
        if ((Long)stateDurations.firstKey() <= 0L) {
            throw new IllegalArgumentException("State end times contain a non-positive value: " + stateDurations.firstKey());
        }
        Objects.requireNonNull(switchFunction, "Switch function is null");
        if (data0.entrySet().stream().filter(entry -> entry.getValue() == null || entry.getKey() == null).findAny().isPresent()) {
            throw new NullPointerException("Null data passed");
        }
        Optional<DataPoint> startTime = template.contextData().stream().filter(StandardDataPoints::isStartTime).findAny();
        boolean hasStartTime = startTime.isPresent();
        if (hasStartTime && !data0.keySet().stream().filter(StandardDataPoints::isStartTime).findAny().isPresent()) {
            data = new LinkedHashMap<DataPoint, Object>(data0);
            data.put(startTime.get(), this.time());
        } else {
            data = data0;
        }
        if (stateDurations.entrySet().stream().filter(entry -> entry.getValue() == null || entry.getKey() == null).findAny().isPresent()) {
            throw new NullPointerException("Null data passed");
        }
        Optional<DataPoint> missing = template.primaryData().stream().filter(dp -> !dp.optional()).filter(dp -> !data0.containsKey(dp)).findAny();
        if (!missing.isPresent()) {
            missing = template.contextData().stream().filter(dp -> !dp.optional()).filter(dp -> !data.containsKey(dp)).findAny();
        }
        if (missing.isPresent()) {
            throw new IllegalArgumentException("Missing data for " + missing.get().label(OgemaLocale.ENGLISH));
        }
        String profileId = this.getProfileId(template.id());
        this.logger.info("Starting profile recording for template {}, id {}", (Object)template.id(), (Object)profileId);
        long start = this.time();
        float factor = this.factor();
        LinkedHashMap<DataPoint, Object> copy = new LinkedHashMap<DataPoint, Object>(data);
        this.logger.debug("Supported data points {}", copy.keySet());
        HashMap listeners = new HashMap(copy.size());
        long lastStart = 0L;
        try {
            for (Map.Entry entry2 : copy.entrySet()) {
                Object value = entry2.getValue();
                if (value instanceof Sensor) {
                    value = ((Sensor)value).reading();
                }
                if (!(value instanceof SingleValueResource) || ((DataPoint)entry2.getKey()).dataType() != DataPoint.DataType.TIME_SERIES) continue;
                ValueListener valueListener = new ValueListener(start, (SingleValueResource)value);
                ((SingleValueResource)value).addValueListener((ResourceValueListener)valueListener, true);
                listeners.put(entry2.getKey(), valueListener);
            }
            for (Map.Entry entry2 : stateDurations.entrySet()) {
                switchFunction.accept((State)entry2.getValue());
                this.logger.debug("State switched to {}", entry2.getValue());
                Thread.sleep(Math.max(1L, (long)((float)((Long)entry2.getKey() - lastStart) / factor)));
                lastStart = (Long)entry2.getKey();
            }
            long end = this.time() - start;
            for (Map.Entry entry3 : copy.entrySet()) {
                if (((DataPoint)entry3.getKey()).dataType() != DataPoint.DataType.TIME_SERIES) continue;
                Object value = entry3.getValue();
                if (value instanceof Sensor) {
                    value = ((Sensor)value).reading();
                }
                if (!(value instanceof SingleValueResource)) continue;
                ((ValueListener)listeners.get(entry3.getKey())).resourceChanged(end, (SingleValueResource)value);
            }
            LinkedHashMap<DataPoint, Object> resultsPrimary = new LinkedHashMap<DataPoint, Object>();
            LinkedHashMap<DataPoint, Object> linkedHashMap = new LinkedHashMap<DataPoint, Object>();
            for (Map.Entry entry4 : copy.entrySet()) {
                Object result;
                DataPoint dp2 = (DataPoint)entry4.getKey();
                switch (dp2.dataType()) {
                    case TIME_SERIES: {
                        ValueListener listener3 = (ValueListener)listeners.get(dp2);
                        if (listener3 == null) {
                            throw new IllegalStateException("Listener not found for data point " + dp2);
                        }
                        List<SampledValue> values = listener3.getValues();
                        if (values.isEmpty()) {
                            result = MemoryTimeSeries.EMPTY_TIME_SERIES;
                            break;
                        }
                        result = new TreeTimeSeries(values.iterator().next().getValue().getClass());
                        ((TreeTimeSeries)result).addValues(values);
                        break;
                    }
                    case STRING: {
                        Object value = entry4.getValue();
                        result = value instanceof PhysicalElement ? ResourceUtils.getHumanReadableName((Resource)((PhysicalElement)value)) : (value instanceof StringResource ? ((StringResource)value).getValue() : value.toString());
                        break;
                    }
                    case SINGLE_VALUE: {
                        Object value3 = entry4.getValue();
                        if (value3 instanceof Sensor) {
                            value3 = ((Sensor)value3).reading();
                        }
                        Object object = value3 instanceof Number ? (Number)value3 : (result = value3 instanceof SingleValueResource ? (Number)ValueResourceUtils.getValue((ValueResource)((ValueResource)value3)) : null);
                        if (result != null) break;
                        throw new IllegalArgumentException("Cannot convert " + value3 + " to a number");
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (template.primaryData().contains(dp2)) {
                    resultsPrimary.put(dp2, result);
                    continue;
                }
                linkedHashMap.put(dp2, result);
            }
            if (endState != null && switchFunction != null) {
                switchFunction.accept(endState);
            }
            this.logger.info("Profile generation completed: {}, primary result keys: {}", (Object)profileId, resultsPrimary.keySet());
            ProfileImpl profileImpl = new ProfileImpl(profileId, resultsPrimary, linkedHashMap, template.derivedData(resultsPrimary, linkedHashMap), stateDurations, template);
            return profileImpl;
        }
        finally {
            listeners.forEach((dp, listener) -> {
                try {
                    ((SingleValueResource)copy.get(dp)).removeValueListener((ResourceValueListener)listener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private final String getProfileId(String templateId) {
        return templateId + SEPARATOR + this.time();
    }

    private final String getTemplateId(String profileId) {
        int sepIdx = profileId.lastIndexOf(SEPARATOR);
        if (sepIdx < 0) {
            return null;
        }
        return profileId.substring(0, sepIdx);
    }

    private static String getProfileIdFromFilename(String filename) {
        int idx = filename.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return filename.substring(0, idx);
    }

    @Override
    public void store(Profile profile, OutputStream out) throws IOException {
        if (!(profile instanceof ProfileImpl)) {
            throw new UnsupportedOperationException("Serialization not implemented for class " + profile.getClass());
        }
        SerializationUtils.write(out, (ProfileImpl)profile);
    }

    @Override
    public void store(Profile profile, Writer out) throws IOException {
        if (!(profile instanceof ProfileImpl)) {
            throw new UnsupportedOperationException("Serialization not implemented for class " + profile.getClass());
        }
        SerializationUtils.write(out, (ProfileImpl)profile);
    }

    @Override
    public Profile read(InputStream in) throws IOException {
        return SerializationUtils.read(in, this.templates);
    }

    @Override
    public Profile read(Reader in) throws IOException {
        return SerializationUtils.read(in, this.templates);
    }

    @Override
    public void storeProfile(Profile profile) throws IOException {
        Path file = this.profilesFolder.resolve(profile.id() + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.store(profile, writer);
        }
        this.logger.info("Profile stored: {}", (Object)file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getStoredProfileIds(String templateId) throws IOException {
        ProfileGenerationImpl profileGenerationImpl = this;
        synchronized (profileGenerationImpl) {
            try (Stream<Path> files = Files.list(this.profilesFolder);){
                Stream<String> stream = files.map(p -> ProfileGenerationImpl.getProfileIdFromFilename(p.getFileName().toString())).filter(Objects::nonNull);
                if (templateId != null) {
                    stream = stream.filter(p -> templateId.equals(this.getTemplateId((String)p)));
                }
                Collection collection = stream.collect(Collectors.toList());
                return collection;
            }
        }
    }

    @Override
    public Profile getStoredProfile(String profileId) throws IOException {
        Objects.requireNonNull(profileId);
        Path file = this.profilesFolder.resolve(profileId + ".json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            Profile profile = this.read(reader);
            return profile;
        }
    }

    @Override
    public boolean removeStoredProfile(String profileId) throws IOException {
        Objects.requireNonNull(profileId);
        Path file = this.profilesFolder.resolve(profileId + ".json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        Files.delete(file);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long time() {
        ComponentServiceObjects<FrameworkClock> service = this.clock;
        if (service == null) {
            return System.currentTimeMillis();
        }
        FrameworkClock clock = null;
        try {
            clock = (FrameworkClock)service.getService();
            long l = clock.getExecutionTime();
            return l;
        }
        catch (IllegalArgumentException e) {
            long l = System.currentTimeMillis();
            return l;
        }
        finally {
            if (clock != null) {
                service.ungetService((Object)clock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final float factor() {
        ComponentServiceObjects<FrameworkClock> service = this.clock;
        if (service == null) {
            return 1.0f;
        }
        FrameworkClock clock = null;
        try {
            clock = (FrameworkClock)service.getService();
            float f = clock.getSimulationFactor();
            return f;
        }
        catch (IllegalArgumentException e) {
            float f = 1.0f;
            return f;
        }
        finally {
            if (clock != null) {
                service.ungetService((Object)clock);
            }
        }
    }

    private class ValueListener
    implements ResourceValueListener<SingleValueResource> {
        private final long startTime;
        private final List<SampledValue> values = new ArrayList<SampledValue>();

        public ValueListener(long startTime, SingleValueResource resource) {
            this.startTime = startTime;
            this.resourceChanged(0L, resource);
        }

        public void resourceChanged(SingleValueResource resource) {
            long t = ProfileGenerationImpl.this.time() - this.startTime;
            this.resourceChanged(t, resource);
        }

        final void resourceChanged(long t, SingleValueResource resource) {
            FloatValue v;
            if (resource instanceof FloatResource) {
                v = new FloatValue(((FloatResource)resource).getValue());
            } else if (resource instanceof IntegerResource) {
                v = new IntegerValue(((IntegerResource)resource).getValue());
            } else if (resource instanceof BooleanResource) {
                v = new BooleanValue(((BooleanResource)resource).getValue());
            } else if (resource instanceof TimeResource) {
                v = new LongValue(((TimeResource)resource).getValue());
            } else {
                throw new IllegalArgumentException();
            }
            this.values.add(new SampledValue((Value)v, t, Quality.GOOD));
        }

        public List<SampledValue> getValues() {
            return this.values;
        }
    }
}

