/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.profiles.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.Quality;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.timeseries.ReadOnlyTimeSeries;
import org.ogema.tools.timeseries.implementations.FloatTreeTimeSeries;
import org.osgi.service.component.ComponentServiceObjects;
import org.smartrplace.tools.profiles.DataPoint;
import org.smartrplace.tools.profiles.ProfileTemplate;
import org.smartrplace.tools.profiles.State;
import org.smartrplace.tools.profiles.impl.ProfileDTO;
import org.smartrplace.tools.profiles.impl.TimeseriesDTO;
import org.smartrplace.tools.profiles.utils.ProfileImpl;

public class SerializationUtils {
    private static final ObjectMapper mapper = new ObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.PUBLIC_ONLY).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final ObjectReader reader = mapper.readerFor(ProfileDTO.class);
    private static final ObjectWriter writer = mapper.writerFor(ProfileDTO.class).withDefaultPrettyPrinter();

    public static void write(OutputStream out, ProfileImpl profile) throws JsonGenerationException, JsonMappingException, IOException {
        ProfileDTO dto = SerializationUtils.serialize(profile);
        writer.writeValue(out, (Object)dto);
    }

    public static void write(Writer out, ProfileImpl profile) throws JsonGenerationException, JsonMappingException, IOException {
        ProfileDTO dto = SerializationUtils.serialize(profile);
        writer.writeValue(out, (Object)dto);
    }

    public static ProfileImpl read(InputStream in, ConcurrentMap<String, ComponentServiceObjects<ProfileTemplate>> templates) throws JsonProcessingException, IOException {
        ProfileDTO dto = (ProfileDTO)reader.readValue(in);
        return SerializationUtils.deserialize(dto, templates);
    }

    public static ProfileImpl read(Reader in, ConcurrentMap<String, ComponentServiceObjects<ProfileTemplate>> templates) throws JsonProcessingException, IOException {
        ProfileDTO dto = (ProfileDTO)reader.readValue(in);
        return SerializationUtils.deserialize(dto, templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileImpl deserialize(ProfileDTO dto, ConcurrentMap<String, ComponentServiceObjects<ProfileTemplate>> templates) {
        String templateId = dto.templateId;
        if (templateId == null) {
            throw new NullPointerException("No template id provided");
        }
        ComponentServiceObjects service = (ComponentServiceObjects)templates.get(templateId);
        if (service == null) {
            throw new IllegalStateException("Template provider for id " + templateId + " not available");
        }
        ProfileTemplate template = (ProfileTemplate)service.getService();
        try {
            ProfileImpl profile;
            List<DataPoint> primary = template.primaryData();
            List<DataPoint> context = template.contextData();
            List<DataPoint> derived = template.derivedData();
            LinkedHashMap<DataPoint, Object> primaryResults = new LinkedHashMap<DataPoint, Object>();
            LinkedHashMap<DataPoint, Object> contextResults = new LinkedHashMap<DataPoint, Object>();
            LinkedHashMap<DataPoint, Object> derivedResults = new LinkedHashMap<DataPoint, Object>();
            List<State> states = template.states();
            Map<Long, State> endTimes = dto.stateEndTimes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> states.stream().filter(state -> ((String)entry.getValue()).equals(state.id())).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown state " + (String)entry.getValue()))));
            SerializationUtils.addPoints(primary, dto, primaryResults);
            SerializationUtils.addPoints(context, dto, contextResults);
            SerializationUtils.addPoints(derived, dto, derivedResults);
            ProfileImpl profileImpl = profile = new ProfileImpl(dto.id, primaryResults, contextResults, derivedResults, endTimes, template);
            return profileImpl;
        }
        finally {
            service.ungetService((Object)template);
        }
    }

    private static void addPoints(List<DataPoint> points, ProfileDTO dto, Map<DataPoint, Object> results) {
        if (points == null) {
            return;
        }
        for (DataPoint dp : points) {
            String key = dp.id();
            Object value = SerializationUtils.getValue(key, dto);
            if (value == null) continue;
            results.put(dp, value);
        }
    }

    private static Object getValue(String key, ProfileDTO dto) {
        if (key == null) {
            return null;
        }
        if (dto.stringValues != null && dto.stringValues.containsKey(key)) {
            return dto.stringValues.get(key);
        }
        if (dto.numericalValues != null && dto.numericalValues.containsKey(key)) {
            return dto.numericalValues.get(key);
        }
        if (dto.timeseriesValues != null && dto.timeseriesValues.containsKey(key)) {
            TimeseriesDTO tsDto = dto.timeseriesValues.get(key);
            return SerializationUtils.deserialize(tsDto);
        }
        return null;
    }

    public static ProfileDTO serialize(ProfileImpl profile) {
        ProfileDTO dto = new ProfileDTO();
        dto.id = profile.id();
        dto.templateId = profile.templateId();
        try {
            Field primaryField = ProfileImpl.class.getDeclaredField("primary");
            primaryField.setAccessible(true);
            Map primary = (Map)primaryField.get(profile);
            Field contextField = ProfileImpl.class.getDeclaredField("context");
            contextField.setAccessible(true);
            Map context = (Map)contextField.get(profile);
            Field derivedField = ProfileImpl.class.getDeclaredField("derived");
            derivedField.setAccessible(true);
            Map derived = (Map)derivedField.get(profile);
            SerializationUtils.addValues(dto, context);
            SerializationUtils.addValues(dto, primary);
            SerializationUtils.addValues(dto, derived);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        dto.stateEndTimes = profile.stateEndTimes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((State)entry.getValue()).id()));
        return dto;
    }

    private static TimeseriesDTO serialize(ReadOnlyTimeSeries ts) {
        TimeseriesDTO dto = new TimeseriesDTO();
        int size = Math.max(4, ts.size());
        dto.timestamps = new ArrayList<Long>(size);
        dto.values = new ArrayList<Float>(size);
        for (SampledValue sv : ts) {
            if (sv.getQuality() == Quality.BAD) continue;
            dto.timestamps.add(sv.getTimestamp());
            dto.values.add(Float.valueOf(sv.getValue().getFloatValue()));
        }
        return dto;
    }

    private static ReadOnlyTimeSeries deserialize(TimeseriesDTO dto) {
        FloatTreeTimeSeries ts = new FloatTreeTimeSeries();
        if (dto.values == null || dto.timestamps == null) {
            throw new NullPointerException("Timestamps or values are null");
        }
        if (dto.values.size() != dto.timestamps.size()) {
            throw new IllegalStateException("Nr of timestamps does not equal nr of values");
        }
        Iterator<Long> tIt = dto.timestamps.iterator();
        Iterator<Float> vIt = dto.values.iterator();
        ArrayList<SampledValue> values = new ArrayList<SampledValue>(dto.timestamps.size());
        while (tIt.hasNext()) {
            values.add(new SampledValue((Value)new FloatValue(vIt.next().floatValue()), tIt.next().longValue(), Quality.GOOD));
        }
        ts.addValues(values);
        return ts;
    }

    private static void addValues(ProfileDTO dto, Map<DataPoint, Object> values) {
        for (Map.Entry<DataPoint, Object> entry : values.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String) {
                if (dto.stringValues == null) {
                    dto.stringValues = new HashMap<String, String>(4);
                }
                dto.stringValues.put(entry.getKey().id(), (String)v);
                continue;
            }
            if (v instanceof Number) {
                if (dto.numericalValues == null) {
                    dto.numericalValues = new HashMap<String, Number>(4);
                }
                dto.numericalValues.put(entry.getKey().id(), (Number)v);
                continue;
            }
            if (!(v instanceof ReadOnlyTimeSeries)) continue;
            if (dto.timeseriesValues == null) {
                dto.timeseriesValues = new HashMap<String, TimeseriesDTO>(8);
            }
            dto.timeseriesValues.put(entry.getKey().id(), SerializationUtils.serialize((ReadOnlyTimeSeries)v));
        }
    }
}

