/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.profiles.utils;

import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.smartrplace.tools.profiles.DataPoint;
import org.smartrplace.tools.profiles.Profile;
import org.smartrplace.tools.profiles.ProfileTemplate;
import org.smartrplace.tools.profiles.State;

public class ProfileImpl
implements Profile {
    private final String id;
    private final String templateId;
    private final ProfileTemplate template;
    private final Map<DataPoint, Object> primary;
    private final Map<DataPoint, Object> context;
    private final Map<DataPoint, Object> derived;
    private final Map<Long, State> stateEndTimes;

    public ProfileImpl(String id, Map<DataPoint, Object> primary, Map<DataPoint, Object> context, Map<DataPoint, Object> derived, Map<Long, State> stateEndTimes, ProfileTemplate template) {
        this.id = Objects.requireNonNull(id);
        this.primary = Collections.unmodifiableMap(primary);
        this.context = context == null ? Collections.emptyMap() : Collections.unmodifiableMap(context);
        this.derived = derived == null ? Collections.emptyMap() : Collections.unmodifiableMap(derived);
        this.template = Objects.requireNonNull(template);
        this.stateEndTimes = Collections.unmodifiableMap(stateEndTimes);
        this.templateId = template.id();
    }

    @Override
    public Object getPrimaryData(DataPoint dp) {
        return this.primary.get(dp);
    }

    @Override
    public Object getContextData(DataPoint dp) {
        return this.context.get(dp);
    }

    @Override
    public Object getDerivedData(DataPoint dp) {
        return this.derived.get(dp);
    }

    @Override
    public Map<DataPoint, Object> getDerivedData() {
        return this.derived;
    }

    @Override
    public Map<DataPoint, Object> getPrimaryData() {
        return this.primary;
    }

    @Override
    public Map<DataPoint, Object> getContextData() {
        return this.context;
    }

    public String id() {
        return this.id;
    }

    public String label(OgemaLocale locale) {
        return this.template.label(locale);
    }

    public String description(OgemaLocale locale) {
        return this.template.description(locale);
    }

    @Override
    public String templateId() {
        return this.templateId;
    }

    @Override
    public Map<Long, State> stateEndTimes() {
        return this.stateEndTimes;
    }

    public String toString() {
        return "ProfileImpl[" + this.id() + "]";
    }
}

