/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tools.ssl.impl;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.LoggerFactory;
import org.smartrplace.tools.ssl.KeyStoreNotAvailableException;
import org.smartrplace.tools.ssl.SslService;
import org.smartrplace.tools.ssl.impl.SslConfig;

@Component(service={SslService.class}, configurationPid={"org.smartrplace.tools.SslService"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.factoryPid=org.smartrplace.tools.SslService"})
@Designate(ocd=SslConfig.class)
public class SslServiceImpl
implements SslService {
    private volatile SslConfig config;
    private volatile KeyStore keyStore;
    private volatile KeyStore trustStore;

    @Activate
    protected void activate(SslConfig config) {
        this.config = config;
        try {
            this.keyStore = SslServiceImpl.loadKeystore(config.keystorePath(), config.keystoreType(), config.provider());
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            LoggerFactory.getLogger(SslService.class).error("Failed to load keystore at {}", (Object)config.keystorePath(), (Object)e);
        }
        try {
            this.trustStore = SslServiceImpl.loadKeystore(config.truststorePath(), config.keystoreType(), config.provider());
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            LoggerFactory.getLogger(SslService.class).error("Failed to load truststore at {}", (Object)config.truststorePath(), (Object)e);
        }
    }

    @Override
    public SSLContext getUnsafeTrustAllContext(boolean initKeystore) throws KeyStoreNotAvailableException {
        return this.getContext(initKeystore, false, true);
    }

    @Override
    public SSLContext getContext(boolean initKeystore, boolean initTruststore) throws KeyStoreNotAvailableException {
        return this.getContext(initKeystore, initTruststore, false);
    }

    private SSLContext getContext(boolean initKeystore, boolean initTruststore, boolean trustAll) throws KeyStoreNotAvailableException {
        SslConfig config = this.config;
        try {
            TrustManager[] trustManagers;
            KeyManager[] keyManagers;
            String algo;
            SSLContext context;
            SSLContext sSLContext = context = config.provider().isEmpty() ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", config.provider());
            if (initKeystore) {
                algo = !config.algorithm().isEmpty() ? config.algorithm() : KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmFactory = config.provider().isEmpty() ? KeyManagerFactory.getInstance(algo) : KeyManagerFactory.getInstance(algo, config.provider());
                kmFactory.init(this.keyStore, config.keystorePassword().toCharArray());
                keyManagers = kmFactory.getKeyManagers();
            } else {
                keyManagers = null;
            }
            if (initTruststore) {
                algo = !config.algorithm().isEmpty() ? config.algorithm() : TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmFactory = config.provider().isEmpty() ? TrustManagerFactory.getInstance(algo) : TrustManagerFactory.getInstance(algo, config.provider());
                tmFactory.init(this.trustStore);
                trustManagers = tmFactory.getTrustManagers();
            } else {
                trustManagers = trustAll ? new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                }} : null;
            }
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new KeyStoreNotAvailableException("Failed to load keystore", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Service is inactive", e);
        }
    }

    private static KeyStore loadKeystore(String path, String keystoreType, String provider) throws KeyStoreException, NoSuchProviderException {
        Path pth;
        try {
            pth = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            LoggerFactory.getLogger(SslService.class).error("Invalid keystore path {}", (Object)path);
            return null;
        }
        if (!Files.isRegularFile(pth, new LinkOption[0])) {
            return null;
        }
        if (keystoreType == null || keystoreType.isEmpty()) {
            keystoreType = KeyStore.getDefaultType();
        }
        if (provider == null || provider.isEmpty()) {
            return KeyStore.getInstance(keystoreType);
        }
        return KeyStore.getInstance(path, provider);
    }
}

