/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.smyld.app.entityplot.EntityPlotter;
import org.smyld.app.entityplot.TextPlotter;

public class EntityConnector {
    protected EntityPlotter from;
    protected EntityPlotter to;
    protected Point fromPoint;
    protected Point toPoint;
    protected int frmPos = 6;
    protected int toPos = 5;
    protected TextPlotter comment;
    protected Point dragPoint;
    protected Rectangle midRect = new Rectangle(0, 0, 4, 4);
    protected String id;
    protected int conPointSize;
    protected int borderWidth = 2;
    protected int commentDistance = 10;
    protected int mx;
    protected int my;
    protected Point hittedPoint;
    protected boolean inDrag;
    protected boolean fromDisconnected;
    protected boolean deactivated;
    protected boolean showArrow = true;
    protected Color conColor = new Color(83, 105, 174);
    protected ConnectionCategory category = ConnectionCategory.Organic;
    protected ConnectionType type = ConnectionType.OneToOne;

    public EntityConnector(EntityPlotter from, EntityPlotter to, int conSize, Color conColor) {
        this(from, to, conSize);
        this.conColor = conColor;
        this.init();
    }

    public EntityConnector(EntityPlotter from, EntityPlotter to, int conSize, Color conColor, String commentText) {
        this(from, to, conSize);
        this.conColor = conColor;
        this.addComment(commentText);
        this.init();
    }

    public EntityConnector(EntityPlotter from, EntityPlotter to, int conSize) {
        this.from = from;
        this.to = to;
        this.conPointSize = conSize;
        this.id = from.getId() + to.getId();
        this.init();
    }

    private void init() {
    }

    protected void addComment(String commentText) {
        if (commentText != null && !commentText.isEmpty()) {
            this.comment = new TextPlotter(commentText);
            this.comment.setAutoExpand(true);
            this.comment.setHorizontalAlignment(1);
            this.comment.setVerticalAlignment(11);
        }
    }

    protected void detectEntityConnectionPoints() {
        Rectangle2D frmRect = this.from.getBounds();
        Rectangle2D toRect = this.to.getBounds();
        this.frmPos = 6;
        this.toPos = 5;
        if (this.onTop(frmRect, toRect)) {
            this.frmPos = 7;
            this.toPos = 1;
        } else if (this.onBut(frmRect, toRect)) {
            this.frmPos = 1;
            this.toPos = 7;
        } else if (this.onRight(frmRect, toRect)) {
            this.frmPos = 5;
            this.toPos = 6;
        }
        Point fromP = this.from.getConnectionPoint(this.frmPos, true);
        Point toP = this.to.getConnectionPoint(this.toPos, true);
        this.setConnectorPoints(fromP, toP);
    }

    public void drawLine(Graphics2D g) {
        Object ocomp = null;
        Color prevCol = g.getColor();
        g.setColor(this.getColor());
        g.setStroke(new BasicStroke(this.borderWidth, 1, 1));
        this.detectEntityConnectionPoints();
        this.mx = (this.fromPoint.x - this.toPoint.x) / 2;
        this.my = (this.fromPoint.y - this.toPoint.y) / 2;
        if (this.isInDrag()) {
            if (this.fromDisconnected) {
                this.drawConnector(g, this.getDragPoint(), this.toPoint);
            } else {
                this.drawConnector(g, this.fromPoint, this.getDragPoint());
            }
        } else {
            this.drawConnector(g, this.fromPoint, this.toPoint);
            this.drawMidRect(g);
        }
        if (this.comment != null) {
            int connectX = this.fromPoint.x;
            int connectY = this.fromPoint.y;
            this.comment.calibrate(g);
            switch (this.frmPos) {
                case 6: {
                    this.comment.setX(this.fromPoint.x + this.commentDistance);
                    connectX += this.commentDistance / 2;
                    this.comment.setY(this.fromPoint.y - this.comment.getHeight() - this.commentDistance);
                    break;
                }
                case 5: {
                    this.comment.setX(this.fromPoint.x - this.comment.getWidth() - this.commentDistance);
                    connectX -= this.commentDistance / 2;
                    this.comment.setY(this.fromPoint.y - this.comment.getHeight() - this.commentDistance);
                    break;
                }
                case 1: {
                    this.comment.setX(this.fromPoint.x + this.commentDistance);
                    connectY -= this.commentDistance / 2;
                    this.comment.setY(this.fromPoint.y - this.comment.getHeight() - this.commentDistance);
                    break;
                }
                case 7: {
                    this.comment.setX(this.fromPoint.x + this.commentDistance);
                    connectY += this.commentDistance / 2;
                    this.comment.setY(this.fromPoint.y + this.commentDistance);
                }
            }
            this.comment.paintContents(g, connectX, connectY);
        }
        g.setColor(prevCol);
    }

    protected void drawMidRect(Graphics2D g) {
        this.midRect.setLocation(this.fromPoint.x - this.mx - 2, this.fromPoint.y - this.my - 2);
        g.fillRoundRect(this.midRect.x, this.midRect.y, this.midRect.width, this.midRect.height, 4, 4);
    }

    protected void drawConnector(Graphics2D g, Point from, Point to) {
        Shape connector = null;
        switch (this.category) {
            case Orthogonal: {
                if (this.type == ConnectionType.OneToOne) {
                    connector = this.drawOrthogonalLine(g, from.x, from.y, to.x, to.y);
                    break;
                }
                connector = this.drawManyOrthogonalLine(g, from.x, from.y, to.x, to.y);
                break;
            }
            default: {
                connector = this.drawOrganicLine(g, from.x, from.y, to.x, to.y);
            }
        }
        g.draw(connector);
    }

    protected Shape drawOrthogonalLine(Graphics2D g, float p1x, float p1y, float p2x, float p2y) {
        int arr = this.conPointSize;
        GeneralPath path = new GeneralPath(1);
        path.moveTo(p1x, p1y);
        int ysign = p1y > p2y ? 1 : -1;
        int xsign = p1x > p2x ? 1 : -1;
        switch (this.frmPos) {
            case 5: 
            case 6: {
                if (this.showArrow) {
                    int arrSign = this.frmPos == 5 ? 1 : -1;
                    path.lineTo(p2x + (float)(arrSign * arr), p2y);
                    this.drawArrow(g, p2x + (float)(arrSign * arr), p2y, p2x, p2y, 0.0, ysign, xsign);
                    break;
                }
                path.lineTo(p2x, p2y);
                break;
            }
            case 1: 
            case 7: {
                if (p1x != p2x) {
                    float midY = (p2y - p1y) / 2.0f;
                    path.lineTo(p1x, p1y + midY);
                    path.lineTo(p2x, p1y + midY);
                }
                if (this.showArrow) {
                    int arrSign = this.frmPos == 7 ? 1 : -1;
                    path.lineTo(p2x, p2y + (float)(arrSign * arr));
                    this.drawArrow(g, p2x, p2y + (float)(arrSign * arr), p2x, p2y, 0.0, ysign, xsign);
                    break;
                }
                path.lineTo(p2x, p2y);
            }
        }
        return path;
    }

    protected Shape drawManyOrthogonalLine(Graphics2D g, float p1x, float p1y, float p2x, float p2y) {
        int arr = this.conPointSize;
        GeneralPath path = new GeneralPath(1);
        path.moveTo(p1x, p1y);
        int ysign = p1y > p2y ? 1 : -1;
        int xsign = p1x > p2x ? 1 : -1;
        switch (this.frmPos) {
            case 5: 
            case 6: {
                if (p1y != p2y) {
                    float midX = (p2x - p1x) / 2.0f;
                    path.lineTo(p1x + midX, p1y);
                    path.lineTo(p1x + midX, p2y);
                }
                if (this.showArrow) {
                    int arrSign = this.frmPos == 5 ? 1 : -1;
                    path.lineTo(p2x + (float)(arrSign * arr), p2y);
                    this.drawArrow(g, p2x + (float)(arrSign * arr), p2y, p2x, p2y, 0.0, ysign, xsign);
                    break;
                }
                path.lineTo(p2x, p2y);
                break;
            }
            case 1: 
            case 7: {
                if (p1x != p2x) {
                    float midY = (p2y - p1y) / 2.0f;
                    path.lineTo(p1x, p1y + midY);
                    path.lineTo(p2x, p1y + midY);
                }
                if (this.showArrow) {
                    int arrSign = this.frmPos == 7 ? 1 : -1;
                    path.lineTo(p2x, p2y + (float)(arrSign * arr));
                    this.drawArrow(g, p2x, p2y + (float)(arrSign * arr), p2x, p2y, 0.0, ysign, xsign);
                    break;
                }
                path.lineTo(p2x, p2y);
            }
        }
        return path;
    }

    protected Shape drawOrganicLine(Graphics2D g, float p1x, float p1y, float p2x, float p2y) {
        int xsign;
        int arr = this.conPointSize;
        GeneralPath path = new GeneralPath();
        path.moveTo(p1x, p1y);
        int ysign = p1y > p2y ? 1 : -1;
        int n = xsign = p1x > p2x ? 1 : -1;
        if (this.showArrow) {
            if (p1x == p2x) {
                int sign = p2y < p1y ? 1 : -1;
                path.lineTo(p2x, p2y + (float)(sign * arr));
                this.drawArrow(g, p2x, p2y + (float)(sign * arr), p2x, p2y, 0.0, ysign, xsign);
            } else if (p1y == p2y) {
                int sign = p2x < p1x ? 1 : -1;
                path.lineTo(p2x + (float)(sign * arr), p2y);
                this.drawArrow(g, p2x + (float)(sign * arr), p2y, p2x, p2y, 0.0, ysign, xsign);
            } else {
                double dy = Math.abs(p2y - p1y);
                double dx = Math.abs(p1x - p2x);
                double lineAngle = Math.atan(dy / dx);
                double arBasePointX = (double)arr * Math.cos(lineAngle);
                double arBasePointY = (double)arr * Math.sin(lineAngle);
                double arrStartX = (double)p2x + (double)xsign * arBasePointX;
                double arrStartY = (double)p2y + (double)ysign * arBasePointY;
                path.lineTo(arrStartX, arrStartY);
                this.drawArrow(g, arrStartX, arrStartY, p2x, p2y, lineAngle, ysign, xsign);
            }
        } else {
            path.lineTo(p2x, p2y);
        }
        return path;
    }

    protected void drawArrow(Graphics2D g, double p1x, double p1y, double p2x, double p2y, double lineAngle, int ysign, int xsign) {
        GeneralPath path = new GeneralPath();
        int arr = this.conPointSize;
        path.moveTo(p1x, p1y);
        if (p1x == p2x) {
            path.lineTo(p2x, p2y + (double)(ysign * arr));
            path.lineTo(p2x + (double)(arr / 2), p2y + (double)(ysign * arr));
            path.lineTo(p2x, p2y);
            path.lineTo(p2x - (double)(arr / 2), p2y + (double)(ysign * arr));
            path.lineTo(p2x, p2y + (double)(ysign * arr));
        } else if (p1y == p2y) {
            path.lineTo(p2x + (double)(xsign * arr), p2y);
            path.lineTo(p2x + (double)(xsign * arr), p2y + (double)(arr / 2));
            path.lineTo(p2x, p2y);
            path.lineTo(p2x + (double)(xsign * arr), p2y - (double)(arr / 2));
            path.lineTo(p2x + (double)(xsign * arr), p2y);
        } else {
            double arTopPointX = (double)(arr / 2) * Math.sin(lineAngle);
            double arTopPointY = (double)(arr / 2) * Math.cos(lineAngle);
            path.lineTo(p1x, p1y);
            path.lineTo(p1x + (double)(-1 * xsign) * arTopPointX, p1y + (double)ysign * arTopPointY);
            path.lineTo(p2x, p2y);
            path.lineTo(p1x + (double)xsign * arTopPointX, p1y + (double)(-1 * ysign) * arTopPointY);
            path.lineTo(p1x, p1y);
        }
        path.closePath();
        g.fill(path);
    }

    public boolean connects(EntityPlotter from, EntityPlotter to) {
        return this.from.getId() == from.getId() && this.to.getId() == to.getId();
    }

    public Color getColor() {
        return this.conColor;
    }

    public String getId() {
        return this.id;
    }

    public void setConnectorPoints(Point fromP, Point toP) {
        this.fromPoint = fromP;
        this.toPoint = toP;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean value) {
        this.deactivated = value;
    }

    public boolean hitPoints(int x, int y) {
        return x >= this.midRect.x && x <= this.midRect.x + this.conPointSize && y >= this.midRect.y && y <= this.midRect.y + this.conPointSize;
    }

    public void setInDrag(boolean inDrag) {
        this.inDrag = inDrag;
    }

    public boolean isInDrag() {
        return this.inDrag;
    }

    public void setDragPoint(Point dragPoint) {
        this.dragPoint = dragPoint;
    }

    public Point getDragPoint() {
        return this.dragPoint;
    }

    private boolean doHitPoint(int x, int y, Point t) {
        if (x >= t.x && x <= t.x + this.conPointSize && y >= t.y && y <= t.y + this.conPointSize) {
            this.hittedPoint = t;
            return true;
        }
        return false;
    }

    protected boolean onRight(Rectangle2D from, Rectangle2D to) {
        return from.getX() > to.getX() + to.getWidth();
    }

    protected boolean onLeft(Rectangle2D from, Rectangle2D to) {
        return from.getX() + from.getWidth() < to.getX();
    }

    protected boolean onTop(Rectangle2D from, Rectangle2D to) {
        return from.getY() + from.getHeight() < to.getY();
    }

    protected boolean onBut(Rectangle2D from, Rectangle2D to) {
        return from.getY() > to.getY() + to.getHeight();
    }

    protected boolean onMidRight(Rectangle2D from, Rectangle2D to) {
        return from.getX() + from.getWidth() / 2.0 > to.getX() + to.getWidth();
    }

    protected boolean onMidLeft(Rectangle2D from, Rectangle2D to) {
        return from.getX() + from.getWidth() / 2.0 < to.getX();
    }

    protected boolean onMidTop(Rectangle2D from, Rectangle2D to) {
        return from.getY() + from.getHeight() / 2.0 < to.getY();
    }

    protected boolean onMidBut(Rectangle2D from, Rectangle2D to) {
        return from.getY() > to.getY() + to.getHeight() / 2.0;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow = showArrow;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public EntityPlotter getFrom() {
        return this.from;
    }

    public void setFrom(EntityPlotter from) {
        this.from = from;
    }

    public EntityPlotter getTo() {
        return this.to;
    }

    public void setTo(EntityPlotter to) {
        this.to = to;
    }

    public String getCommentText() {
        if (this.comment != null) {
            return this.comment.getText();
        }
        return null;
    }

    public void setCommentText(String commentText) {
        if (this.comment != null) {
            this.comment.setText(commentText);
        } else {
            this.addComment(commentText);
        }
    }

    public Color getConColor() {
        return this.conColor;
    }

    public void setConColor(Color conColor) {
        this.conColor = conColor;
    }

    public static enum ConnectionType {
        ManyToOne,
        ManyToMany,
        OneToMany,
        OneToOne;

    }

    public static enum ConnectionCategory {
        Orthogonal,
        Organic;

    }
}

