/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotAction;
import org.smyld.app.entityplot.EntityPlotController;
import org.smyld.app.entityplot.EntityPlotListener;
import org.smyld.app.entityplot.EntityPlotter;

public class EntityConnectorsPlotter {
    EntityPlotController controller;
    protected HashMap<String, EntityPlotter> entities;
    protected Vector<EntityConnector> conectors;
    protected Vector<EntityPlotAction> undoActions;
    EntityPlotListener listener;

    public void addController(EntityPlotController controller) {
        this.controller = controller;
    }

    public void setInfo(HashMap<String, EntityPlotter> entities, Vector<EntityConnector> conectors, Vector<EntityPlotAction> undoActions) {
        this.entities = entities;
        this.conectors = conectors;
        this.undoActions = undoActions;
    }

    public void addEntityPlotListener(EntityPlotListener newListener) {
        this.listener = newListener;
    }

    public void drawConnections(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(1.2f));
        for (EntityConnector curCon : this.conectors) {
            if (curCon.isDeactivated() || !curCon.from.isVisible() || !curCon.to.isVisible()) continue;
            curCon.drawLine(g);
        }
    }

    public void drawTransperantConnections(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(1.2f));
        for (EntityConnector curCon : this.conectors) {
            if (curCon.isDeactivated()) continue;
            Composite ocomp = null;
            if (!this.isEntTrans(curCon.from) && !this.isEntTrans(curCon.to)) continue;
            ocomp = g.getComposite();
            float trans = curCon.from.getEntityTransperancy();
            if (trans > curCon.to.getEntityTransperancy()) {
                trans = curCon.to.getEntityTransperancy();
            }
            AlphaComposite myAlpha = AlphaComposite.getInstance(3, trans);
            g.setComposite(myAlpha);
            if (curCon.from.isVisible() && curCon.to.isVisible()) {
                curCon.drawLine(g);
            }
            g.setComposite(ocomp);
        }
    }

    public void drawAllConnections(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(1.2f));
        for (EntityConnector curCon : this.conectors) {
            if (curCon.isDeactivated()) continue;
            Composite ocomp = null;
            if (this.isEntTrans(curCon.from) || this.isEntTrans(curCon.to)) {
                ocomp = g.getComposite();
                float trans = curCon.from.getEntityTransperancy();
                if (trans > curCon.to.getEntityTransperancy()) {
                    trans = curCon.to.getEntityTransperancy();
                }
                AlphaComposite myAlpha = AlphaComposite.getInstance(3, trans);
                g.setComposite(myAlpha);
                if (curCon.from.isVisible() && curCon.to.isVisible()) {
                    curCon.drawLine(g);
                }
                g.setComposite(ocomp);
                continue;
            }
            if (this.isEntTrans(curCon.from) || this.isEntTrans(curCon.to) || !curCon.from.isVisible() || !curCon.to.isVisible()) continue;
            curCon.drawLine(g);
        }
    }

    public void drawNonTransperantConnections(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(1.2f));
        for (EntityConnector curCon : this.conectors) {
            if (curCon.isDeactivated()) continue;
            Object ocomp = null;
            if (this.isEntTrans(curCon.from) || this.isEntTrans(curCon.to) || !curCon.from.isVisible() || !curCon.to.isVisible()) continue;
            curCon.drawLine(g);
        }
    }

    private boolean isEntTrans(EntityPlotter ent) {
        return ent.isTransperant();
    }
}

