/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotter;

public class EntityPlotLayoutManager {
    protected HashMap<String, EntityPlotter> entities;
    protected HashSet<String> positionedEnt = new HashSet();
    protected Vector<EntityConnector> conns;
    protected ArrayList<EntityPlotter> conEntities = new ArrayList();
    protected int initWidth = 800;
    protected int initHeight = 600;
    protected int topMargin = 80;
    protected int leftMargin = 40;
    protected int horzEntMargin = 20;
    protected int vertEntMargin = 50;

    public EntityPlotLayoutManager() {
    }

    public EntityPlotLayoutManager(int initWidth, int initHeight) {
        this.initWidth = initWidth;
        this.initHeight = initHeight;
    }

    public void doLayout(HashMap<String, EntityPlotter> entities, Vector<EntityConnector> conectors) {
        this.doLayout(entities, conectors, false);
    }

    public void doLayout(HashMap<String, EntityPlotter> entities, Vector<EntityConnector> conectors, boolean force) {
        this.entities = entities;
        this.conns = conectors;
        this.conEntities.addAll(entities.values());
        Collections.sort(this.conEntities, this.createComparator());
        int level = this.topMargin;
        for (EntityPlotter curEnt : this.conEntities) {
            if (!force && (force || this.positionedEnt.contains(curEnt.getId()))) continue;
            level = this.setPositionFor(this.initWidth / 2 - curEnt.getWidth() / 2, level, curEnt) + this.vertEntMargin;
        }
    }

    protected Comparator<EntityPlotter> createComparator() {
        return new Comparator<EntityPlotter>(){

            @Override
            public int compare(EntityPlotter from, EntityPlotter to) {
                int result = to.getConnectedEntities().size() - from.getConnectedEntities().size();
                if (result == 0) {
                    result = to.canConnectFrom() ? -1 : 1;
                }
                return result;
            }
        };
    }

    private int setPositionFor(int horizontalOffset, int verticalOffset, EntityPlotter curEnt) {
        curEnt.setPosition(new Point(horizontalOffset, verticalOffset));
        this.positionedEnt.add(curEnt.getId());
        int curPos = this.leftMargin;
        verticalOffset += curEnt.getHeight() + this.vertEntMargin;
        int maxHeight = 0;
        for (EntityPlotter childEnt : curEnt.getConnectedEntities().values()) {
            if (childEnt.getHeight() > maxHeight) {
                maxHeight = childEnt.getHeight();
            }
            childEnt.setPosition(new Point(curPos, verticalOffset));
            this.positionedEnt.add(childEnt.getId());
            curPos += childEnt.getWidth() + this.horzEntMargin;
        }
        return verticalOffset + maxHeight;
    }

    private int getTotalWidth(Collection<EntityPlotter> ents) {
        int totalWidth = 0;
        for (EntityPlotter curEnt : ents) {
            totalWidth += curEnt.getWidth();
        }
        return totalWidth;
    }

    public int getInitWidth() {
        return this.initWidth;
    }

    public void setInitWidth(int initWidth) {
        this.initWidth = initWidth;
    }

    public int getInitHeight() {
        return this.initHeight;
    }

    public void setInitHeight(int initHeight) {
        this.initHeight = initHeight;
    }

    public void reset() {
        this.initWidth = 800;
        this.initHeight = 600;
        this.topMargin = 20;
        this.leftMargin = 40;
        this.horzEntMargin = 20;
        this.vertEntMargin = 50;
    }
}

