/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotter;
import org.smyld.app.entityplot.PlotShape;
import org.smyld.app.entityplot.TextPlotter;
import org.smyld.app.entityplot.util.GUIUtil;

public class EntityPlotterImpl
implements EntityPlotter {
    protected Object userObject;
    protected int textLeftMargin = 10;
    protected int textButtomMargin = 10;
    protected int textRightMargin = 10;
    protected int titleTopMargin = 4;
    protected int titleSideMargin = 4;
    protected int titleRightMargin = 22;
    protected int textTopMargin = 4;
    protected int textLineMargin = 2;
    protected int borderWidth = 1;
    protected int connectorSize = 8;
    protected int selectionWidth = 6;
    protected int dndX;
    protected int dndY;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int type;
    protected int contentsHorizontalAlignment = 2;
    protected int contentsVerticalAlignment = 10;
    protected int titleAlignment = 2;
    protected int cornerCurve = 5;
    protected double totalContentHeight;
    protected float bgImageTransperancy = 0.4f;
    protected float entityTransperancy = 0.4f;
    protected float origImageTransperancy;
    protected int shLen = 4;
    protected Dimension ts;
    protected Rectangle bounds = new Rectangle(this.x, this.y, this.width, this.height);
    protected Font titleFont = new Font("Newtimes Roman", 1, 12);
    protected Font contentsFont = new Font("Newtimes Roman", 1, 10);
    protected Color connectorColor = Color.BLUE;
    protected Color contentBackground;
    protected Color titleBackground;
    protected Color borderColor;
    protected Color titleFontColor = Color.WHITE;
    protected Color contentFontColor = Color.WHITE;
    protected Color highlightColor = new Color(189, 136, 136);
    protected Color connectStartBackground = new Color(59, 123, 219);
    protected Color selectedBackground = new Color(190, 100, 100);
    protected Color titleDarkColor = new Color(12, 12, 136);
    protected Color titleLightColor = new Color(138, 154, 239);
    protected String title = "Title";
    protected String id;
    protected String contents;
    protected boolean autoExpand = true;
    protected boolean draggable = true;
    protected boolean doHighlight = false;
    protected boolean connectFrom = true;
    protected boolean connectTo = true;
    protected boolean visible = true;
    protected boolean selected;
    protected boolean doShowConnecting = false;
    protected boolean showTitle = true;
    protected boolean showBorder = true;
    protected boolean setTransperant = false;
    protected boolean bufferActivated = true;
    protected boolean refreshImgBuffer = false;
    protected boolean changeImgSize = false;
    protected boolean dropShadow = false;
    protected boolean dropReflection = false;
    protected PlotShape shape;
    protected TextPlotter textPlot = new TextPlotter();
    protected Image backgroundImage;
    protected BufferedImage normalState;
    protected HashMap<String, BufferedImage> imgBuffer = new HashMap();
    protected HashMap<Integer, Integer> connectionPoints = new HashMap();
    protected HashMap<String, EntityPlotter> connectedEntities = new HashMap();
    protected Vector<EntityConnector> connections = new Vector();
    protected Shape bodyShape;
    int imgSeq = 0;
    private static final String ENTITY_STATE_NORMAL = "normal";
    private static final String ENTITY_STATE_HIGHLIGHT = "hightlight";
    private static final String ENTITY_STATE_CONNECTING = "connecting";
    private static final String ENTITY_STATE_TRANSPERANT = "transperant";

    public EntityPlotterImpl(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bounds.setBounds(x, y, width, height);
    }

    public EntityPlotterImpl(int x, int y, int width, int height, PlotShape shape, Color contentBGColor) {
        this(x, y, width, height);
        this.shape = shape;
        this.contentBackground = contentBGColor;
    }

    public EntityPlotterImpl(int x, int y, int width, int height, PlotShape shape, Color contentBGColor, Color borderColor) {
        this(x, y, width, height, shape, contentBGColor);
        this.borderColor = borderColor;
    }

    public EntityPlotterImpl(int x, int y, int width, int height, PlotShape shape, Color contentBGColor, Color borderColor, String title) {
        this(x, y, width, height, shape, contentBGColor, borderColor);
        this.title = title;
    }

    @Override
    public void highlight(boolean highlight) {
        this.doHighlight = highlight;
    }

    @Override
    public void setConnectingState(boolean connecting) {
        this.doShowConnecting = connecting;
    }

    @Override
    public void setPosition(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.bounds.setLocation(this.x, this.y);
    }

    @Override
    public void setRelativePosition(Point p) {
        this.x = p.x - this.dndX;
        this.y = p.y - this.dndY;
        this.bounds.setLocation(this.x, this.y);
    }

    @Override
    public void startDragForPosition(Point p) {
        this.dndX = p.x - this.x;
        this.dndY = p.y - this.y;
    }

    @Override
    public boolean hitPoint(Point p) {
        return p.x >= this.x && p.x <= this.x + this.width && p.y >= this.y && p.y <= this.y + this.height;
    }

    public boolean hitConnector(Point p) {
        return p.x >= this.x && p.x <= this.x + this.width && p.y >= this.y && p.y <= this.y + this.height;
    }

    protected void setContentBackgroundState(Graphics2D g) {
        if (this.doShowConnecting) {
            g.setColor(this.connectStartBackground);
        } else if (this.doHighlight) {
            g.setColor(this.highlightColor);
        } else {
            g.setColor(this.contentBackground);
        }
    }

    protected void paintBody(Graphics2D g) {
        if (this.contentBackground == null) {
            return;
        }
        this.setContentBackgroundState(g);
        switch (this.shape) {
            case Rectangle: {
                this.bodyShape = new Rectangle2D.Float(this.x, this.y, this.width, this.height);
                g.fill(this.bodyShape);
                break;
            }
            case RoundedRectangle: {
                this.bodyShape = new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.cornerCurve, this.cornerCurve);
                g.fill(this.bodyShape);
                break;
            }
            case Circle: {
                this.bodyShape = new Ellipse2D.Float(this.x, this.y, this.width, this.height);
                g.fill(this.bodyShape);
                break;
            }
            case Oval: {
                g.fillOval(this.x, this.y, this.width, this.height);
            }
        }
    }

    public void resetConnectionPoints() {
        for (Integer curPos : this.connectionPoints.keySet()) {
            this.connectionPoints.put(curPos, 0);
        }
    }

    protected void paintBorder(Graphics2D g) {
        g.setStroke(new BasicStroke(this.borderWidth));
        g.setColor(this.borderColor);
        switch (this.shape) {
            case Rectangle: {
                g.drawRect(this.x, this.y, this.width, this.height);
                break;
            }
            case RoundedRectangle: {
                g.drawRoundRect(this.x, this.y, this.width, this.height, this.cornerCurve, this.cornerCurve);
                break;
            }
            case Circle: {
                g.drawArc(this.x, this.y, this.width, this.width, 0, 360);
                break;
            }
            case Oval: {
                g.drawOval(this.x, this.y, this.width, this.height);
            }
        }
    }

    protected void fillBufferedImage(BufferedImage bim) {
        bim.flush();
        Graphics2D g = bim.createGraphics();
        AffineTransform tx = new AffineTransform();
        tx.translate(-this.x, -this.y);
        g.setTransform(tx);
        g.setColor(Color.WHITE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (this.dropReflection) {
            if (this.dropShadow) {
                this.dropShadow = false;
                this.paintEntity(g);
                this.addReflection(g, bim, this.height);
                this.dropShadow = true;
                this.paintEntity(g);
            } else {
                this.paintEntity(g);
                this.addReflection(g, bim, this.height);
            }
        } else {
            this.paintEntity(g);
        }
        g.dispose();
    }

    private void addReflection(Graphics2D g, BufferedImage image, int imageHeight) {
        int imageWidth = this.width;
        int gap = 0;
        float opacity = 0.3f;
        float fadeHeight = 0.8f;
        BufferedImage reflection = new BufferedImage(imageWidth + 1, imageHeight, 2);
        Graphics2D rg = reflection.createGraphics();
        rg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        rg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        rg.translate(0, imageHeight + 5);
        rg.scale(1.0, -1.0);
        rg.drawRenderedImage(image, null);
        rg.setComposite(AlphaComposite.getInstance(6));
        rg.setPaint(new GradientPaint(0.0f, (float)imageHeight * fadeHeight, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, imageHeight, new Color(0.0f, 0.0f, 0.0f, opacity)));
        rg.fillRect(0, 0, imageWidth + 1, imageHeight + 5);
        rg.dispose();
        g.drawImage((Image)reflection, this.x, this.y + imageHeight + gap, null);
    }

    public void refreshBuffer() {
        this.refreshImgBuffer = true;
    }

    private void doRefreshBuffer() {
        BufferedImage normal = null;
        BufferedImage highlight = null;
        BufferedImage connecting = null;
        BufferedImage transperant = null;
        int imgHeight = this.height + this.borderWidth;
        int imgWidth = this.width + this.borderWidth;
        if (this.dropShadow) {
            imgHeight += this.shLen;
            imgWidth += this.shLen;
        }
        if (this.dropReflection) {
            imgHeight += this.height;
        }
        normal = new BufferedImage(imgWidth, imgHeight, 2);
        highlight = new BufferedImage(imgWidth, imgHeight, 2);
        connecting = new BufferedImage(imgWidth, imgHeight, 2);
        transperant = new BufferedImage(imgWidth, imgHeight, 2);
        this.doShowConnecting = false;
        this.doHighlight = false;
        this.setTransperant = false;
        this.fillBufferedImage(normal);
        this.setTransperant = true;
        this.fillBufferedImage(transperant);
        this.setTransperant = false;
        this.doShowConnecting = false;
        this.doHighlight = true;
        this.fillBufferedImage(highlight);
        this.doShowConnecting = true;
        this.doHighlight = false;
        this.fillBufferedImage(connecting);
        this.doHighlight = false;
        this.doShowConnecting = false;
        this.refreshImgBuffer = false;
        this.changeImgSize = false;
        this.imgBuffer.put(ENTITY_STATE_NORMAL, normal);
        this.imgBuffer.put(ENTITY_STATE_HIGHLIGHT, highlight);
        this.imgBuffer.put(ENTITY_STATE_CONNECTING, connecting);
        this.imgBuffer.put(ENTITY_STATE_TRANSPERANT, transperant);
    }

    public void paintEntity(Graphics2D g) {
        if (this.dropShadow && !this.setTransperant) {
            this.plotShadow(g);
        }
        if (this.setTransperant) {
            AlphaComposite myAlpha = AlphaComposite.getInstance(11, this.entityTransperancy);
            g.setComposite(myAlpha);
        }
        this.ts = this.getTitleSize(g);
        if (this.contents != null) {
            this.checkContents(g, this.ts.height);
        }
        if (!this.showBorder) {
            this.borderWidth = 0;
        }
        this.paintBody(g);
        if (this.showBorder && this.borderColor != null) {
            this.paintBorder(g);
        }
        if (this.showTitle) {
            this.paintTitle(g, this.ts);
        }
        this.paintContents(g, this.ts.height);
    }

    protected void plotShadow(Graphics2D g) {
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        switch (this.shape) {
            case Rectangle: {
                this.bodyShape = new Rectangle2D.Float(this.x + this.shLen, this.y + this.shLen, this.width, this.height);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
                this.bodyShape = new Rectangle2D.Float(this.x + this.shLen - 1, this.y + this.shLen - 1, this.width, this.height);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.4f));
                this.bodyShape = new Rectangle2D.Float(this.x + this.shLen - 2, this.y + this.shLen - 2, this.width, this.height);
                g.fill(this.bodyShape);
                break;
            }
            case RoundedRectangle: {
                this.bodyShape = new RoundRectangle2D.Float(this.x + this.shLen, this.y + this.shLen, this.width, this.height, this.cornerCurve, this.cornerCurve);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
                this.bodyShape = new RoundRectangle2D.Float(this.x + this.shLen - 1, this.y + this.shLen - 1, this.width, this.height, this.cornerCurve, this.cornerCurve);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                this.bodyShape = new RoundRectangle2D.Float(this.x + this.shLen - 2, this.y + this.shLen - 2, this.width, this.height, this.cornerCurve, this.cornerCurve);
                g.fill(this.bodyShape);
                break;
            }
            case Circle: {
                this.bodyShape = new Ellipse2D.Float(this.x + this.shLen, this.y + this.shLen, this.width, this.height);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
                this.bodyShape = new Ellipse2D.Float(this.x + this.shLen - 1, this.y + this.shLen - 1, this.width, this.height);
                g.fill(this.bodyShape);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                this.bodyShape = new Ellipse2D.Float(this.x + this.shLen - 2, this.y + this.shLen - 2, this.width, this.height);
                g.fill(this.bodyShape);
                break;
            }
            case Oval: {
                g.fillOval(this.x + this.shLen, this.y + this.shLen, this.width, this.height);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
                g.fillOval(this.x + this.shLen - 1, this.y + this.shLen - 1, this.width, this.height);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                g.fillOval(this.x + this.shLen - 2, this.y + this.shLen - 2, this.width, this.height);
            }
        }
    }

    @Override
    public void plot(Graphics2D g) {
        this.resetConnectionPoints();
        if (this.bufferActivated) {
            if (this.imgBuffer.size() == 0 || this.refreshImgBuffer) {
                this.calibrate(g);
                this.doRefreshBuffer();
            }
            BufferedImage curImg = null;
            curImg = this.doShowConnecting ? this.imgBuffer.get(ENTITY_STATE_CONNECTING) : (this.doHighlight ? this.imgBuffer.get(ENTITY_STATE_HIGHLIGHT) : this.imgBuffer.get(ENTITY_STATE_NORMAL));
            if (this.setTransperant) {
                Composite old = g.getComposite();
                AlphaComposite myAlpha = AlphaComposite.getInstance(3, this.entityTransperancy);
                g.setComposite(myAlpha);
                g.drawImage((Image)curImg, this.x, this.y, null);
                g.setComposite(old);
            } else {
                g.drawImage((Image)curImg, this.x, this.y, null);
            }
        } else {
            this.paintEntity(g);
        }
        if (this.isSelected()) {
            this.doPaintSelected(g);
        }
    }

    protected void paintTitle(Graphics2D g, Dimension ts) {
        switch (this.shape) {
            case RoundedRectangle: {
                this.paintTitleBackground(5, g, ts);
                g.setFont(this.titleFont);
                g.setColor(this.titleFontColor);
                TextLayout titleTxtLayout = new TextLayout(this.getTitle(), this.titleFont, g.getFontRenderContext());
                titleTxtLayout.draw(g, this.x + this.titleSideMargin, this.y + ts.height - ts.height / 4);
                break;
            }
            case Circle: {
                g.drawLine((int)((double)this.x + (double)this.width * 0.09), this.y + 30, (int)((double)this.x + (double)this.width * 0.91), this.y + 30);
                g.setPaint(new GradientPaint(this.x, this.y, Color.BLUE, this.x + this.width, this.y + ts.height, Color.WHITE));
                g.setFont(this.titleFont);
                g.setColor(this.titleFontColor);
                g.drawString(this.getTitle(), this.x + 10, this.y + ts.height - ts.height / 4);
            }
        }
    }

    private void postTitlePaint(Graphics2D g, Dimension ts) {
        TextLayout titleTxtLayout = new TextLayout(this.getTitle(), this.titleFont, g.getFontRenderContext());
        double eotX = (double)(this.x + this.titleSideMargin) + titleTxtLayout.getBounds().getX() + titleTxtLayout.getBounds().getWidth();
        int dis = 8;
        CubicCurve2D.Double titleTermDark = new CubicCurve2D.Double(eotX + (double)dis, this.y + ts.height - this.borderWidth * 2, eotX + 5.0 + (double)dis, (double)this.y + ts.getHeight() * 0.7, eotX + (double)dis, this.y + ts.height / 4, eotX + 10.0 + (double)dis, this.y);
        g.setColor(this.titleLightColor);
        g.draw(titleTermDark);
        CubicCurve2D.Double titleTermLight = new CubicCurve2D.Double(eotX + (double)(++dis), this.y + ts.height - this.borderWidth * 2, eotX + 5.0 + (double)dis, (double)this.y + ts.getHeight() * 0.7, eotX + (double)dis, this.y + ts.height / 4, eotX + 10.0 + (double)dis, this.y);
        g.setColor(this.titleDarkColor);
        g.draw(titleTermLight);
    }

    private void paintTitleBackground(int pattenNo, Graphics2D g, Dimension ts) {
        switch (pattenNo) {
            case 1: {
                this.paintTitleBGPattern1(g, ts);
                break;
            }
            case 2: {
                this.paintTitleBGPattern2(g, ts);
                break;
            }
            case 3: {
                this.paintTitleBGPattern3(g, ts);
                break;
            }
            case 4: {
                this.paintTitleBGPattern4(g, ts);
                break;
            }
            case 5: {
                this.paintTitleBGPattern5(g, ts);
            }
        }
    }

    private void paintTitleBGPattern1(Graphics2D g, Dimension ts) {
        g.drawRoundRect(this.x + this.borderWidth / 2, this.y + this.borderWidth, this.width - this.borderWidth, ts.height, this.cornerCurve, this.cornerCurve);
        Color[] colors = new Color[]{this.titleLightColor.brighter(), this.titleLightColor, this.titleDarkColor, this.titleLightColor.darker()};
        float[] dist = new float[]{0.0f, 0.2f, 0.7f, 1.0f};
        g.setPaint(new LinearGradientPaint(this.x + this.width / 2, this.y, this.x + this.width / 2, this.y + ts.height, dist, colors));
        g.fillRoundRect(this.x + this.borderWidth, this.y + this.borderWidth, this.width - this.borderWidth * 2, ts.height, this.cornerCurve, this.cornerCurve);
    }

    private void paintTitleBGPattern2(Graphics2D g, Dimension ts) {
        g.drawRoundRect(this.x + this.borderWidth / 2, this.y + this.borderWidth, this.width - this.borderWidth, ts.height, this.cornerCurve, this.cornerCurve);
        Color middleColor = this.titleDarkColor;
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y, this.titleLightColor, this.x + this.width / 2, this.y + ts.height / 2, middleColor));
        g.fillRoundRect(this.x + this.borderWidth, this.y + this.borderWidth, this.width - this.borderWidth * 2, ts.height / 2 + 2, this.cornerCurve, this.cornerCurve);
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y + ts.height / 2, middleColor, this.x + this.width / 2, this.y + ts.height, this.titleDarkColor));
        g.fillRoundRect(this.x + this.borderWidth, this.y + this.borderWidth + ts.height / 2 - 2, this.width - this.borderWidth * 2, ts.height / 2 + 3, this.cornerCurve, this.cornerCurve);
    }

    private void paintTitleBGPattern3(Graphics2D g, Dimension ts) {
        Area upper = new Area(this.bodyShape);
        upper.intersect(new Area(new Rectangle2D.Float(this.x, this.y, this.width, ts.height / 2)));
        Color midColor = GUIUtil.getMiddleColor(this.titleDarkColor, this.titleLightColor);
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y, this.titleLightColor, this.x + this.width / 2, this.y + ts.height / 2, midColor));
        g.fill(upper);
        Area lower = new Area(this.bodyShape);
        lower.intersect(new Area(new Rectangle2D.Float(this.x, this.y + ts.height / 2, this.width, ts.height / 2)));
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y + ts.height / 2, this.titleDarkColor, this.x + this.width / 2, this.y + ts.height, midColor));
        g.fill(lower);
    }

    private void paintTitleBGPattern4(Graphics2D g, Dimension ts) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.x, this.y + ts.height);
        gp.quadTo(this.x + ts.height, this.y + ts.height / 2, this.x + ts.height, this.y + ts.height / 2);
        gp.lineTo(this.x + this.width - ts.height, this.y + ts.height / 2);
        gp.quadTo(this.x + this.width, this.y + ts.height / 4, this.x + this.width, this.y);
        gp.lineTo(this.x, this.y);
        gp.closePath();
        Area upper = new Area(this.bodyShape);
        upper.intersect(new Area(gp));
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y, this.titleLightColor, this.x + this.width / 2, this.y + ts.height, this.titleDarkColor));
        g.fill(upper);
        gp = new GeneralPath();
        gp.moveTo(this.x, this.y + ts.height);
        gp.quadTo(this.x + ts.height, this.y + ts.height / 2, this.x + ts.height, this.y + ts.height / 2);
        gp.lineTo(this.x + this.width - ts.height, this.y + ts.height / 2);
        gp.quadTo(this.x + this.width, this.y + ts.height / 4, this.x + this.width, this.y);
        gp.lineTo(this.x + this.width, this.y + ts.height);
        gp.lineTo(this.x, this.y + ts.height);
        gp.closePath();
        Area lower = new Area(this.bodyShape);
        lower.intersect(new Area(gp));
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y, this.titleDarkColor, this.x + this.width / 2, this.y + ts.height, this.titleLightColor.darker()));
        g.fill(lower);
    }

    private void paintTitleBGPattern5(Graphics2D g, Dimension ts) {
        Color midColor = GUIUtil.getMiddleColor(this.titleDarkColor, this.titleLightColor);
        Area lower = new Area(this.bodyShape);
        lower.intersect(new Area(new Rectangle2D.Float(this.x, this.y, this.width, ts.height + this.borderWidth + 1)));
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y + ts.height / 2, this.titleDarkColor, this.x + this.width / 2, this.y + ts.height, midColor));
        g.fill(lower);
        Area upper = new Area(this.bodyShape);
        upper.intersect(new Area(new RoundRectangle2D.Float(this.x, this.y + ts.height / 2 - this.height, this.width, this.height, this.cornerCurve, this.cornerCurve)));
        g.setPaint(new GradientPaint(this.x + this.width / 2, this.y, this.titleLightColor, this.x + this.width / 2, this.y + ts.height / 2, midColor));
        g.fill(upper);
        TextLayout titleTxtLayout = new TextLayout(this.getTitle(), this.titleFont, g.getFontRenderContext());
        double eotX = (double)(this.x + this.titleSideMargin) + titleTxtLayout.getBounds().getX() + titleTxtLayout.getBounds().getWidth();
        int dis = 8;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.x, this.y + ts.height);
        gp.lineTo(eotX + (double)dis, (double)(this.y + ts.height));
        gp.curveTo(eotX + 5.0 + (double)dis, (double)this.y + ts.getHeight() * 0.7, eotX + (double)dis, (double)(this.y + ts.height / 4), eotX + 10.0 + (double)dis, (double)this.y);
        gp.lineTo(this.x, this.y);
        gp.closePath();
        Area title = new Area(this.bodyShape);
        title.intersect(new Area(gp));
        Color[] colors = new Color[]{this.titleLightColor, midColor, this.titleDarkColor, midColor};
        float[] dist = new float[]{0.0f, 0.2f, 0.7f, 1.0f};
        g.setPaint(new LinearGradientPaint(this.x + this.width / 2, this.y, this.x + this.width / 2, this.y + ts.height, dist, colors));
        g.fill(title);
        gp = new GeneralPath();
        gp.moveTo(this.x, this.y + ts.height);
        gp.lineTo(eotX + (double)dis, (double)(this.y + ts.height));
        gp.curveTo(eotX + 5.0 + (double)dis, (double)this.y + ts.getHeight() * 0.7, eotX + (double)dis, (double)(this.y + ts.height / 4), eotX + 10.0 + (double)dis, (double)this.y);
        g.setColor(Color.DARK_GRAY);
        g.draw(gp);
        gp = new GeneralPath();
        gp.moveTo(this.x, this.y + ts.height + 1);
        gp.lineTo(eotX + (double)(++dis), (double)(this.y + ts.height + 1));
        gp.curveTo(eotX + 5.0 + (double)dis, (double)this.y + ts.getHeight() * 0.7, eotX + (double)dis, (double)(this.y + ts.height / 4), eotX + 10.0 + (double)dis, (double)this.y);
        g.setColor(this.titleLightColor);
        g.draw(gp);
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    @Override
    public void calibrate(Graphics2D g) {
        if (this.contents != null) {
            this.checkContents(g, this.getTitleSize((Graphics2D)g).height);
        }
    }

    private void doPaintSelected(Graphics2D g) {
        g.setColor(this.selectedBackground);
        g.setStroke(new BasicStroke(1.0f));
        this.drawSingleSelectionPoint(this.getConnectionPoint(1, false), g);
        this.drawSingleSelectionPoint(this.getConnectionPoint(5, false), g);
        this.drawSingleSelectionPoint(this.getConnectionPoint(6, false), g);
        this.drawSingleSelectionPoint(this.getConnectionPoint(7, false), g);
    }

    private void drawSingleSelectionPoint(Point p, Graphics2D g) {
        g.drawRect(p.x - this.selectionWidth / 2, p.y - this.selectionWidth / 2, this.selectionWidth, this.selectionWidth);
    }

    private Dimension getTitleSize(Graphics2D g) {
        if (!this.showTitle) {
            return new Dimension(0, 0);
        }
        Rectangle2D titleBounds = this.titleFont.getStringBounds(this.title, g.getFontRenderContext());
        Dimension result = new Dimension((int)(titleBounds.getWidth() + (double)this.titleSideMargin + (double)this.titleRightMargin), (int)(titleBounds.getHeight() + (double)(this.titleTopMargin * 2)));
        if (this.autoExpand && result.width > this.width) {
            this.changeWidth(result.width);
        }
        return result;
    }

    private Shape createClipShape() {
        float border = 20.0f;
        float widht = 500.0f;
        float height = 500.0f;
        float x1 = border;
        float y1 = border;
        float x2 = (float)this.width - border;
        float y2 = height - border;
        float adj = 3.0f;
        float arc = 8.0f;
        float dcx = 0.18f * (float)this.width;
        float cx1 = x1 - dcx;
        float cy1 = 0.4f * height;
        float cx2 = x1 + dcx;
        float cy2 = 0.5f * height;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x1 - adj, y1 + adj);
        gp.quadTo(x1, y1, x1 + adj, y1);
        gp.lineTo(x2 - arc, y1);
        gp.quadTo(x2, y1, x2, y1 + arc);
        gp.lineTo(x2, y2 - arc);
        gp.quadTo(x2, y2, x2 - arc, y2);
        gp.lineTo(x1 + adj, y2);
        gp.quadTo(x1, y2, x1, y2 - adj);
        gp.curveTo(cx2, cy2, cx1, cy1, x1 - adj, y1 + adj);
        gp.closePath();
        return gp;
    }

    protected void drawContentsBackground(Graphics2D g) {
        Composite origComposite = g.getComposite();
        if (this.backgroundImage != null) {
            AlphaComposite myAlpha = AlphaComposite.getInstance(3, this.bgImageTransperancy);
            if (this.setTransperant) {
                myAlpha = AlphaComposite.getInstance(3, this.entityTransperancy);
            }
            g.setComposite(myAlpha);
            int imgWidth = this.backgroundImage.getWidth(null);
            int imgHeight = this.backgroundImage.getHeight(null);
            int imgLocX = this.x + this.width / 2 - imgWidth / 2;
            int imgLocY = this.y + this.height / 2 - imgHeight / 2;
            g.drawImage(this.backgroundImage, imgLocX, imgLocY, null);
        }
        g.setComposite(origComposite);
    }

    protected void paintContents(Graphics2D g, int th) {
        String[] conts;
        this.drawContentsBackground(g);
        g.setFont(this.contentsFont);
        g.setColor(this.contentFontColor);
        if (this.contents != null && (conts = this.contents.split("\n")).length >= 1) {
            double singleLineHeight = this.contentsFont.getStringBounds(conts[0], g.getFontRenderContext()).getHeight();
            float posY = this.detectContentsFirstLine(g, th, singleLineHeight, conts.length);
            switch (this.contentsHorizontalAlignment) {
                case 1: {
                    for (String curLine : conts) {
                        int txtWidth = (int)this.contentsFont.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                        float posX = this.x + (this.width - txtWidth) / 2;
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                    break;
                }
                case 3: {
                    for (String curLine : conts) {
                        double txtWidth = this.contentsFont.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                        float posX = (float)((double)(this.x + this.width) - (txtWidth + (double)this.textRightMargin));
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                    break;
                }
                default: {
                    float posX = this.x + this.textLeftMargin + this.borderWidth;
                    for (String curLine : conts) {
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                }
            }
        }
    }

    protected float detectContentsFirstLine(Graphics2D g, int th, double singleLineHeight, int lineNo) {
        float posY = 0.0f;
        switch (this.contentsVerticalAlignment) {
            case 10: {
                posY = (float)((double)(this.y + th + this.borderWidth + this.textTopMargin) + singleLineHeight);
                break;
            }
            case 11: {
                posY = (float)((double)(this.y + th + this.borderWidth + (this.height - th) / 2) - this.totalContentHeight / 2.0 + singleLineHeight);
                break;
            }
            case 12: {
                posY = (float)((double)(this.y + this.height) + singleLineHeight - (this.totalContentHeight + (double)this.textButtomMargin));
            }
        }
        return posY;
    }

    private void checkContents(Graphics2D g, int th) {
        String[] conts;
        if (this.contents != null && (conts = this.contents.split("\n")).length >= 1) {
            double singleLineHeight = this.contentsFont.getStringBounds(conts[0], g.getFontRenderContext()).getHeight();
            this.totalContentHeight = (singleLineHeight + (double)this.textLineMargin) * (double)conts.length - (double)this.textLineMargin;
            double maxTextWidth = 0.0;
            Object longestLine = null;
            for (String curLine : conts) {
                double curWidth = this.contentsFont.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                maxTextWidth = curWidth > maxTextWidth ? curWidth : maxTextWidth;
            }
            double totalContentWidth = (double)this.textLeftMargin + maxTextWidth + (double)(2 * this.borderWidth) + (double)this.textRightMargin;
            int addHeight = this.textTopMargin + this.textButtomMargin + 2 * this.borderWidth;
            if ((double)(this.height - th) < this.totalContentHeight + (double)addHeight && this.autoExpand) {
                this.changeHeight((int)(this.totalContentHeight + (double)th + (double)addHeight));
            }
            if (this.autoExpand && (double)this.width < totalContentWidth) {
                this.changeWidth((int)totalContentWidth);
            }
        }
    }

    protected int processConPointDis(int position) {
        Object target = null;
        Integer pointsCount = this.connectionPoints.get(position);
        if (pointsCount == null) {
            pointsCount = new Integer(0);
            this.connectionPoints.put(position, pointsCount);
        }
        int conCount = pointsCount + 1;
        int dis = Math.round(conCount / 2) * 4;
        int n = conCount % 2 == 0 ? 1 : -1;
        this.connectionPoints.put(position, conCount);
        return dis *= n;
    }

    @Override
    public Point getConnectionPoint(int position, boolean checkDisplacement) {
        Point target = null;
        int dis = checkDisplacement ? this.processConPointDis(position) : 0;
        switch (position) {
            case 2: {
                return new Point(this.x, this.y);
            }
            case 1: {
                target = new Point(this.x + this.width / 2 + dis, this.y - this.borderWidth);
                return target;
            }
            case 3: {
                return new Point(this.x + this.width, this.y);
            }
            case 4: {
                return new Point(this.x + this.width / 2, this.y + this.height / 2);
            }
            case 6: {
                return new Point(this.x + this.width, this.y + this.height / 2 + dis);
            }
            case 5: {
                return new Point(this.x - this.borderWidth, this.y + this.height / 2 + dis);
            }
            case 7: {
                return new Point(this.x + this.width / 2 + dis, this.y + this.height);
            }
            case 9: {
                return new Point(this.x + this.width, this.y + this.height);
            }
            case 8: {
                return new Point(this.x, this.y + this.height);
            }
        }
        return null;
    }

    public Point getConnectionPoint1(int position) {
        switch (position) {
            case 2: {
                return new Point(this.x, this.y);
            }
            case 1: {
                return new Point(this.x + this.width / 2, this.y - this.borderWidth);
            }
            case 3: {
                return new Point(this.x + this.width, this.y);
            }
            case 4: {
                return new Point(this.x + this.width / 2, this.y + this.height / 2);
            }
            case 6: {
                return new Point(this.x + this.width, this.y + this.height / 2);
            }
            case 5: {
                return new Point(this.x - this.borderWidth, this.y + this.height / 2);
            }
            case 7: {
                return new Point(this.x + this.width / 2, this.y + this.height);
            }
            case 9: {
                return new Point(this.x + this.width, this.y + this.height);
            }
            case 8: {
                return new Point(this.x, this.y + this.height);
            }
        }
        return null;
    }

    @Override
    public void paintConnectorOn(int position, Graphics2D g) {
        Point conPoint = this.getConnectionPoint(position, true);
        switch (position) {
            case 1: {
                g.fillArc(conPoint.x - this.connectorSize / 2, conPoint.y - this.borderWidth, this.connectorSize, this.connectorSize, 0, 180);
                break;
            }
            case 6: {
                g.fillArc(conPoint.x, conPoint.y - this.connectorSize / 2, this.connectorSize, this.connectorSize, 270, 450);
                break;
            }
            case 5: {
                g.fillArc(conPoint.x - this.borderWidth, conPoint.y - this.connectorSize / 2, this.connectorSize, this.connectorSize, 90, 270);
                break;
            }
            case 7: {
                g.fillArc(conPoint.x - this.connectorSize / 2, conPoint.y, this.connectorSize, this.connectorSize, 180, 360);
            }
        }
    }

    @Override
    public String dumpLayoutInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId());
        sb.append("|");
        sb.append(this.bounds.x);
        sb.append("|");
        sb.append(this.bounds.y);
        sb.append("|");
        sb.append(this.getWidth());
        sb.append("|");
        sb.append(this.getHeight());
        return sb.toString();
    }

    @Override
    public String dumpGUIConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.getType()));
        sb.append("|");
        sb.append(this.exportColor(this.getTitleDarkColor()));
        sb.append("|");
        sb.append(this.exportColor(this.getTitleLightColor()));
        sb.append("|");
        sb.append(this.exportColor(this.getTitleFontColor()));
        sb.append("|");
        sb.append(this.exportFont(this.getTitleFont()));
        sb.append("|");
        sb.append(this.exportColor(this.getContentBackground()));
        sb.append("|");
        sb.append(this.exportColor(this.getContentFontColor()));
        sb.append("|");
        sb.append(this.exportFont(this.getContentsFont()));
        return sb.toString();
    }

    @Override
    public void adjustToGUIConfigInfo(String data) {
        String[] info = data.split("\\|");
        if (info != null && info.length > 0) {
            this.setTitleDarkColor(this.importColor(info[0]));
            this.setTitleLightColor(this.importColor(info[1]));
            this.setTitleFontColor(this.importColor(info[2]));
            this.setTitleFont(this.importFont(info[3]));
            this.setContentBackground(this.importColor(info[4]));
            this.setContentFontColor(this.importColor(info[5]));
            this.setContentsFont(this.importFont(info[6]));
        }
    }

    private String exportFont(Font font) {
        StringBuilder sb = new StringBuilder();
        sb.append(font.getFamily());
        sb.append(",");
        sb.append(Integer.toString(font.getStyle()));
        sb.append(",");
        sb.append(Integer.toString(font.getSize()));
        return sb.toString();
    }

    private Font importFont(String fontText) {
        String[] fntInfo = fontText.split(",");
        return new Font(fntInfo[0], Integer.parseInt(fntInfo[1]), Integer.parseInt(fntInfo[2]));
    }

    private Color importColor(String colorText) {
        String[] colInfo = colorText.split(",");
        return new Color(Integer.parseInt(colInfo[0]), Integer.parseInt(colInfo[1]), Integer.parseInt(colInfo[2]));
    }

    private String exportColor(Color color) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(color.getRed()));
        sb.append(",");
        sb.append(Integer.toString(color.getGreen()));
        sb.append(",");
        sb.append(Integer.toString(color.getBlue()));
        return sb.toString();
    }

    @Override
    public void adjustToLayoutInfo(String data) {
        String[] info = data.split("\\|");
        if (info != null && info.length > 0) {
            String id = info[0];
            int x = Integer.parseInt(info[1]);
            int y = Integer.parseInt(info[2]);
            int w = Integer.parseInt(info[3]);
            int h = Integer.parseInt(info[4]);
            this.setX(x);
            this.setY(y);
            this.changeWidth(w);
            this.changeHeight(h);
        }
    }

    @Override
    public boolean equals(EntityPlotter compare) {
        if (compare.getId() != null && this.id != null) {
            return this.id.equals(compare.getId());
        }
        return false;
    }

    public void activateConnectionTo(boolean activate) {
        this.connectTo = activate;
    }

    public void activateConnectionFrom(boolean activate) {
        this.connectFrom = activate;
    }

    @Override
    public boolean canConnectFrom() {
        return this.connectFrom;
    }

    @Override
    public boolean canConnectTo() {
        return this.connectTo;
    }

    @Override
    public HashMap<String, EntityPlotter> getConnectedEntities() {
        return this.connectedEntities;
    }

    @Override
    public void newConnection(EntityConnector newCon) {
        if (newCon.from.equals(this)) {
            this.connectedEntities.put(newCon.to.getId(), newCon.to);
        } else if (newCon.to.equals(this)) {
            this.connectedEntities.put(newCon.from.getId(), newCon.from);
        }
        this.connections.add(newCon);
    }

    @Override
    public void removeConnection(EntityConnector delCon) {
        if (delCon.from.equals(this)) {
            this.connectedEntities.remove(delCon.to.getId());
        } else if (delCon.to.equals(this)) {
            this.connectedEntities.remove(delCon.from.getId());
        }
        this.connections.remove(delCon);
    }

    @Override
    public EntityConnector getConnectorForEntity(EntityPlotter entity) {
        if (entity == null || !this.connectedEntities.containsValue(entity)) {
            return null;
        }
        for (EntityConnector curConn : this.connections) {
            if (!curConn.getFrom().equals(entity) && !curConn.getTo().equals(entity)) continue;
            return curConn;
        }
        return null;
    }

    @Override
    public boolean isDraggable() {
        return this.draggable;
    }

    @Override
    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public void setShape(PlotShape shape) {
        this.shape = shape;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
        this.bounds.setLocation(x, this.y);
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.bounds.setLocation(this.x, y);
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.changeWidth(width);
        this.refreshBuffer();
    }

    protected void changeWidth(int width) {
        this.changeImgSize = true;
        this.bounds.setSize(width, this.height);
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.changeHeight(height);
        this.refreshBuffer();
    }

    protected void changeHeight(int height) {
        this.changeImgSize = true;
        this.bounds.setSize(this.width, height);
        this.height = height;
    }

    @Override
    public Color getContentBackground() {
        return this.contentBackground;
    }

    @Override
    public void setContentBackground(Color contentBackground) {
        this.contentBackground = contentBackground;
        this.refreshBuffer();
    }

    public PlotShape getShape() {
        return this.shape;
    }

    @Override
    public String getContents() {
        return this.contents;
    }

    @Override
    public void setContents(String contents) {
        this.contents = contents;
        this.refreshBuffer();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void setAutoExpand(boolean expand) {
        this.autoExpand = expand;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.refreshBuffer();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.refreshBuffer();
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public int getTextLeftMargin() {
        return this.textLeftMargin;
    }

    public void setTextLeftMargin(int textLeftMargin) {
        this.textLeftMargin = textLeftMargin;
        this.refreshBuffer();
    }

    public void setTitleBackground(Color titleBackground) {
        this.titleBackground = titleBackground;
        this.refreshBuffer();
    }

    @Override
    public int getConnectorSize() {
        return this.connectorSize;
    }

    @Override
    public boolean isHighlighted() {
        return this.doHighlight;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public boolean isShowTitle() {
        return this.showTitle;
    }

    @Override
    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
        this.refreshBuffer();
    }

    @Override
    public Font getContentsFont() {
        return this.contentsFont;
    }

    @Override
    public void setContentsFont(Font contentsFont) {
        this.contentsFont = contentsFont;
        this.refreshBuffer();
    }

    @Override
    public int getContentsHorizontalAlignment() {
        return this.contentsHorizontalAlignment;
    }

    @Override
    public void setContentsHorizontalAlignment(int contentsAlignment) {
        this.contentsHorizontalAlignment = contentsAlignment;
        this.refreshBuffer();
    }

    @Override
    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    @Override
    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.refreshBuffer();
    }

    public void setCornerCurve(int cornerCurve) {
        this.cornerCurve = cornerCurve;
        this.refreshBuffer();
    }

    @Override
    public Color getTitleDarkColor() {
        return this.titleDarkColor;
    }

    @Override
    public void setTitleDarkColor(Color titleDarkColor) {
        this.titleDarkColor = titleDarkColor;
        this.refreshBuffer();
    }

    @Override
    public Color getTitleLightColor() {
        return this.titleLightColor;
    }

    @Override
    public void setTitleLightColor(Color titleLightColor) {
        this.titleLightColor = titleLightColor;
        this.refreshBuffer();
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    @Override
    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        this.refreshBuffer();
    }

    @Override
    public Color getTitleFontColor() {
        return this.titleFontColor;
    }

    @Override
    public void setTitleFontColor(Color titleFontColor) {
        this.titleFontColor = titleFontColor;
        this.refreshBuffer();
    }

    @Override
    public Color getContentFontColor() {
        return this.contentFontColor;
    }

    @Override
    public void setContentFontColor(Color contentFontColor) {
        this.contentFontColor = contentFontColor;
        this.refreshBuffer();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.refreshBuffer();
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
        this.refreshBuffer();
    }

    @Override
    public int getContentsVerticalAlignment() {
        return this.contentsVerticalAlignment;
    }

    @Override
    public void setContentsVerticalAlignment(int contentsVerticalAlignment) {
        this.contentsVerticalAlignment = contentsVerticalAlignment;
        this.refreshBuffer();
    }

    @Override
    public Color getConnectorColor() {
        return this.connectorColor;
    }

    public void setConnectorColor(Color connectorColor) {
        this.connectorColor = connectorColor;
        this.refreshBuffer();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.refreshBuffer();
    }

    @Override
    public Vector<EntityConnector> getConnections() {
        return this.connections;
    }

    @Override
    public void setBGImageTransperancy(float newValue) {
        if (newValue >= 0.0f && newValue <= 1.0f) {
            this.bgImageTransperancy = newValue;
        }
    }

    @Override
    public float getEntityTransperancy() {
        return this.entityTransperancy;
    }

    @Override
    public void setEntityTransperancy(float entityTransperancy) {
        if (this.entityTransperancy != entityTransperancy) {
            this.entityTransperancy = entityTransperancy;
        }
    }

    @Override
    public boolean isTransperant() {
        return this.setTransperant;
    }

    @Override
    public void setTransperant(boolean setTransperant) {
        this.setTransperant = setTransperant;
    }

    @Override
    public boolean isDropShadow() {
        return this.dropShadow;
    }

    @Override
    public void setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
    }

    @Override
    public boolean isDropReflection() {
        return this.dropReflection;
    }

    @Override
    public void setDropReflection(boolean dropReflection) {
        this.dropReflection = dropReflection;
    }
}

