/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.apache.log4j.Logger;
import org.smyld.app.entityplot.ActionAddConnection;
import org.smyld.app.entityplot.ActionAddEntity;
import org.smyld.app.entityplot.ActionAlignEntity;
import org.smyld.app.entityplot.ActionDelConnection;
import org.smyld.app.entityplot.ActionDelEntity;
import org.smyld.app.entityplot.ActionDoubleAlignEntity;
import org.smyld.app.entityplot.ActionDragEntity;
import org.smyld.app.entityplot.ActionResizeEntity;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityConnectorsPlotter;
import org.smyld.app.entityplot.EntityPlotAction;
import org.smyld.app.entityplot.EntityPlotController;
import org.smyld.app.entityplot.EntityPlotLayoutManager;
import org.smyld.app.entityplot.EntityPlotListener;
import org.smyld.app.entityplot.EntityPlotter;
import org.smyld.app.entityplot.OrthogonalEntityConnector;
import org.smyld.app.entityplot.UndoListener;
import org.smyld.app.entityplot.util.Three60TLogo;

public class GUIPlotter
extends JPanel
implements Scrollable {
    private static final Logger LOG = Logger.getLogger((String)"org.smyld.app.entityplot.GUIPlotter");
    protected JScrollPane sccontainer;
    protected HashMap<String, EntityPlotter> entities = new HashMap();
    protected HashMap<Integer, String> entGUIConfs = new HashMap();
    protected Vector<EntityConnector> conectors = new Vector();
    protected Vector<EntityPlotter> selected = new Vector();
    protected Vector<EntityPlotAction> undoActions = new Vector();
    EntityPlotter draggedEntity = null;
    EntityPlotter latestHighlighted;
    EntityPlotter conFrom;
    EntityConnector draggedCon = null;
    Toolbar tools = new Toolbar();
    Dimension curSize = new Dimension(10, 10);
    Point selStartPnt = null;
    Point selEndPnt = null;
    Rectangle curVisRect = new Rectangle();
    Rectangle prevPanelRect = new Rectangle();
    KeyStroke undoKey = KeyStroke.getKeyStroke(90, 2);
    KeyStroke selAllKey = KeyStroke.getKeyStroke(65, 2);
    EntityPlotListener listener;
    EntityPlotController controller;
    String presetLayout;
    RenderingHints qualityHints;
    protected EntityPlotLayoutManager manager;
    boolean inDrag;
    boolean inConDrag;
    boolean searchCon;
    boolean inDeleteMode;
    boolean exportingImage;
    boolean allowMultiSelection = true;
    boolean allowEntityDelete = true;
    boolean doAutoLayout = true;
    boolean firstTimeCreation = true;
    boolean showToolbar = true;
    boolean doZooming;
    boolean selecting;
    boolean showConnectedEntities = false;
    boolean connDraw = true;
    boolean animationActive = true;
    float showConTransp = 0.15f;
    double zoomValue = 1.0;
    int processMode = 0;
    EntityConnectorsPlotter connPlotter = new EntityConnectorsPlotter();
    RepaintManager mgr = RepaintManager.currentManager(null);
    Three60TLogo compLogo;
    Color selectionBG = new Color(120, 120, 120, 40);
    Color selTextColor = new Color(0, 73, 0, 90);
    Color selectionBR = new Color(0, 73, 0, 255);
    float[] dash = new float[]{4.0f, 1.0f, 4.0f, 1.0f, 4.0f};
    Stroke selStroke = new BasicStroke(1.0f, 0, 0, 14.0f, this.dash, 0.0f);
    Rectangle2D.Float selRect = new Rectangle2D.Float();
    Font selFont = new Font("Arial", 3, 12);
    BufferedImage logo;
    BufferedImage reflect;
    UndoListener undoListener;
    public static final int TOOL_ADD_CONNECTOR = 1;
    public static final int TOOL_DEL_CONNECTOR = 2;
    public static final int MODE_NO_PROCESSING = 0;
    public static final int MODE_ADD_CONNECTOR = 1;
    public static final int MODE_DEL_CONNECTOR = 2;

    public GUIPlotter(JScrollPane container, String presetLayout) {
        this.setPresetLayout(presetLayout);
        this.sccontainer = container;
        this.init();
    }

    public GUIPlotter(JScrollPane container) {
        this.sccontainer = container;
        this.init();
    }

    public GUIPlotter() {
        this.init();
    }

    public void addEntityPlotListener(EntityPlotListener newListener) {
        this.listener = newListener;
        this.connPlotter.addEntityPlotListener(newListener);
    }

    public void addUndoListener(UndoListener newUndoListener) {
        this.undoListener = newUndoListener;
    }

    public void setScrollContainer(JScrollPane container) {
        this.sccontainer = container;
        if (this.sccontainer != null) {
            this.sccontainer.getViewport().setScrollMode(0);
            this.sccontainer.setAutoscrolls(true);
        }
    }

    public void emptyUndoActions() {
        this.undoActions.removeAllElements();
    }

    public void zoom(boolean zoomOut) {
        this.doZooming = true;
        this.zoomValue = zoomOut ? (this.zoomValue -= 0.1) : (this.zoomValue += 0.1);
        this.repaint();
    }

    public void init() {
        this.compLogo = new Three60TLogo();
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                GUIPlotter.this.processMouseReleasedEvent(e);
                GUIPlotter.this.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GUIPlotter.this.processMousePressedEvent(e);
            }
        });
        super.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GUIPlotter.this.processMouseDraggedEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GUIPlotter.this.processMouseMovedEvent(e);
                GUIPlotter.this.requestFocus();
            }
        });
        this.mgr.setDoubleBufferingEnabled(true);
        this.setRequestFocusEnabled(true);
        this.mgr.removeInvalidComponent(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        super.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GUIPlotter.this.processKeyPressedEvent(e);
            }
        });
        this.setFocusable(true);
        this.setBackground(Color.WHITE);
        this.manager = this.createManager();
    }

    @Override
    public void validateTree() {
        Rectangle rect = this.mgr.getDirtyRegion(this);
        this.mgr.removeInvalidComponent(this);
        if (rect != null) {
            // empty if block
        }
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void setMode(int newMode) {
        this.processMode = newMode;
        switch (newMode) {
            case 1: {
                this.searchCon = true;
                this.inDeleteMode = false;
                break;
            }
            case 2: {
                this.conFrom = null;
                this.searchCon = false;
                this.inDeleteMode = true;
                break;
            }
            default: {
                this.searchCon = false;
                this.inDeleteMode = false;
            }
        }
        this.resetAllEntitiesStates();
        this.repaint();
    }

    public void undo() {
        if (this.undoActions.size() > 0) {
            EntityPlotAction curAction = this.undoActions.lastElement();
            if (this.undoListener != null && !this.undoListener.undo(curAction)) {
                return;
            }
            EntityPlotter ent = curAction.getEntity();
            block0 : switch (curAction.type) {
                case 1: {
                    ent.setVisible(true);
                    break;
                }
                case 2: {
                    EntityConnector connector = ((ActionDelConnection)curAction).connector;
                    connector.setDeactivated(false);
                    if (this.listener == null) break;
                    this.listener.entityConnected(connector.from, connector.to);
                    break;
                }
                case 3: {
                    ent.setPosition(((ActionDragEntity)curAction).oldPosition);
                    break;
                }
                case 5: {
                    EntityConnector connector = ((ActionAddConnection)curAction).connector;
                    connector.setDeactivated(true);
                    if (this.listener == null) break;
                    this.listener.entityDisconnected(connector.from, connector.to);
                    break;
                }
                case 4: {
                    ent.setVisible(false);
                    break;
                }
                case 7: {
                    ActionAlignEntity entAct = (ActionAlignEntity)curAction;
                    switch (entAct.getAlignType()) {
                        case 1: 
                        case 4: 
                        case 8: {
                            ent.setY(entAct.getDistance());
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 7: {
                            ent.setX(entAct.getDistance());
                            break;
                        }
                        case 9: 
                        case 10: {
                            ActionDoubleAlignEntity dblAct = (ActionDoubleAlignEntity)entAct;
                            ent.setX(dblAct.getHorizontalDistance());
                            ent.setY(dblAct.getVerticalDistance());
                        }
                    }
                    break;
                }
                case 8: {
                    ActionResizeEntity resAct = (ActionResizeEntity)curAction;
                    switch (resAct.getResizeType()) {
                        case 2: {
                            ent.setHeight(resAct.getSize());
                            break block0;
                        }
                        case 1: {
                            ent.setWidth(resAct.getSize());
                        }
                    }
                }
            }
            this.repaint();
            this.undoActions.remove(curAction);
        }
    }

    public void delete() {
        if (this.allowEntityDelete && this.selected.size() > 0) {
            for (EntityPlotter curEntity : this.selected) {
                this.delete(curEntity);
            }
            this.selected.removeAllElements();
        }
    }

    public String exportLayout() {
        StringBuilder sb = new StringBuilder();
        for (EntityPlotter ent : this.entities.values()) {
            sb.append("~~");
            sb.append(ent.dumpLayoutInfo());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] entConfs;
        String test = "~~FxForward|0|0|120|35~~mlniin-7f011-fm1k43f3-cp|0|0|200|110~~c9u0ti-7f011-fm1k43f1-cf|0|0|200|110~~FxOption|0|0|120|35~~oe3hw5-7f011-fm1k43f0-c7|0|0|200|110~~ltvor-7f011-fm1k43f0-c3|0|0|200|110~~6u759s-7f011-fm1k43f0-c4|0|0|200|100~~FxSwap|0|0|120|35~~q64j4g-7f011-fm1k43f3-ct|0|0|200|110~~LoanDeposit|0|0|120|35~~FRA|0|0|120|35";
        for (String curEntConf : entConfs = test.split("~~")) {
            if (curEntConf.isEmpty()) continue;
            LOG.info((Object)("Entity Configuration : " + curEntConf));
            String id = curEntConf.substring(0, curEntConf.indexOf("|"));
            LOG.info((Object)("ID is  : " + id));
        }
    }

    public void importLayout(String conf) {
        String[] entConfs;
        for (String curEntConf : entConfs = conf.split("~~")) {
            String id;
            if (curEntConf.isEmpty() || (id = curEntConf.substring(0, curEntConf.indexOf("|"))) == null || !this.entities.containsKey(id)) continue;
            EntityPlotter curEnt = this.entities.get(id);
            curEnt.adjustToLayoutInfo(curEntConf);
        }
    }

    private void processKeyPressedEvent(KeyEvent e) {
        KeyStroke curKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        if (curKeyStroke.equals(this.undoKey)) {
            this.undo();
        } else if (curKeyStroke.equals(this.selAllKey)) {
            this.selected.addAll(this.entities.values());
            for (EntityPlotter ent : this.entities.values()) {
                ent.setSelected(true);
            }
            this.repaint();
        } else if (e.getKeyCode() == 127) {
            this.delete();
        }
    }

    private void processMouseReleasedEvent(MouseEvent e) {
        if (e.getButton() == 1 && this.inDrag) {
            this.inDrag = false;
            this.setCursor(new Cursor(0));
            this.repaint();
        }
        if (this.selecting) {
            this.selecting = false;
            this.selStartPnt = null;
            this.selEndPnt = null;
            this.repaint();
        }
    }

    private void processMousePressedEvent(MouseEvent e) {
        if (this.inDeleteMode) {
            this.handleConnectionDelete(e);
        }
        if (e.getButton() == 1) {
            if ((e.getModifiersEx() & 0x80) == 128) {
                this.handleSingleEntitySelection(e);
            } else if (e.getClickCount() == 1) {
                this.checkMultiSelectionCancel(e);
                this.handleConnectionAdd(e);
                this.handleToolbar(e);
                this.checkTransperancy(e);
            } else if (e.getClickCount() == 2) {
                this.handleEntityDblClickEvent(e);
            }
        } else if (e.getButton() != 2 && e.getButton() == 3) {
            this.handleEntityPopupEvent(e);
        }
    }

    private void checkTransperancy(MouseEvent e) {
        if (this.animationActive) {
            this.setFadeTransperancy(e);
        } else {
            this.setNoFadeTransperancy(e);
        }
    }

    private void setNoFadeTransperancy(MouseEvent e) {
        EntityPlotter curEntity;
        if (this.showConnectedEntities && (curEntity = this.hitsEntity(e.getPoint())) != null) {
            for (EntityPlotter ent : this.entities.values()) {
                if (!ent.equals(curEntity) && !curEntity.getConnectedEntities().containsKey(ent.getId())) {
                    ent.setTransperant(true);
                    continue;
                }
                ent.setTransperant(false);
            }
            this.repaint();
        }
    }

    private void setFadeTransperancy(final MouseEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EntityPlotter curEntity;
                if (GUIPlotter.this.showConnectedEntities && (curEntity = GUIPlotter.this.hitsEntity(e.getPoint())) != null) {
                    float transDiff = 1.0f - GUIPlotter.this.showConTransp;
                    int transSimNo = 5;
                    float transStep = transDiff / (float)transSimNo;
                    for (int i = 0; i < transSimNo; ++i) {
                        float transChange = transStep * (float)(i + 1);
                        float fadeOut = 1.0f - transChange;
                        float fadeIn = GUIPlotter.this.showConTransp + transChange;
                        for (EntityPlotter ent : GUIPlotter.this.entities.values()) {
                            if (!ent.equals(curEntity) && !curEntity.getConnectedEntities().containsKey(ent.getId())) {
                                ent.setTransperant(true);
                                if (!(ent.getEntityTransperancy() > fadeOut)) continue;
                                ent.setEntityTransperancy(fadeOut);
                                continue;
                            }
                            if (!ent.isTransperant()) continue;
                            ent.setEntityTransperancy(fadeIn);
                        }
                        GUIPlotter.this.repaint();
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    for (EntityPlotter ent : GUIPlotter.this.entities.values()) {
                        ent.setTransperant(!ent.equals(curEntity) && !curEntity.getConnectedEntities().containsKey(ent.getId()));
                    }
                    GUIPlotter.this.repaint();
                }
            }
        }).start();
    }

    private void checkMultiSelectionCancel(MouseEvent e) {
        if (this.selected.size() > 0 && this.hitsEntity(e.getPoint()) == null) {
            for (EntityPlotter curEnt : this.selected) {
                curEnt.setSelected(false);
            }
            this.selected.removeAllElements();
            this.repaint();
        }
    }

    private void handleEntityDblClickEvent(MouseEvent e) {
        EntityPlotter curEntity;
        if (this.listener != null && (curEntity = this.hitsEntity(e.getPoint())) != null) {
            this.listener.entityDoubleClicked(curEntity);
        }
    }

    private void handleEntityPopupEvent(MouseEvent e) {
        if (this.listener != null) {
            EntityPlotter curEntity = this.hitsEntity(e.getPoint());
            Point realLocation = this.getBounds().getLocation();
            realLocation.x += e.getPoint().x;
            realLocation.y += e.getPoint().y;
            if (curEntity != null) {
                this.listener.entityPopup(curEntity, realLocation);
            }
        }
    }

    private void handleSingleEntitySelection(MouseEvent e) {
        EntityPlotter curEntity;
        if (this.allowMultiSelection && (curEntity = this.hitsEntity(e.getPoint())) != null) {
            if (curEntity.isSelected()) {
                curEntity.setSelected(false);
                this.selected.remove(curEntity);
            } else {
                curEntity.setSelected(true);
                if (!this.selected.contains(curEntity)) {
                    this.selected.add(curEntity);
                }
            }
            this.repaint();
        }
    }

    private void handleToolbar(MouseEvent e) {
        if (this.showToolbar && this.tools.hitsTool(e.getPoint())) {
            if (this.tools.getSelectedTool() == 1) {
                this.searchCon = this.tools.isSelecteToolActive();
                this.inDeleteMode = false;
                this.setMode(1);
            } else if (this.tools.getSelectedTool() == 2) {
                this.inDeleteMode = this.tools.isSelecteToolActive();
                if (this.latestHighlighted != null) {
                    this.latestHighlighted.highlight(false);
                }
                this.searchCon = false;
                this.setMode(2);
            }
        }
    }

    private void handleConnectionAdd(MouseEvent e) {
        if (this.searchCon) {
            EntityPlotter curEntity = this.hitsEntity(e.getPoint());
            if (curEntity != null) {
                if (this.conFrom != null && !this.conFrom.equals(curEntity) && curEntity.canConnectTo()) {
                    LOG.info((Object)("Do Connect " + this.conFrom.getId() + " to " + curEntity.getId()));
                    this.connectEntities(this.conFrom, curEntity);
                    this.resetSearchingConnection();
                } else if (this.latestHighlighted != null && this.latestHighlighted.equals(curEntity)) {
                    this.conFrom = curEntity;
                    curEntity.setConnectingState(true);
                    this.inConDrag = true;
                    this.repaint();
                }
            } else {
                LOG.info((Object)"Coniditon met");
                this.resetSearchingConnection();
            }
        }
    }

    private void handleConnectionDelete(MouseEvent e) {
        for (EntityConnector con : this.conectors) {
            if (!con.hitPoints(e.getX(), e.getY())) continue;
            this.deleteConnector(con);
        }
    }

    private void resetSearchingConnection() {
        if (this.conFrom != null) {
            this.conFrom.setConnectingState(false);
            this.conFrom = null;
        }
        this.latestHighlighted = null;
        this.inConDrag = false;
        this.resetAllEntitiesStates();
        this.repaint();
    }

    public Dimension getVisibleDiagramSize() {
        Dimension result = new Dimension(this.getWidth(), this.getHeight());
        int maxWidth = 0;
        int maxHeight = 0;
        int minWidth = -1;
        int minHeight = -1;
        for (EntityPlotter curEnt : this.entities.values()) {
            if (!curEnt.isVisible()) continue;
            if (minWidth == -1) {
                minWidth = curEnt.getX();
            }
            if (minHeight == -1) {
                minHeight = curEnt.getY();
            }
            if (curEnt.getX() + curEnt.getWidth() > maxWidth) {
                maxWidth = curEnt.getX() + curEnt.getWidth();
            }
            if (curEnt.getX() < minWidth) {
                minWidth = curEnt.getX();
            }
            if (curEnt.getY() + curEnt.getHeight() > maxHeight) {
                maxHeight = curEnt.getY() + curEnt.getHeight();
            }
            if (curEnt.getY() >= minHeight) continue;
            minHeight = curEnt.getY();
        }
        result.setSize(maxWidth + 10, maxHeight + 10);
        return result;
    }

    public Rectangle2D getVisibleDiagramBounds() {
        Rectangle result = new Rectangle();
        int maxWidth = 0;
        int maxHeight = 0;
        int minWidth = -1;
        int minHeight = -1;
        for (EntityPlotter curEnt : this.entities.values()) {
            if (!curEnt.isVisible()) continue;
            if (minWidth == -1) {
                minWidth = curEnt.getX();
            }
            if (minHeight == -1) {
                minHeight = curEnt.getY();
            }
            if (curEnt.getX() + curEnt.getWidth() > maxWidth) {
                maxWidth = curEnt.getX() + curEnt.getWidth();
            }
            if (curEnt.getX() < minWidth) {
                minWidth = curEnt.getX();
            }
            if (curEnt.getY() + curEnt.getHeight() > maxHeight) {
                maxHeight = curEnt.getY() + curEnt.getHeight();
            }
            if (curEnt.getY() >= minHeight) continue;
            minHeight = curEnt.getY();
        }
        result.setSize(maxWidth - minWidth, maxHeight - minHeight);
        result.setLocation(minWidth, minHeight);
        return result;
    }

    protected void highlightAllEntities(boolean highlight) {
        for (EntityPlotter ent : this.entities.values()) {
            ent.highlight(highlight);
        }
    }

    protected void setAllEntitiesConnectingState(boolean select) {
        for (EntityPlotter ent : this.entities.values()) {
            ent.setConnectingState(select);
        }
    }

    protected void resetAllEntitiesStates() {
        for (EntityPlotter ent : this.entities.values()) {
            ent.highlight(false);
            ent.setConnectingState(false);
        }
    }

    private void processMouseDraggedEvent(MouseEvent e) {
        Point mp;
        boolean doHits = false;
        EntityPlotter curEntity = this.hitsEntity(e.getPoint());
        if (!this.selecting && curEntity != null) {
            if (this.inConDrag) {
                if (this.conFrom != null) {
                    this.conFrom.setConnectingState(false);
                }
                this.inConDrag = false;
                this.conFrom = null;
            }
            doHits = true;
            if (curEntity.isDraggable()) {
                if (!this.inDrag) {
                    this.setCursor(new Cursor(12));
                    this.doAutoLayout = false;
                    this.inDrag = true;
                    mp = this.convertToZooming(e.getPoint());
                    if (this.selected.size() > 1) {
                        for (EntityPlotter ent : this.selected) {
                            this.undoActions.add(new ActionDragEntity(ent, new Point(ent.getX(), ent.getY())));
                            ent.startDragForPosition(mp);
                        }
                    } else {
                        this.draggedEntity = curEntity;
                        this.undoActions.add(new ActionDragEntity(curEntity, new Point(curEntity.getX(), curEntity.getY())));
                        curEntity.startDragForPosition(mp);
                    }
                }
                this.repaint();
            }
        } else if (!this.inDrag) {
            this.handleSelection(e);
        }
        if (this.inDrag) {
            mp = this.convertToZooming(e.getPoint());
            if (this.selected.size() > 1) {
                for (EntityPlotter ent : this.selected) {
                    ent.setRelativePosition(mp);
                    this.checkScrolling(mp, ent);
                }
            } else {
                this.draggedEntity.setRelativePosition(mp);
                this.checkScrolling(mp, this.draggedEntity);
            }
            this.repaint();
        }
    }

    private void applySelection(MouseEvent e) {
        for (EntityPlotter ent : this.entities.values()) {
            if (this.selRect.intersects(ent.getBounds())) {
                ent.setSelected(true);
                if (this.selected.contains(ent)) continue;
                this.selected.add(ent);
                continue;
            }
            if ((e.getModifiersEx() & 0x80) == 128 || !ent.isSelected()) continue;
            ent.setSelected(false);
            this.selected.remove(ent);
        }
    }

    private void handleSelection(MouseEvent e) {
        if (!this.selecting) {
            this.selecting = true;
            this.selStartPnt = this.convertToZooming(e.getPoint());
        } else {
            this.selEndPnt = this.convertToZooming(e.getPoint());
            this.applySelection(e);
        }
        this.repaint();
    }

    private Point convertToZooming(Point src) {
        src.x = (int)((double)src.x / this.zoomValue);
        src.y = (int)((double)src.y / this.zoomValue);
        return src;
    }

    private void processMouseMovedEvent(MouseEvent e) {
        if (this.searchCon) {
            boolean foundOne = false;
            EntityPlotter foundEntity = null;
            EntityPlotter curEntity = this.hitsEntity(e.getPoint());
            if (curEntity != null && (this.conFrom == null && curEntity.canConnectFrom() || this.conFrom != null && curEntity.canConnectTo())) {
                foundOne = true;
                if (!curEntity.isHighlighted()) {
                    curEntity.highlight(true);
                    foundEntity = curEntity;
                    if (this.latestHighlighted != null && !this.latestHighlighted.equals(curEntity)) {
                        this.latestHighlighted.highlight(false);
                    }
                    this.repaint();
                }
            }
            if (foundEntity != null) {
                this.latestHighlighted = foundEntity;
            }
        }
    }

    public boolean hasMultiSelects() {
        return this.selected.size() > 1;
    }

    public void setEntitiesWidth() {
        if (this.selected.size() > 1) {
            EntityPlotter lastEntity = this.selected.lastElement();
            for (EntityPlotter ent : this.selected) {
                ent.setWidth(lastEntity.getWidth());
                this.undoActions.add(new ActionResizeEntity(ent, ent.getWidth(), 1));
            }
            this.repaint();
        }
    }

    public void setEntitiesHeight() {
        if (this.selected.size() > 1) {
            EntityPlotter lastEntity = this.selected.lastElement();
            for (EntityPlotter ent : this.selected) {
                ent.setHeight(lastEntity.getHeight());
                this.undoActions.add(new ActionResizeEntity(ent, ent.getHeight(), 2));
            }
            this.repaint();
        }
    }

    public void alignEntities(int direction) {
        if (this.selected.size() > 1) {
            switch (direction) {
                case 1: {
                    this.alignToTop();
                    break;
                }
                case 3: {
                    this.alignToRight();
                    break;
                }
                case 5: {
                    this.alignToCenterHorizontal();
                    break;
                }
                case 6: {
                    this.alignToCenterVertical();
                    break;
                }
                case 2: {
                    this.alignToLeft();
                    break;
                }
                case 4: {
                    this.alignToButtom();
                    break;
                }
                case 7: {
                    if (this.selected.size() < 2) break;
                    this.horizontalSpacing();
                    break;
                }
                case 8: {
                    if (this.selected.size() < 2) break;
                    this.verticalSpacing();
                    break;
                }
                case 9: {
                    if (this.selected.size() < 2) break;
                    this.alignAsStair(true);
                    break;
                }
                case 10: {
                    if (this.selected.size() < 2) break;
                    this.alignAsStair(false);
                }
            }
            this.repaint();
        }
    }

    private void alignAsStair(boolean right) {
        Collections.sort(this.selected, new Comparator<EntityPlotter>(){

            @Override
            public int compare(EntityPlotter ent1, EntityPlotter ent2) {
                return ent1.getY() - ent2.getY();
            }
        });
        EntityPlotter ent1 = this.selected.get(0);
        EntityPlotter ent2 = this.selected.get(1);
        int space = -1;
        space = ent1.getY() > ent2.getY() ? ent1.getY() - (ent2.getY() + ent2.getHeight()) : ent2.getY() - (ent1.getY() + ent1.getHeight());
        if (space <= 0) {
            space = 5;
            ent1 = this.selected.lastElement();
        }
        if (space > 0) {
            LOG.info((Object)("Space is " + space));
            int curYPos = ent1.getY();
            int curXPos = ent1.getX();
            for (int i = 0; i < this.selected.size(); ++i) {
                EntityPlotter ent = this.selected.get(i);
                this.undoActions.add(new ActionDoubleAlignEntity(ent, ent.getY(), ent.getX(), right ? 9 : 10));
                ent.setY(curYPos);
                ent.setX(curXPos);
                curYPos += ent.getHeight() + space;
                curXPos += (right ? 1 : -1) * ent.getWidth() / 3;
            }
        }
    }

    private void alignToCenterVertical() {
        EntityPlotter lastEntity = this.selected.lastElement();
        int midPoint = lastEntity.getY() + lastEntity.getHeight() / 2;
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            int curMidPoint = ent.getY() + ent.getHeight() / 2;
            int newY = ent.getY() + midPoint - curMidPoint;
            this.undoActions.add(new ActionAlignEntity(ent, ent.getY(), 1));
            ent.setY(newY);
        }
    }

    private void horizontalSpacing() {
        Collections.sort(this.selected, new Comparator<EntityPlotter>(){

            @Override
            public int compare(EntityPlotter ent1, EntityPlotter ent2) {
                return ent1.getX() - ent2.getX();
            }
        });
        EntityPlotter ent1 = this.selected.get(0);
        EntityPlotter ent2 = this.selected.get(1);
        int space = -1;
        space = ent1.getX() > ent2.getX() ? ent1.getX() - (ent2.getX() + ent2.getWidth()) : ent2.getX() - (ent1.getX() + ent1.getWidth());
        if (space > 0) {
            int curPos = ent2.getX() + ent2.getWidth() + space;
            for (int i = 2; i < this.selected.size(); ++i) {
                EntityPlotter ent = this.selected.get(i);
                this.undoActions.add(new ActionAlignEntity(ent, ent.getX(), 7));
                ent.setX(curPos);
                curPos += ent.getWidth() + space;
            }
        }
    }

    private void verticalSpacing() {
        Collections.sort(this.selected, new Comparator<EntityPlotter>(){

            @Override
            public int compare(EntityPlotter ent1, EntityPlotter ent2) {
                return ent1.getY() - ent2.getY();
            }
        });
        EntityPlotter ent1 = this.selected.get(0);
        EntityPlotter ent2 = this.selected.get(1);
        int space = -1;
        space = ent1.getY() > ent2.getY() ? ent1.getY() - (ent2.getY() + ent2.getHeight()) : ent2.getY() - (ent1.getY() + ent1.getHeight());
        if (space > 0) {
            int curPos = ent2.getY() + ent2.getHeight() + space;
            for (int i = 2; i < this.selected.size(); ++i) {
                EntityPlotter ent = this.selected.get(i);
                this.undoActions.add(new ActionAlignEntity(ent, ent.getY(), 7));
                ent.setY(curPos);
                curPos += ent.getHeight() + space;
            }
        }
    }

    private void alignToCenterHorizontal() {
        EntityPlotter lastEntity = this.selected.lastElement();
        int midPoint = lastEntity.getX() + lastEntity.getWidth() / 2;
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            int curMidPoint = ent.getX() + ent.getWidth() / 2;
            int newX = ent.getX() + midPoint - curMidPoint;
            this.undoActions.add(new ActionAlignEntity(ent, ent.getX(), 1));
            ent.setX(newX);
        }
    }

    private void alignToTop() {
        EntityPlotter lastEntity = this.selected.lastElement();
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            this.undoActions.add(new ActionAlignEntity(ent, ent.getY(), 1));
            ent.setY(lastEntity.getY());
        }
    }

    private void alignToLeft() {
        EntityPlotter lastEntity = this.selected.lastElement();
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            this.undoActions.add(new ActionAlignEntity(ent, ent.getX(), 2));
            ent.setX(lastEntity.getX());
        }
    }

    private void alignToButtom() {
        EntityPlotter lastEntity = this.selected.lastElement();
        int buttom = lastEntity.getY() + lastEntity.getHeight();
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            int newY = buttom - ent.getHeight();
            this.undoActions.add(new ActionAlignEntity(ent, ent.getY(), 4));
            ent.setY(newY);
        }
    }

    private void alignToRight() {
        EntityPlotter lastEntity = this.selected.lastElement();
        int right = lastEntity.getX() + lastEntity.getWidth();
        for (EntityPlotter ent : this.selected) {
            if (ent == lastEntity) continue;
            int newX = right - ent.getWidth();
            this.undoActions.add(new ActionAlignEntity(ent, ent.getX(), 3));
            ent.setX(newX);
        }
    }

    private EntityPlotter hitsEntity(Point p) {
        p.x = (int)((double)p.x / this.zoomValue);
        p.y = (int)((double)p.y / this.zoomValue);
        for (EntityPlotter curEntity : this.entities.values()) {
            if (!curEntity.isVisible() || !curEntity.getBounds().contains(p)) continue;
            return curEntity;
        }
        return null;
    }

    public void trim() {
        Rectangle2D visRect = this.getVisibleDiagramBounds();
        this.shiftEntities((int)visRect.getX(), (int)visRect.getY(), false);
        this.setSize((int)visRect.getWidth() + 10, (int)visRect.getHeight() + 10);
        this.repaint();
    }

    private void shiftEntities(int dx, int dy, boolean forward) {
        dx *= forward ? 1 : -1;
        dy *= forward ? 1 : -1;
        for (EntityPlotter curEnt : this.entities.values()) {
            curEnt.setPosition(new Point(curEnt.getX() + dx, curEnt.getY() + dy));
        }
    }

    public void clearAll() {
        this.entities.clear();
        this.conectors.removeAllElements();
        this.selected.removeAllElements();
        this.undoActions.removeAllElements();
        this.draggedEntity = null;
        this.latestHighlighted = null;
        this.conFrom = null;
        this.manager = this.createManager();
        this.draggedCon = null;
        this.curSize = new Dimension(10, 10);
        this.curVisRect = new Rectangle();
        this.prevPanelRect = new Rectangle();
        this.inDrag = false;
        this.inConDrag = false;
        this.searchCon = false;
        this.inDeleteMode = false;
        this.allowMultiSelection = true;
        this.allowEntityDelete = true;
        this.doAutoLayout = true;
        this.firstTimeCreation = true;
        this.showToolbar = true;
        this.processMode = 0;
    }

    private void checkScrolling(Point p, EntityPlotter ent) {
        EntityPlotter checkEnt;
        if (this.checkSize()) {
            this.repaint();
        }
        if ((checkEnt = this.draggedEntity) == null && this.selected.size() > 0) {
            checkEnt = this.selected.get(0);
        }
        if (checkEnt != null && checkEnt.getX() >= 0 && checkEnt.getY() >= 0) {
            Rectangle rect = checkEnt.getBounds().getBounds();
            if (this.zoomValue == 1.0) {
                this.scrollRectToVisible(rect);
            }
        }
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.curVisRect;
    }

    public boolean exportAsImage(File destFile, String format) {
        try {
            BufferedImage off_Image = this.exportImage();
            return ImageIO.write((RenderedImage)off_Image, format, destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public BufferedImage exportImage() {
        Dimension visSize = this.getVisibleDiagramSize();
        BufferedImage off_Image = new BufferedImage(visSize.width + 10, visSize.height + 10, 2);
        Graphics2D g2 = off_Image.createGraphics();
        this.exportingImage = true;
        this.paint(g2);
        this.exportingImage = false;
        g2.dispose();
        return off_Image;
    }

    public BufferedImage[] exportImage(int pwidth, int pheight) {
        BufferedImage big_Image = this.exportImage();
        Dimension visSize = this.getVisibleDiagramSize();
        int colCount = (int)Math.ceil(visSize.getWidth() / (double)pwidth);
        int rowCount = (int)Math.ceil(visSize.getHeight() / (double)pheight);
        int totalNumber = rowCount * colCount;
        if (totalNumber == 1) {
            return new BufferedImage[]{big_Image};
        }
        BufferedImage[] images = new BufferedImage[totalNumber];
        int totalCounter = 0;
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                int x = col * pwidth;
                int y = row * pheight;
                int partWidth = pwidth;
                int partHeight = pheight;
                if (x + pwidth > visSize.width) {
                    partWidth = visSize.width - x;
                }
                if (y + pheight > visSize.height) {
                    partHeight = visSize.height - y;
                }
                Rectangle partRect = new Rectangle(x, y, partWidth, partHeight);
                BufferedImage pageImg = new BufferedImage(partWidth, partHeight, 2);
                Graphics2D newg = pageImg.createGraphics();
                newg.drawImage(big_Image, 0, 0, partWidth, partHeight, x, y, x + partWidth, y + partHeight, null);
                newg.dispose();
                images[totalCounter++] = pageImg;
            }
        }
        return images;
    }

    public void print() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPrintable(new Printable(){

                        @Override
                        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
                            GUIPlotter.this.exportingImage = true;
                            ((Graphics2D)g).translate(pf.getImageableX(), pf.getImageableY());
                            GUIPlotter.this.paint(g);
                            GUIPlotter.this.exportingImage = false;
                            return 0;
                        }
                    });
                    boolean doPrint = job.printDialog();
                    if (doPrint) {
                        job.print();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    public void paintComponent(Graphics gr) {
        if (this.entities == null || this.entities.size() == 0) {
            super.paintComponent(gr);
            return;
        }
        super.paintComponent(gr);
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHints(this.qualityHints);
        g.scale(this.zoomValue, this.zoomValue);
        Rectangle gRect = g.getClipBounds();
        if (!this.exportingImage) {
            if (this.firstTimeCreation) {
                LOG.info((Object)"***** Paint ******** In first time creation ");
                if (this.doAutoLayout) {
                    LOG.info((Object)"***** Paint ******** Doing Auto Layout");
                    for (EntityPlotter curEntity : this.entities.values()) {
                        curEntity.calibrate(g);
                    }
                    this.manager.doLayout(this.entities, this.conectors);
                } else if (this.presetLayout != null) {
                    LOG.info((Object)"***** Paint ******** Importing");
                    this.importLayout(this.presetLayout);
                }
                this.firstTimeCreation = false;
            } else if (!this.prevPanelRect.getSize().equals(gRect.getSize()) && this.doAutoLayout) {
                LOG.info((Object)"Graphics bounds changed doing an automatic layout .....");
                this.manager.setInitWidth(gRect.width);
                this.manager.setInitHeight(gRect.height);
                this.manager.doLayout(this.entities, this.conectors);
                this.prevPanelRect = gRect;
            }
            boolean sizeDetected = false;
            this.checkSize();
            this.paintBackground(g);
        }
        if (this.showConnectedEntities) {
            this.drawAllConnections(g);
            for (EntityPlotter curEntity : this.entities.values()) {
                if (!curEntity.isVisible() || !curEntity.isTransperant()) continue;
                curEntity.plot(g);
            }
        } else {
            this.drawConnections(g);
        }
        int originalWidth = this.curSize.width;
        int originalHeight = this.curSize.height;
        int calcWidth = this.curSize.width;
        int calcHeight = this.curSize.height;
        if (this.showConnectedEntities) {
            for (EntityPlotter curEntity : this.entities.values()) {
                if (!curEntity.isVisible() || curEntity.isTransperant()) continue;
                curEntity.plot(g);
            }
        } else {
            for (EntityPlotter curEntity : this.entities.values()) {
                if (!curEntity.isVisible()) continue;
                curEntity.plot(g);
            }
        }
        if (this.showToolbar) {
            this.tools.plot(10, 10, g);
        }
        if (this.selecting && this.selStartPnt != null && this.selEndPnt != null) {
            this.paintSelection(g);
        }
    }

    private void paintBackground(Graphics2D g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.curSize.width, this.curSize.height);
        g.drawImage((Image)this.compLogo.getReflectImg(), 20, 21 + this.compLogo.getHeight(), null);
        g.drawImage((Image)this.compLogo.getLogoImg(), 20, 20, null);
    }

    private void paintSelection(Graphics2D g) {
        Shape sel = this.constructSelectionShape();
        g.setColor(this.selectionBG);
        g.fill(sel);
        g.setColor(this.selectionBR);
        g.setStroke(this.selStroke);
        g.draw(sel);
        if (this.selRect.width > 50.0f && this.selRect.height > 30.0f) {
            g.setColor(this.selTextColor);
            g.setFont(this.selFont);
            g.drawString("SMYLD", this.selRect.x + 5.0f, this.selRect.y + 20.0f);
        }
    }

    private Shape constructSelectionShape() {
        Point frm = this.selStartPnt;
        Point to = this.selEndPnt;
        this.selRect.width = Math.abs(this.selStartPnt.x - this.selEndPnt.x);
        this.selRect.height = Math.abs(this.selStartPnt.y - this.selEndPnt.y);
        this.selRect.x = this.selStartPnt.x > this.selEndPnt.x ? (float)this.selEndPnt.x : (float)this.selStartPnt.x;
        this.selRect.y = this.selStartPnt.y > this.selEndPnt.y ? (float)this.selEndPnt.y : (float)this.selStartPnt.y;
        return this.selRect;
    }

    private boolean checkSize() {
        Dimension contSize = this.getVisibleDiagramSize();
        contSize.setSize((double)contSize.width * this.zoomValue, (double)contSize.height * this.zoomValue);
        if (this.sccontainer != null) {
            Dimension scSize = this.sccontainer.getVisibleRect().getSize();
            if (scSize.width > contSize.width) {
                contSize.width = scSize.width;
            }
            if (scSize.height > contSize.height) {
                contSize.height = scSize.height;
            }
        }
        if (!this.curSize.equals(contSize)) {
            this.curSize.setSize(contSize);
            this.setSize(this.curSize);
            return true;
        }
        return false;
    }

    public void doAutomaticLayout() {
        for (EntityPlotter ent : this.entities.values()) {
            ent.setPosition(new Point(0, 0));
        }
        this.trim();
        this.doAutoLayout = false;
        this.createManager().doLayout(this.entities, this.conectors, true);
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.curSize;
    }

    protected EntityPlotLayoutManager createManager() {
        return new EntityPlotLayoutManager();
    }

    private void drawAllConnections(Graphics2D g) {
        if (this.connDraw) {
            this.connPlotter.setInfo(this.entities, this.conectors, this.undoActions);
            this.connPlotter.drawAllConnections(g);
        }
    }

    private void drawTransConnections(Graphics2D g) {
        if (this.connDraw) {
            this.connPlotter.setInfo(this.entities, this.conectors, this.undoActions);
            this.connPlotter.drawTransperantConnections(g);
        }
    }

    private void drawNonTransConnections(Graphics2D g) {
        if (this.connDraw) {
            this.connPlotter.setInfo(this.entities, this.conectors, this.undoActions);
            this.connPlotter.drawNonTransperantConnections(g);
        }
    }

    private void drawConnections(Graphics2D g) {
        if (this.connDraw) {
            this.connPlotter.setInfo(this.entities, this.conectors, this.undoActions);
            this.connPlotter.drawConnections(g);
        }
    }

    private void drawToolBar(Graphics2D g) {
        g.setColor(Color.LIGHT_GRAY);
        g.fillRoundRect(5, 5, 200, 30, 5, 5);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRoundRect(5, 5, 200, 30, 5, 5);
        g.setColor(Color.YELLOW);
        g.fillRoundRect(15, 15, 5, 5, 2, 2);
        g.fillRoundRect(25, 25, 5, 5, 2, 2);
        g.setColor(Color.WHITE);
        g.drawLine(20, 20, 25, 25);
    }

    public void delete(EntityPlotter entity) {
        if (this.allowEntityDelete) {
            entity.setVisible(false);
            entity.setSelected(false);
            this.undoActions.add(new ActionDelEntity(entity));
            if (this.listener != null) {
                this.listener.entityDeleted(entity);
            }
            this.repaint();
        }
    }

    public void delete(String entityID) {
        EntityPlotter entity;
        if (this.allowEntityDelete && (entity = this.entities.get(entityID)) != null) {
            entity.setVisible(false);
            entity.setSelected(false);
            this.undoActions.add(new ActionDelEntity(entity));
            if (this.listener != null) {
                this.listener.entityDeleted(entity);
            }
            this.repaint();
        }
    }

    public void addEntity(String id, EntityPlotter newEntity) {
        if (this.entities.containsKey(id)) {
            EntityPlotter old = this.entities.get(id);
            old.setUserObject(newEntity.getUserObject());
            old.setType(newEntity.getType());
            old.setContents(newEntity.getContents());
            old.setTitle(newEntity.getTitle());
            old.setVisible(true);
            if (this.entGUIConfs.containsKey(newEntity.getType())) {
                old.adjustToGUIConfigInfo(this.entGUIConfs.get(newEntity.getType()));
            }
        } else {
            if (this.entGUIConfs.containsKey(newEntity.getType())) {
                newEntity.adjustToGUIConfigInfo(this.entGUIConfs.get(newEntity.getType()));
            }
            this.entities.put(id, newEntity);
        }
        this.undoActions.add(new ActionAddEntity(newEntity));
        this.repaint();
    }

    private void deleteConnectorsForEntity(EntityPlotter ent) {
        if (ent.canConnectFrom()) {
            for (EntityPlotter curEnt : ent.getConnectedEntities().values()) {
                this.deleteConnector(ent, curEnt);
            }
        } else {
            for (EntityPlotter curEnt : ent.getConnectedEntities().values()) {
                this.deleteConnector(curEnt, ent);
            }
        }
    }

    private void processEntityConnection(EntityConnector con, Graphics2D g) {
        if (!con.from.isVisible() || !con.to.isVisible()) {
            return;
        }
        con.drawLine(g);
    }

    private boolean onRight(Rectangle2D from, Rectangle2D to) {
        return from.getX() > to.getX() + to.getWidth();
    }

    private boolean onLeft(Rectangle2D from, Rectangle2D to) {
        return from.getX() + from.getWidth() < to.getX();
    }

    private boolean onTop(Rectangle2D from, Rectangle2D to) {
        return from.getY() + from.getHeight() < to.getY();
    }

    private boolean onBut(Rectangle2D from, Rectangle2D to) {
        return from.getY() > to.getY() + to.getHeight();
    }

    public void connectEntities(EntityPlotter from, EntityPlotter to) {
        if (this.controller != null) {
            Color conColor = this.controller.getEntitiesConnectionColor(from, to);
            if (conColor != null) {
                this.connectEntities(from, to, conColor);
            }
        } else {
            this.connectEntities(from, to, from.getConnectorColor());
        }
    }

    public void addController(EntityPlotController controller) {
        this.controller = controller;
        this.connPlotter.addController(controller);
    }

    public void connectEntities(EntityPlotter from, EntityPlotter to, Color conColor, String commentText) {
        if (!this.alreadyExistingConnector(from, to, conColor, commentText)) {
            EntityConnector newConn = this.createConnector(from, to, conColor, commentText);
            this.conectors.add(newConn);
            this.undoActions.add(new ActionAddConnection(newConn));
            from.newConnection(newConn);
            to.newConnection(newConn);
            if (this.listener != null) {
                this.listener.entityConnected(from, to);
            }
        }
    }

    protected boolean alreadyExistingConnector(EntityPlotter from, EntityPlotter to, Color conColor, String commentText) {
        boolean alreadyExists = false;
        for (EntityConnector con : this.conectors) {
            if (!con.connects(from, to)) continue;
            con.setDeactivated(false);
            con.setConColor(conColor);
            if (commentText != null) {
                con.setCommentText(commentText);
            }
            if (this.listener != null) {
                this.listener.entityConnected(from, to);
            }
            alreadyExists = true;
        }
        return alreadyExists;
    }

    public void connectEntities(EntityPlotter from, EntityPlotter to, Color conColor) {
        if (!this.alreadyExistingConnector(from, to, conColor, null)) {
            EntityConnector newConn = this.createConnector(from, to, conColor);
            this.conectors.add(newConn);
            this.undoActions.add(new ActionAddConnection(newConn));
            from.newConnection(newConn);
            to.newConnection(newConn);
            if (this.listener != null) {
                this.listener.entityConnected(from, to);
            }
        }
    }

    protected EntityConnector createConnector(EntityPlotter from, EntityPlotter to, Color conColor) {
        return new OrthogonalEntityConnector(from, to, from.getConnectorSize(), conColor);
    }

    protected EntityConnector createConnector(EntityPlotter from, EntityPlotter to, Color conColor, String commentText) {
        return new OrthogonalEntityConnector(from, to, from.getConnectorSize(), conColor, commentText);
    }

    protected void deleteConnector(EntityConnector target) {
        target.from.removeConnection(target);
        target.to.removeConnection(target);
        for (EntityConnector con : this.conectors) {
            if (!con.equals(target)) continue;
            con.setDeactivated(true);
            if (this.listener != null) {
                this.listener.entityDisconnected(target.from, target.to);
            }
            this.undoActions.add(new ActionDelConnection(con));
            this.repaint();
            return;
        }
    }

    public void deleteConnector(EntityPlotter from, EntityPlotter to) {
        EntityConnector target = null;
        for (EntityConnector con : this.conectors) {
            if (!con.connects(from, to)) continue;
            target = con;
            break;
        }
        if (target != null) {
            this.deleteConnector(target);
        }
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean showToolbar) {
        this.showToolbar = showToolbar;
    }

    protected EntityConnector getConnectorFor(EntityPlotter from, EntityPlotter to) {
        for (EntityConnector curCon : this.conectors) {
            if (!curCon.connects(from, to)) continue;
            return curCon;
        }
        return null;
    }

    public String getPresetLayout() {
        return this.presetLayout;
    }

    public void setPresetLayout(String presetLayout) {
        this.firstTimeCreation = true;
        this.doAutoLayout = false;
        this.presetLayout = presetLayout;
    }

    public void setGUIConfig(HashMap<Integer, String> conf) {
        this.entGUIConfs = conf;
    }

    public String composeGUIConfig(HashMap<Integer, String> conf) {
        StringBuilder sb = new StringBuilder();
        for (String curConf : conf.values()) {
            sb.append(curConf);
            sb.append("~~");
        }
        return sb.toString();
    }

    public HashMap<Integer, String> parseGUIConfig(String guiConfig) {
        String[] confs;
        HashMap<Integer, String> parsed = null;
        if (guiConfig != null && (confs = guiConfig.split("~~")) != null && confs.length > 0) {
            parsed = new HashMap<Integer, String>();
            for (String curConf : confs) {
                if (curConf == null || curConf.isEmpty()) continue;
                String entTypeText = curConf.substring(0, curConf.indexOf("|"));
                parsed.put(Integer.parseInt(entTypeText), curConf.substring(curConf.indexOf("|") + 1));
            }
        }
        return parsed;
    }

    public void setGUIConfig(String guiConfig) {
        this.firstTimeCreation = true;
        this.entGUIConfs = this.parseGUIConfig(guiConfig);
    }

    public boolean isShowConnectedEntities() {
        return this.showConnectedEntities;
    }

    public void setShowConnectedEntities(boolean showConnectedEntities) {
        if (this.showConnectedEntities == showConnectedEntities) {
            return;
        }
        this.showConnectedEntities = showConnectedEntities;
        if (!showConnectedEntities) {
            for (EntityPlotter ent : this.entities.values()) {
                ent.setTransperant(false);
            }
        } else {
            for (EntityPlotter ent : this.entities.values()) {
                ent.setEntityTransperancy(this.showConTransp);
            }
        }
        this.repaint();
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    public void setAnimationActive(boolean animationActive) {
        this.animationActive = animationActive;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.curSize;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int maxUnitIncrement = 200;
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / maxUnitIncrement * maxUnitIncrement;
            return newPosition == 0 ? maxUnitIncrement : newPosition;
        }
        return (currentPosition / maxUnitIncrement + 1) * maxUnitIncrement - currentPosition;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int maxUnitIncrement = 200;
        if (orientation == 0) {
            return visibleRect.width - maxUnitIncrement;
        }
        return visibleRect.height - maxUnitIncrement;
    }

    protected boolean containsCommentedConnection(EntityPlotter ent, String comment, boolean from) {
        return this.getCommentedConnection(ent, comment, from) != null;
    }

    protected EntityConnector getCommentedConnection(EntityPlotter ent, String comment, boolean from) {
        if (ent != null && ent.getConnections() != null && ent.getConnections().size() > 0) {
            for (EntityConnector curCon : ent.getConnections()) {
                if (curCon.getCommentText() == null || !curCon.getCommentText().equals(comment) || !(from ? curCon.getFrom().getId().equals(ent.getId()) : curCon.getTo().getId().equals(ent.getId()))) continue;
                return curCon;
            }
        }
        return null;
    }

    class Toolbar {
        int selectedTool = 1;
        int x;
        int y;
        boolean activateAddCon = false;
        boolean activateDelCon = false;

        Toolbar() {
        }

        public void plot(int x, int y, Graphics2D g) {
            this.x = x;
            this.y = y;
            g.setColor(Color.LIGHT_GRAY);
            g.fillRoundRect(x + 5, y + 5, 200, 30, 5, 5);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(2.0f));
            g.drawRoundRect(x + 5, y + 5, 200, 30, 5, 5);
            g.setColor(this.activateAddCon ? Color.YELLOW : Color.RED);
            g.fillRoundRect(x + 10, y + 10, 5, 5, 2, 2);
            g.fillRoundRect(x + 25, y + 25, 5, 5, 2, 2);
            g.setColor(Color.WHITE);
            g.setColor(this.activateAddCon ? Color.WHITE : Color.BLUE);
            g.drawLine(x + 15, y + 15, x + 25, y + 25);
            g.setColor(this.activateDelCon ? Color.YELLOW : Color.RED);
            g.fillRoundRect(x + 50, y + 10, 5, 5, 2, 2);
            g.fillRoundRect(x + 65, y + 25, 5, 5, 2, 2);
            g.setColor(Color.WHITE);
            g.setColor(this.activateDelCon ? Color.WHITE : Color.BLUE);
            g.drawLine(x + 55, y + 15, x + 65, y + 25);
            g.setColor(this.activateDelCon ? Color.WHITE : Color.BLACK);
            g.drawLine(x + 57, y + 15, x + 63, y + 25);
            g.drawLine(x + 57, y + 25, x + 63, y + 15);
        }

        public boolean hitsTool(Point p) {
            if (p.x >= this.x + 10 && p.x <= this.x + 30 && p.y >= this.y + 10 && p.y <= this.y + 30) {
                this.selectedTool = 1;
                this.activateAddCon = !this.activateAddCon;
                this.activateDelCon = false;
                GUIPlotter.this.repaint();
                return true;
            }
            if (p.x >= this.x + 50 && p.x <= this.x + 70 && p.y >= this.y + 10 && p.y <= this.y + 30) {
                this.selectedTool = 2;
                this.activateDelCon = !this.activateDelCon;
                this.activateAddCon = false;
                GUIPlotter.this.repaint();
                return true;
            }
            return false;
        }

        public void activateAddCon(boolean activate) {
            this.activateAddCon = activate;
        }

        public int getSelectedTool() {
            return this.selectedTool;
        }

        public boolean isSelecteToolActive() {
            switch (this.selectedTool) {
                case 1: {
                    return this.activateAddCon;
                }
                case 2: {
                    return this.activateDelCon;
                }
            }
            return false;
        }
    }
}

