/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.Color;
import java.awt.GradientPaint;

public class GradientPlot {
    Color fromColor;
    Color toColor;
    int width;
    int height;
    GradientDirection direction;
    GradientType type;

    public GradientPlot() {
    }

    public GradientPlot(Color from, Color to) {
        this.setFromColor(from);
        this.setToColor(to);
    }

    public GradientPaint generate() {
        return this.generate(0, 0, this.width, this.height);
    }

    public GradientPaint generate(int x, int y, int width, int height) {
        int startX = x;
        int startY = y;
        int endX = x;
        int endY = y;
        switch (this.direction) {
            case LeftToRight: {
                startY = endY = y + height / 2;
                endX += width;
                break;
            }
            case RightToLeft: {
                startY = endY = y + height / 2;
                startX += width;
                break;
            }
            case TopToButtom: {
                endY = y + height;
                startX = endX = x + width / 2;
                break;
            }
            case ButtomToTop: {
                startY = y + height;
                startX = endX = x + width / 2;
                break;
            }
            case Free: {
                endX = width;
                endY = height;
            }
        }
        return new GradientPaint(startX, startY, this.fromColor, endX, endY, this.toColor);
    }

    public Color getFromColor() {
        return this.fromColor;
    }

    public void setFromColor(Color fromColor) {
        this.fromColor = fromColor;
    }

    public Color getToColor() {
        return this.toColor;
    }

    public void setToColor(Color toColor) {
        this.toColor = toColor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public GradientDirection getDirection() {
        return this.direction;
    }

    public void setDirection(GradientDirection direction) {
        this.direction = direction;
    }

    public GradientType getType() {
        return this.type;
    }

    public void setType(GradientType type) {
        this.type = type;
    }

    public static enum GradientType {
        Linear,
        BiLinear;

    }

    public static enum GradientDirection {
        RightToLeft,
        LeftToRight,
        TopToButtom,
        ButtomToTop,
        Free;

    }
}

