/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class MyPanel
extends JPanel {
    private int squareX = 50;
    private int squareY = 50;
    private int squareW = 20;
    private int squareH = 20;

    public MyPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MyPanel.this.moveSquare(e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MyPanel.this.moveSquare(e.getX(), e.getY());
            }
        });
    }

    private void moveSquare(int x, int y) {
        boolean OFFSET = true;
        if (this.squareX != x || this.squareY != y) {
            this.squareX = x;
            this.squareY = y;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 200);
    }

    @Override
    protected void paintComponent(Graphics gr) {
        int i;
        Graphics2D g = (Graphics2D)gr;
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BufferedImage img = new BufferedImage(220, 220, 2);
        Graphics2D graph = img.createGraphics();
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintSingleOn(10, 220, graph);
        int smX = 30;
        int smY = 22;
        Image sm = img.getScaledInstance(smX, smY, 4);
        AffineTransform rot = AffineTransform.getRotateInstance(Math.toRadians(90.0), 11.0, 15.0);
        BufferedImage vm = new BufferedImage((int)((double)smY * 1.2), (int)((double)smX * 1.2), 2);
        Graphics2D gvm = vm.createGraphics();
        gvm.drawImage(sm, rot, null);
        gvm.translate(-11, -15);
        gvm.dispose();
        int xpos = 50;
        int ypos = 50;
        for (i = 0; i < 20; ++i) {
            g.drawImage(sm, xpos, ypos, smX, smY, null);
            xpos += (int)((double)smX * 0.65);
        }
        xpos += (int)((double)smX * 0.2);
        ypos = (int)((double)ypos + (double)smX / 1.8);
        for (i = 0; i < 20; ++i) {
            g.drawImage(vm, xpos, ypos, smY, smX, null);
            if (i >= 20) continue;
            ypos += (int)((double)smY * 0.75);
        }
        g.dispose();
    }

    private void paintSingleOn(int px, int py, Graphics2D g) {
        this.paintLowerOn(px, py, g);
        this.paintUpperOn(px + 100, py - 100, g);
        g.dispose();
    }

    private void paintLowerOn(int px, int py, Graphics2D g) {
        g.setStroke(new BasicStroke(8.0f));
        g.setColor(Color.BLACK);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(px, py);
        gp.curveTo(px + 20, py - 100, px + 80, py - 50, px + 100, py - 100);
        gp.curveTo(px + 120, py - 50, px + 180, py - 100, px + 200, py);
        gp.closePath();
        g.draw(gp);
        g.setStroke(new BasicStroke(6.0f));
        gp = new GeneralPath();
        gp.moveTo(px += 60, py);
        gp.curveTo(px + 10, py - 100, px + 30, py - 50, px + 40, py - 100);
        gp.curveTo(px + 50, py - 50, px + 70, py - 100, px + 80, py);
        g.draw(gp);
        gp = new GeneralPath();
        gp.moveTo(px += 40, py - 10);
        gp.quadTo(px - 20, py - 35, px, py - 60);
        gp.quadTo(px + 20, py - 35, px, py - 10);
        g.setColor(Color.RED);
        g.fill(gp);
        g.setColor(Color.BLACK);
        g.draw(gp);
    }

    private void paintUpperOn(int px, int py, Graphics2D g) {
        g.setStroke(new BasicStroke(4.0f));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(px, py);
        gp.quadTo(px, py - 40, px - 40, py - 40);
        gp.quadTo(px - 20, py - 50, px - 40, py - 60);
        gp.quadTo(px, py - 60, px, py - 100);
        gp.quadTo(px, py - 60, px + 40, py - 60);
        gp.quadTo(px + 20, py - 50, px + 40, py - 40);
        gp.quadTo(px, py - 40, px, py);
        g.draw(gp);
        Color[] maincolors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY};
        float[] mainDist = new float[]{0.0f, 0.9f};
        g.setPaint(new RadialGradientPaint(px, (float)(py - 50), 40.0f, mainDist, maincolors));
        g.fill(gp);
        Color[] colors = new Color[]{Color.YELLOW, Color.RED};
        float[] dist = new float[]{0.0f, 0.9f};
        g.setPaint(new RadialGradientPaint(px - 40, (float)(py - 50), 10.0f, dist, colors));
        Ellipse2D.Float cir = new Ellipse2D.Float(px - 50, py - 60, 20.0f, 20.0f);
        g.fill(cir);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.DARK_GRAY);
        g.draw(cir);
        g.setPaint(new RadialGradientPaint(px + 40, (float)(py - 50), 10.0f, dist, colors));
        cir = new Ellipse2D.Float(px + 30, py - 60, 20.0f, 20.0f);
        g.fill(cir);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.DARK_GRAY);
        g.draw(cir);
        cir = new Ellipse2D.Float(px - 10, py - 70, 20.0f, 40.0f);
        g.setPaint(new RadialGradientPaint(px - 4, (float)(py - 70), 24.0f, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        g.fill(cir);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.DARK_GRAY);
        g.draw(cir);
        gp = new GeneralPath();
        gp.moveTo(px - 20, py - 120);
        gp.quadTo(px, py - 94, px + 20, py - 120);
        gp.quadTo(px, py - 80, px - 20, py - 120);
        g.setColor(Color.YELLOW);
        g.fill(gp);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.BLACK);
        g.draw(gp);
    }
}

