/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotter;

public class OrthogonalEntityConnector
extends EntityConnector {
    public OrthogonalEntityConnector(EntityPlotter from, EntityPlotter to, int conSize, Color conColor, String commentText) {
        super(from, to, conSize, conColor, commentText);
        this.init();
    }

    public OrthogonalEntityConnector(EntityPlotter from, EntityPlotter to, int conSize, Color conColor) {
        super(from, to, conSize, conColor);
        this.init();
    }

    public OrthogonalEntityConnector(EntityPlotter from, EntityPlotter to, int conSize) {
        super(from, to, conSize);
        this.init();
    }

    private void init() {
        this.category = EntityConnector.ConnectionCategory.Orthogonal;
    }

    @Override
    protected void detectEntityConnectionPoints() {
        Rectangle2D frmRect = this.from.getBounds();
        Rectangle2D toRect = this.to.getBounds();
        this.frmPos = 6;
        this.toPos = 5;
        if (this.onMidTop(frmRect, toRect)) {
            this.frmPos = 7;
            this.toPos = 1;
            if (this.onMidRight(frmRect, toRect)) {
                this.frmPos = 5;
            } else if (this.onMidLeft(frmRect, toRect)) {
                this.frmPos = 6;
            }
        } else if (this.onMidBut(frmRect, toRect)) {
            this.frmPos = 1;
            this.toPos = 7;
            if (this.onMidRight(frmRect, toRect)) {
                this.toPos = 6;
            } else if (this.onMidLeft(frmRect, toRect)) {
                this.toPos = 5;
            }
        } else if (this.onMidRight(frmRect, toRect)) {
            this.frmPos = 5;
            this.toPos = 6;
        }
        Point fromP = this.from.getConnectionPoint(this.frmPos, true);
        Point toP = this.to.getConnectionPoint(this.toPos, true);
        this.setConnectorPoints(fromP, toP);
    }

    @Override
    protected Shape drawOrthogonalLine(Graphics2D g, float p1x, float p1y, float p2x, float p2y) {
        int arr = this.conPointSize;
        GeneralPath path = new GeneralPath(1);
        path.moveTo(p1x, p1y);
        int ysign = p1y > p2y ? 1 : -1;
        int xsign = p1x > p2x ? 1 : -1;
        float bx = p2x;
        float by = p2y;
        int arrSign = 1;
        block0 : switch (this.frmPos) {
            case 5: 
            case 6: {
                switch (this.toPos) {
                    case 5: 
                    case 6: {
                        if (p1y != p2y) {
                            float midX = (p2x - p1x) / 2.0f;
                            path.lineTo(p1x + midX, p1y);
                            path.lineTo(p1x + midX, p2y);
                        }
                        bx += (float)(arrSign * (this.toPos == 6 ? 1 : -1));
                        break;
                    }
                    case 1: 
                    case 7: {
                        if (Math.abs(this.mx) < Math.abs(this.my)) {
                            this.mx = this.fromPoint.x - this.toPoint.x;
                        } else {
                            this.my = 0;
                        }
                        path.lineTo(p2x, p1y);
                        by += (float)(arrSign * (this.toPos == 7 ? 1 : -1));
                    }
                }
                break;
            }
            case 1: 
            case 7: {
                switch (this.toPos) {
                    case 5: 
                    case 6: {
                        if (Math.abs(this.mx) < Math.abs(this.my)) {
                            this.mx = 0;
                        } else {
                            this.my = this.fromPoint.y - this.toPoint.y;
                        }
                        path.lineTo(p1x, p2y);
                        bx += (float)(arrSign * (this.toPos == 6 ? 1 : -1));
                        break block0;
                    }
                    case 1: 
                    case 7: {
                        if (p1x != p2x) {
                            float midY = (p2y - p1y) / 2.0f;
                            path.lineTo(p1x, p1y + midY);
                            path.lineTo(p2x, p1y + midY);
                        }
                        by += (float)(arrSign * (this.frmPos == 7 ? 1 : -1));
                    }
                }
            }
        }
        if (this.showArrow) {
            path.lineTo(bx, by);
            this.drawArrow(g, bx, by, p2x, p2y, 0.0, ysign, xsign);
        } else {
            path.lineTo(p2x, p2y);
        }
        return path;
    }

    @Override
    protected void drawMidRect(Graphics2D g) {
        this.midRect.setLocation(this.fromPoint.x - this.mx - 2, this.fromPoint.y - this.my - 2);
        g.fillRect(this.midRect.x, this.midRect.y, this.midRect.width, this.midRect.height);
    }
}

