/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class TextPlotter {
    Font font = new Font("Newtimes Roman", 1, 10);
    String text;
    Color foreground = Color.BLACK;
    Color background = new Color(237, 232, 153);
    int verticalAlignment;
    int horizontalAlignment;
    int x;
    int y;
    int width;
    int singleLineHeight;
    int height;
    int corner = 8;
    int textLeftMargin = 10;
    int textButtomMargin = 10;
    int textRightMargin = 10;
    int textTopMargin = 4;
    int textLineMargin = 2;
    int borderWidth = 1;
    double totalContentHeight;
    boolean autoExpand = true;
    boolean drawBorder = true;
    boolean drawConnectPoint = true;
    boolean drawBackground = true;
    BasicStroke borderStroke;
    BasicStroke connectStroke;

    public TextPlotter(String text) {
        this.text = text;
        this.init();
    }

    public TextPlotter() {
        this.init();
    }

    private void init() {
        this.borderStroke = new BasicStroke(this.borderWidth, 1, 1);
        this.connectStroke = new BasicStroke(this.borderWidth, 1, 1, 1.0f, new float[]{4.0f, 2.0f, 2.0f, 2.0f}, 0.0f);
    }

    protected void paintContents(Graphics2D g, int connectX, int connectY) {
        String[] conts;
        if (this.drawBackground) {
            g.setColor(this.getBackground());
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.corner, this.corner);
        }
        g.setFont(this.font);
        g.setColor(this.foreground);
        if (this.drawBorder) {
            g.setStroke(this.connectStroke);
            g.drawRoundRect(this.x, this.y, this.width, this.height, this.corner, this.corner);
        }
        if (this.drawConnectPoint) {
            this.drawConnectionPoint(g, connectX, connectY);
        }
        if (this.text != null && (conts = this.text.split("\n")).length >= 1) {
            double singleLineHeight = this.font.getStringBounds(conts[0], g.getFontRenderContext()).getHeight();
            float posY = this.detectContentsFirstLine(g, singleLineHeight, conts.length);
            switch (this.horizontalAlignment) {
                case 1: {
                    for (String curLine : conts) {
                        int txtWidth = (int)this.font.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                        float posX = this.x + (this.width - txtWidth) / 2;
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                    break;
                }
                case 3: {
                    for (String curLine : conts) {
                        double txtWidth = this.font.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                        float posX = (float)((double)(this.x + this.width) - (txtWidth + (double)this.textRightMargin));
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                    break;
                }
                default: {
                    float posX = this.x + this.textLeftMargin + this.borderWidth;
                    for (String curLine : conts) {
                        g.drawString(curLine, posX, posY);
                        posY = (float)((double)posY + (singleLineHeight + 2.0));
                    }
                }
            }
        }
    }

    protected void drawConnectionPoint(Graphics2D g, int connectX, int connectY) {
        g.setStroke(this.connectStroke);
        int upX = this.x;
        int upY = this.y + this.height - this.corner * 2;
        int loX = this.x;
        int loY = this.y + this.height - this.corner;
        if (this.x < connectX) {
            upX = loX = this.x + this.width;
        }
        if (this.y > connectY) {
            loY = this.y + this.corner * 2;
            upY = this.y + this.corner;
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo(connectX, connectY);
        gp.lineTo(upX, upY);
        gp.lineTo(loX, loY);
        gp.closePath();
        g.draw(gp);
    }

    protected float detectContentsFirstLine(Graphics2D g, double singleLineHeight, int lineNo) {
        float posY = 0.0f;
        switch (this.verticalAlignment) {
            case 10: {
                posY = (float)((double)(this.y + this.borderWidth + this.textTopMargin) + singleLineHeight);
                break;
            }
            case 11: {
                posY = (float)((double)(this.y + this.borderWidth + this.height / 2) - this.totalContentHeight / 2.0 + singleLineHeight);
                break;
            }
            case 12: {
                posY = (float)((double)(this.y + this.height) + singleLineHeight - (this.totalContentHeight + (double)this.textButtomMargin));
            }
        }
        return posY;
    }

    public void calibrate(Graphics2D g) {
        String[] conts;
        if (this.text != null && (conts = this.text.split("\n")).length >= 1) {
            double singleLineHeight = this.font.getStringBounds(conts[0], g.getFontRenderContext()).getHeight();
            this.totalContentHeight = (singleLineHeight + (double)this.textLineMargin) * (double)conts.length - (double)this.textLineMargin;
            double maxTextWidth = 0.0;
            Object longestLine = null;
            for (String curLine : conts) {
                double curWidth = this.font.getStringBounds(curLine, g.getFontRenderContext()).getWidth();
                maxTextWidth = curWidth > maxTextWidth ? curWidth : maxTextWidth;
            }
            double totalContentWidth = (double)this.textLeftMargin + maxTextWidth + (double)(2 * this.borderWidth) + (double)this.textRightMargin;
            int addHeight = this.textTopMargin + this.textButtomMargin + 2 * this.borderWidth;
            if ((double)this.height < this.totalContentHeight + (double)addHeight && this.autoExpand) {
                this.setHeight((int)(this.totalContentHeight + (double)addHeight));
            }
            if ((double)this.width < totalContentWidth && this.autoExpand) {
                this.setWidth((int)totalContentWidth);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getTextRightMargin() {
        return this.textRightMargin;
    }

    public void setTextRightMargin(int textRightMargin) {
        this.textRightMargin = textRightMargin;
    }

    public int getTextLeftMargin() {
        return this.textLeftMargin;
    }

    public void setTextLeftMargin(int textLeftMargin) {
        this.textLeftMargin = textLeftMargin;
    }

    public int getTextButtomMargin() {
        return this.textButtomMargin;
    }

    public void setTextButtomMargin(int textButtomMargin) {
        this.textButtomMargin = textButtomMargin;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getTextTopMargin() {
        return this.textTopMargin;
    }

    public void setTextTopMargin(int textTopMargin) {
        this.textTopMargin = textTopMargin;
    }

    public int getTextLineMargin() {
        return this.textLineMargin;
    }

    public void setTextLineMargin(int textLineMargin) {
        this.textLineMargin = textLineMargin;
    }

    public int getSingleLineHeight() {
        return this.singleLineHeight;
    }

    public void setSingleLineHeight(int singleLineHeight) {
        this.singleLineHeight = singleLineHeight;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getTotalContentHeight() {
        return this.totalContentHeight;
    }

    public void setTotalContentHeight(double totalContentHeight) {
        this.totalContentHeight = totalContentHeight;
    }

    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    public void setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
    }
}

