/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot.flowchart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.smyld.app.entityplot.EntityPlotterImpl;
import org.smyld.app.entityplot.GradientPlot;
import org.smyld.app.entityplot.PlotShape;

public class EntityBasicFlowChart
extends EntityPlotterImpl {
    protected GradientPlot bodyGrad = new GradientPlot(new Color(83, 105, 174), new Color(199, 211, 231));
    protected GradientPlot bodyHighlightGrad = new GradientPlot(new Color(180, 32, 32), new Color(221, 136, 136));
    protected GradientPlot bodyConnectedGrad = new GradientPlot(new Color(29, 29, 123), new Color(90, 90, 255));
    protected ChartElement element;

    public EntityBasicFlowChart(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.init();
    }

    public EntityBasicFlowChart(int x, int y, int width, int height, PlotShape shape, Color contentBGColor, Color borderColor, String title) {
        super(x, y, width, height, shape, contentBGColor, borderColor, title);
        this.init();
    }

    public EntityBasicFlowChart(int x, int y, int width, int height, PlotShape shape, Color contentBGColor, Color borderColor) {
        super(x, y, width, height, shape, contentBGColor, borderColor);
        this.init();
    }

    public EntityBasicFlowChart(int x, int y, int width, int height, PlotShape shape, ChartElement element) {
        super(x, y, width, height);
        this.shape = shape;
        this.element = element;
        this.init();
    }

    public EntityBasicFlowChart(int x, int y, int width, int height, ChartElement element) {
        super(x, y, width, height);
        this.element = element;
        this.init();
    }

    private void init() {
        this.bodyGrad.setDirection(GradientPlot.GradientDirection.ButtomToTop);
        this.bodyHighlightGrad.setDirection(GradientPlot.GradientDirection.ButtomToTop);
        this.bodyConnectedGrad.setDirection(GradientPlot.GradientDirection.ButtomToTop);
        this.showTitle = false;
        this.connectorColor = new Color(83, 105, 174);
        this.contentsHorizontalAlignment = 1;
        this.contentsVerticalAlignment = 11;
        this.cornerCurve = 25;
        this.contentFontColor = Color.BLACK;
        this.contentsFont = new Font("Arial", 1, 12);
        this.borderWidth = 1;
        this.showBorder = false;
    }

    protected GradientPlot getContentGradiant() {
        if (this.doShowConnecting) {
            this.contentFontColor = Color.YELLOW;
            return this.bodyConnectedGrad;
        }
        if (this.doHighlight) {
            this.contentFontColor = Color.WHITE;
            return this.bodyHighlightGrad;
        }
        this.contentFontColor = Color.BLACK;
        return this.bodyGrad;
    }

    @Override
    protected void drawContentsBackground(Graphics2D g) {
        int bw = this.borderWidth;
        if (!this.isShowBorder()) {
            bw = 0;
        }
        g.setPaint(this.getContentGradiant().generate(this.x, this.y, this.width, this.height));
        switch (this.shape) {
            case Circle: {
                g.fillArc(this.x, this.y, this.width, this.width, 0, 360);
                break;
            }
            case Rectangle: {
                g.fillRect(this.x + bw, this.y + bw, this.width - bw * 2, this.height - bw * 2);
                break;
            }
            case RoundedRectangle: {
                g.fillRoundRect(this.x + bw, this.y + bw, this.width - bw * 2, this.height - bw * 2, this.cornerCurve, this.cornerCurve);
                break;
            }
            case Oval: {
                g.fillOval(this.x, this.y, this.width, this.height);
            }
        }
        super.drawContentsBackground(g);
    }

    public static enum ChartElement {
        Start1(0),
        Start2(1),
        ManualInput(2),
        PaperTape(3),
        Card(4),
        Document(5),
        Decision(6),
        Process(7),
        Data(8),
        DirectData(9),
        SequentialData(10),
        InternalStorage(11),
        StoredData(12),
        PredefinedProcess(13),
        Preparation(14),
        ManualOperation(15),
        Display(16),
        Delay(17),
        OffPageReference(18),
        OnPageReference(19),
        LoopLimit(20),
        Terminator(21);

        int order = 0;

        private ChartElement(int order) {
            this.order = order;
        }
    }
}

