/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot.flowchart;

import java.awt.Point;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotLayoutManager;
import org.smyld.app.entityplot.EntityPlotter;
import org.smyld.app.entityplot.flowchart.EntityBasicFlowChart;

public class FCEntityLayoutManager
extends EntityPlotLayoutManager {
    int verticalPosition;
    HashMap<Integer, Vector<EntityPlotter>> levels = new HashMap();
    Vector<EntityPlotter> terminators = new Vector();

    public FCEntityLayoutManager() {
    }

    public FCEntityLayoutManager(int initWidth, int initHeight) {
        super(initWidth, initHeight);
    }

    @Override
    protected Comparator<EntityPlotter> createComparator() {
        return new Comparator<EntityPlotter>(){

            @Override
            public int compare(EntityPlotter from, EntityPlotter to) {
                return ((EntityBasicFlowChart)from).element.order - ((EntityBasicFlowChart)to).element.order;
            }
        };
    }

    @Override
    public void doLayout(HashMap<String, EntityPlotter> entities, Vector<EntityConnector> conectors, boolean force) {
        System.out.println("#################################   MAKING LAYOUT ####################################################################################");
        this.positionedEnt.clear();
        this.levels.clear();
        this.terminators.clear();
        this.entities = entities;
        this.conns = conectors;
        EntityPlotter startEntity = this.getStartElement();
        if (startEntity == null) {
            return;
        }
        this.addLevelEntity(0, startEntity);
        this.fillLevelEntity(0, startEntity);
        this.verticalPosition = this.topMargin;
        if (this.terminators.size() > 0) {
            this.addLevelEntities(this.levels.size(), this.terminators);
        }
        this.distribute(startEntity);
        int finalLevelNumber = this.levels.size();
        for (EntityPlotter check : entities.values()) {
            if (this.positionedEnt.contains(check.getId())) continue;
            this.addLevelEntity(finalLevelNumber, check);
        }
    }

    private int centerEntity(EntityPlotter ent) {
        return this.initWidth / 2 - ent.getWidth() / 2;
    }

    private void distribute(EntityPlotter curEnt) {
        curEnt.setPosition(new Point(this.centerEntity(curEnt), this.verticalPosition));
        this.positionedEnt.add(curEnt.getId());
        this.verticalPosition += curEnt.getHeight() + this.vertEntMargin;
        for (int level : this.levels.keySet()) {
            if (level <= 0) continue;
            int maxHeight = 0;
            int curPos = 0;
            for (EntityPlotter childEnt : this.levels.get(level)) {
                if (maxHeight == 0) {
                    curPos = this.centerEntity(childEnt);
                }
                if (childEnt.getHeight() > maxHeight) {
                    maxHeight = childEnt.getHeight();
                }
                childEnt.setPosition(new Point(curPos, this.verticalPosition));
                this.positionedEnt.add(childEnt.getId());
                curPos += childEnt.getWidth() + this.horzEntMargin;
            }
            this.verticalPosition += maxHeight + this.vertEntMargin;
        }
    }

    private void fillLevelEntity(int entLevel, EntityPlotter curEnt) {
        if (curEnt.getConnections() != null && curEnt.getConnections().size() > 0) {
            for (EntityConnector curConn : curEnt.getConnections()) {
                if (!curConn.getFrom().equals(curEnt)) continue;
                if (this.isTerminator((EntityBasicFlowChart)curConn.getTo())) {
                    this.terminators.add(curConn.getTo());
                    continue;
                }
                this.addLevelEntity(entLevel + 1, curConn.getTo());
                this.fillLevelEntity(entLevel + 1, curConn.getTo());
            }
        }
    }

    private EntityPlotter getStartElement() {
        for (EntityPlotter curEnt : this.entities.values()) {
            EntityBasicFlowChart chartEnt = (EntityBasicFlowChart)curEnt;
            if (chartEnt.element != EntityBasicFlowChart.ChartElement.Start1 && chartEnt.element != EntityBasicFlowChart.ChartElement.Start2) continue;
            return curEnt;
        }
        return null;
    }

    private boolean isTerminator(EntityBasicFlowChart chartEnt) {
        return chartEnt.element == EntityBasicFlowChart.ChartElement.Terminator;
    }

    private void addLevelEntity(int level, EntityPlotter ent) {
        Vector<EntityPlotter> levelEnts = this.levels.get(level);
        if (levelEnts == null) {
            levelEnts = new Vector();
        }
        levelEnts.add(ent);
        this.levels.put(level, levelEnts);
    }

    private void addLevelEntities(int level, Collection<EntityPlotter> ents) {
        Vector<EntityPlotter> levelEnts = this.levels.get(level);
        if (levelEnts == null) {
            levelEnts = new Vector();
        }
        levelEnts.addAll(ents);
        this.levels.put(level, levelEnts);
    }

    @Override
    public void reset() {
        super.reset();
        this.verticalPosition = 0;
        this.levels.clear();
    }
}

