/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot.flowchart;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.smyld.app.entityplot.EntityConnector;
import org.smyld.app.entityplot.EntityPlotLayoutManager;
import org.smyld.app.entityplot.EntityPlotter;
import org.smyld.app.entityplot.GUIPlotter;
import org.smyld.app.entityplot.OrthogonalEntityConnector;
import org.smyld.app.entityplot.flowchart.EntityBasicFlowChart;
import org.smyld.app.entityplot.flowchart.FCEntityLayoutManager;

public class FlowChartPlotter
extends GUIPlotter {
    @Override
    protected EntityPlotLayoutManager createManager() {
        return new FCEntityLayoutManager();
    }

    @Override
    public void connectEntities(EntityPlotter from, EntityPlotter to, Color conColor) {
        EntityBasicFlowChart frm = (EntityBasicFlowChart)from;
        if (frm.element == EntityBasicFlowChart.ChartElement.Decision) {
            this.processDecisionConnection(from, to, conColor);
        } else if (this.isStartElement(frm)) {
            this.processStartElementConnection(frm, to, conColor);
        } else {
            super.connectEntities(from, to, conColor);
        }
    }

    private boolean isStartElement(EntityBasicFlowChart ent) {
        return ent.element == EntityBasicFlowChart.ChartElement.Start1 || ent.element == EntityBasicFlowChart.ChartElement.Start2;
    }

    private void processStartElementConnection(EntityBasicFlowChart ent, EntityPlotter to, Color conColor) {
        if (ent.getConnectedEntities() != null && ent.getConnectedEntities().size() > 0) {
            int answer = JOptionPane.showConfirmDialog(this.sccontainer != null ? this.sccontainer : null, "The start element already connected, do you want to replace it?");
            if (answer != 0) {
                return;
            }
            super.deleteConnector(ent.getConnections().get(0));
        }
        super.connectEntities(ent, to, conColor);
    }

    private void processDecisionConnection(EntityPlotter from, EntityPlotter to, Color conColor) {
        Object[] possibilities;
        String response = (String)JOptionPane.showInputDialog(this.sccontainer != null ? this.sccontainer : null, "Do you want to connect when condition is met?", "Condition Direction", -1, null, possibilities = new Object[]{"Yes", "No"}, "Yes");
        if (response != null) {
            EntityConnector entCon = this.getCommentedConnection(from, response, true);
            if (entCon != null) {
                int answer = JOptionPane.showConfirmDialog(this.sccontainer != null ? this.sccontainer : null, "The " + response + " connection already available, do you want to replace it?");
                if (answer != 0) {
                    return;
                }
                super.deleteConnector(entCon);
            }
            conColor = response.equals("Yes") ? new Color(251, 172, 66) : new Color(131, 42, 42);
            super.connectEntities(from, to, conColor, response);
        }
    }

    @Override
    protected EntityConnector createConnector(EntityPlotter from, EntityPlotter to, Color conColor) {
        return new OrthogonalEntityConnector(from, to, from.getConnectorSize(), conColor);
    }

    @Override
    protected EntityConnector createConnector(EntityPlotter from, EntityPlotter to, Color conColor, String commentText) {
        return new OrthogonalEntityConnector(from, to, from.getConnectorSize(), conColor, commentText);
    }
}

