/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.entityplot.flowchart.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.smyld.app.entityplot.PlotShape;
import org.smyld.app.entityplot.flowchart.EntityBasicFlowChart;

public class FlowChartDecision
extends EntityBasicFlowChart {
    int x0 = 0;
    int y0 = 0;
    int x1 = 0;
    int y1 = 0;
    int x2 = 0;
    int y2 = 0;
    int x3 = 0;
    int y3 = 0;
    private static final int curve = 14;

    public FlowChartDecision(int x, int y, int width, int height) {
        super(x, y, width, height, PlotShape.Free, EntityBasicFlowChart.ChartElement.Decision);
        this.computePoints(x, y);
        this.bodyGrad.setFromColor(new Color(251, 172, 66));
        this.bodyGrad.setToColor(new Color(253, 230, 199));
    }

    private void computePoints(int origX, int origY) {
        int dis = 7;
        this.x0 = origX + dis;
        this.y0 = origY + this.height / 2;
        this.x1 = origX + this.width / 2;
        this.y1 = origY + dis;
        this.x2 = origX + this.width - dis;
        this.y2 = origY + this.height / 2;
        this.x3 = origX + this.width / 2;
        this.y3 = origY + this.height - dis;
    }

    @Override
    protected void plotShadow(Graphics2D g) {
        g.setStroke(new BasicStroke(14.0f, 1, 1));
        System.out.println("Drop shadow is called");
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        this.computePoints(this.x + this.shLen, this.y + this.shLen);
        Shape result = this.drawDecisionBody();
        g.draw(result);
        g.fill(result);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        this.computePoints(this.x + this.shLen - 1, this.y + this.shLen - 1);
        result = this.drawDecisionBody();
        g.draw(result);
        g.fill(result);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.4f));
        this.computePoints(this.x + this.shLen - 2, this.y + this.shLen - 2);
        result = this.drawDecisionBody();
        g.draw(result);
        g.fill(result);
    }

    @Override
    protected void paintBody(Graphics2D g) {
        this.computePoints(this.x, this.y);
        g.setPaint(this.getContentGradiant().generate(this.x, this.y, this.width, this.height));
        g.setStroke(new BasicStroke(14.0f, 1, 1));
        Shape result = this.drawDecisionBody();
        g.draw(result);
        g.fill(result);
    }

    private Shape drawDecisionBody() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.x0, this.y0);
        gp.lineTo(this.x1, this.y1);
        gp.lineTo(this.x2, this.y2);
        gp.lineTo(this.x3, this.y3);
        gp.lineTo(this.x0, this.y0);
        gp.closePath();
        return gp;
    }

    @Override
    protected void paintContents(Graphics2D g, int th) {
        super.paintContents(g, th);
    }

    private void adjustToTextSize(Graphics2D g) {
        String[] conts;
        if (this.contents != null && (conts = this.contents.split("\n")).length >= 1) {
            Rectangle2D rectFirstLine = this.contentsFont.getStringBounds(conts[0], g.getFontRenderContext());
            double singleLineHeight = rectFirstLine.getHeight();
            int lineNo = conts.length;
            int totalTextHeight = (int)((double)lineNo * singleLineHeight) + (lineNo - 1) * this.textLineMargin;
            int upperLineX = (int)(rectFirstLine.getWidth() / 2.0);
            boolean isEven = lineNo % 2 == 0;
            System.out.println("Single line height is : " + singleLineHeight);
            System.out.println("Number of lines are   : " + lineNo);
            System.out.println("Total text height is  : " + totalTextHeight);
            System.out.println("Uppder line X is      : " + upperLineX);
            System.out.println("lines number is " + (isEven ? "Even" : "Odd"));
        }
    }
}

