/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.spe.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smyld.app.pe.annotations.PEGUIBuilder;
import org.smyld.app.pe.annotations.PELayoutHandler;
import org.smyld.app.pe.model.GUIToolkit;
import org.smyld.app.pe.model.LayoutType;
import org.smyld.app.spe.factory.AbstractFactory;
import org.smyld.reflections.AnnotatedType;
import org.smyld.reflections.SMYLDReflections;
import org.springframework.stereotype.Component;

@Component
public class SPEFactory
implements AbstractFactory {
    Logger logger = LoggerFactory.getLogger(SPEFactory.class);
    private Set<AnnotatedType<PELayoutHandler>> layoutHandlers;
    private Set<AnnotatedType<PEGUIBuilder>> guiBuilders;

    public SPEFactory() {
        this.init();
    }

    private void init() {
        String buildersPackage = "org.smyld";
        SMYLDReflections smyldReflections = new SMYLDReflections(buildersPackage, new Scanner[0]);
        this.guiBuilders = smyldReflections.loadTypesAnnotatedWith(PEGUIBuilder.class);
        this.layoutHandlers = smyldReflections.loadTypesAnnotatedWith(PELayoutHandler.class);
    }

    private <T extends Annotation> void printDetectedObjects(Class<?> objClass, ArrayList<T> collection) {
        if (collection.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Found : " + collection.size() + " instances of \n" + objClass.getSimpleName() + "\n");
        collection.forEach(curObj -> sb.append("\t" + curObj + "  => " + curObj.annotationType().getName() + "\n"));
        this.logger.info(sb.toString());
    }

    public AnnotatedType<PEGUIBuilder> getGUIBuilder(GUIToolkit toolkit) {
        Optional<AnnotatedType> result = this.guiBuilders.stream().filter(curBuilder -> ((PEGUIBuilder)curBuilder.getAnnotation()).guiToolkit() == toolkit).findFirst();
        return result.get();
    }

    public AnnotatedType<PELayoutHandler> getLayoutHandler(GUIToolkit toolkit, LayoutType layoutType) {
        Optional<AnnotatedType> result = this.layoutHandlers.stream().filter(curBuilder -> ((PELayoutHandler)curBuilder.getAnnotation()).guiToolkit() == toolkit && ((PELayoutHandler)curBuilder.getAnnotation()).layoutType() == layoutType).findFirst();
        return result.get();
    }

    public Set<AnnotatedType<PEGUIBuilder>> getGuiBuilders() {
        return this.guiBuilders;
    }

    public Set<AnnotatedType<PELayoutHandler>> getLayoutHandlers() {
        return this.layoutHandlers;
    }
}

