/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.app.spe.service;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smyld.app.pe.annotations.PEApplicationReader;
import org.smyld.app.pe.annotations.PEApplicationSource;
import org.smyld.app.pe.annotations.PEGUIBuilder;
import org.smyld.app.pe.annotations.PEGenerateApplication;
import org.smyld.app.pe.annotations.PELayoutHandler;
import org.smyld.app.pe.annotations.PEReadApplication;
import org.smyld.app.pe.input.json.PEAppJsonReader;
import org.smyld.app.pe.input.xml.PEAppXMLReader;
import org.smyld.app.pe.input.yaml.PEAppYamlReader;
import org.smyld.app.pe.model.ApplicationReader;
import org.smyld.app.spe.factory.SPEFactory;
import org.smyld.app.spe.util.CommandLineHandler;
import org.smyld.reflections.AnnotatedType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Service;

@Service
public class PEManagerService {
    Logger logger = LoggerFactory.getLogger(PEManagerService.class);
    @Autowired
    private CommandLineHandler commandLineHandler;
    @Autowired
    private SPEFactory factory;
    private AnnotatedType<PEGUIBuilder> peGUIBuilder;
    private AnnotatedType<PELayoutHandler> peLayoutHandler;
    public static final String LOG_APP_RECIEVE_MESSAGE = "Portal Engine should now process single application file ";

    public void processCommandLine(ApplicationArguments args) {
        this.commandLineHandler.processCommandLine(args);
    }

    public void processSingleApplication(String appFile, ApplicationArguments args) {
        this.logger.info(LOG_APP_RECIEVE_MESSAGE + appFile);
        try {
            ApplicationReader reader = this.getProperApplicationReader(appFile);
            this.logger.info("Application Toolkit : " + reader.getGUIToolkit());
            this.peGUIBuilder = this.factory.getGUIBuilder(reader.getGUIToolkit());
            this.logger.info("Application reader found for the given toolkit : " + ((PEGUIBuilder)this.peGUIBuilder.getAnnotation()).guiToolkit() + " ==> " + this.peGUIBuilder.getAnnotatedClass().getName());
            this.peLayoutHandler = this.factory.getLayoutHandler(reader.getGUIToolkit(), reader.getLayout());
            this.logger.info("Layout Handler found for the given toolkit : " + this.peLayoutHandler);
            ApplicationReader applicationReader = this.handleApplicationFile(appFile);
            if (applicationReader != null) {
                this.logger.info("Application reader was successfully created, invoking the Application generator now");
                this.handleApplicationGeneration(applicationReader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ApplicationReader handleApplicationFile(String appFile) throws Exception {
        System.out.println(" ================ " + this.peLayoutHandler.getAnnotatedClass());
        this.peLayoutHandler.instantiate();
        Object hostObj = this.peLayoutHandler.getHostObject();
        for (Method curMethod : hostObj.getClass().getMethods()) {
            if (!curMethod.isAnnotationPresent(PEReadApplication.class)) continue;
            if (!curMethod.getReturnType().isAssignableFrom(ApplicationReader.class)) {
                throw new RuntimeException("Returned object should be an Application Reader instance ");
            }
            for (Parameter curParam : curMethod.getParameters()) {
                if (!curParam.isAnnotationPresent(PEApplicationSource.class)) continue;
                Object result = curMethod.invoke(hostObj, appFile);
                return (ApplicationReader)result;
            }
        }
        return null;
    }

    private void handleApplicationGeneration(ApplicationReader applicationReader) throws Exception {
        this.peGUIBuilder.instantiate();
        Object hostObj = this.peGUIBuilder.getHostObject();
        for (Method curMethod : hostObj.getClass().getMethods()) {
            if (!curMethod.isAnnotationPresent(PEGenerateApplication.class)) continue;
            for (Parameter curParam : curMethod.getParameters()) {
                if (!curParam.isAnnotationPresent(PEApplicationReader.class)) continue;
                Object object = curMethod.invoke(hostObj, applicationReader);
            }
        }
    }

    private ApplicationReader getProperApplicationReader(String appFile) throws Exception {
        if (appFile.endsWith("xml")) {
            return new PEAppXMLReader(appFile);
        }
        if (appFile.endsWith("yaml")) {
            return new PEAppYamlReader(appFile);
        }
        if (appFile.endsWith("json")) {
            return new PEAppJsonReader(appFile);
        }
        throw new RuntimeException("Format not supported ... ");
    }

    public AnnotatedType<PEGUIBuilder> getPeGUIBuilder() {
        return this.peGUIBuilder;
    }

    public AnnotatedType<PELayoutHandler> getPeLayoutHandler() {
        return this.peLayoutHandler;
    }
}

